/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS, Category.PERMISSIONS})
public class TestCustomFieldsNoSearcherPermissions
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestCustomFieldsNoSearcherPermissions.xml");
    }

    public void testEditCustomFieldSetSearcherToNone() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("edit_User picker");
        this.tester.setFormElement("name", "User picker");
        this.tester.selectOption("searcher", "None");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Issue Level Security Scheme(s): TestScheme");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("edit_multigrouppicker");
        this.tester.setFormElement("name", "multigrouppicker");
        this.tester.selectOption("searcher", "None");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Issue Level Security Scheme(s): TestScheme");
    }

    public void testDeleteCustomField() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("del_customfield_10000");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): TestScheme");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("del_customfield_10001");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Permission Scheme(s): Default Permission Scheme");
        this.tester.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): TestScheme");
    }

    public void testAddCustomFieldWithoutSearcherToPermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.clickLink("add_perm_" + ProjectPermissions.CREATE_ISSUES.permissionKey());
        this.tester.checkCheckbox("type", "userCF");
        this.tester.selectOption("userCF", "nosearchercf");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("Custom field &#39;nosearchercf&#39; is not indexed for searching - please add a Search Template to this Custom Field.");
    }

    public void testAddCustomFieldWithoutSearcherToIssueLevelPermission() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("add_TestLevel");
        this.tester.checkCheckbox("type", "userCF");
        this.tester.selectOption("userCF", "nosearchercf");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("Custom field &#39;nosearchercf&#39; is not indexed for searching - please add a Search Template to this Custom Field.");
    }

    public void testAddingSearcherToCustomField() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("edit_nosearchercf");
        this.tester.selectOption("searcher", "User Picker & Group Searcher");
        this.tester.submit("Update");
        this.tester.clickLink("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("add_perm_" + ProjectPermissions.MOVE_ISSUES.permissionKey());
        this.tester.checkCheckbox("type", "userCF");
        this.tester.selectOption("userCF", "nosearchercf");
        this.tester.submit(" Add ");
        this.tester.assertTextPresent("Default Permission Scheme");
        String response = this.tester.getDialog().getResponseText();
        this.assertions.text().assertTextSequence(response, "Move Issues", "nosearchercf");
    }

    public void testRemovingCustomField() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_" + ProjectPermissions.EDIT_ISSUES.permissionKey() + "_customfield_10000");
        this.tester.submit("Delete");
        this.tester.clickLink("security_schemes");
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("delGroup_customfield_10000_TestLevel");
        this.tester.submit("Delete");
        this.tester.clickLink("view_custom_fields");
        this.tester.clickLink("del_customfield_10000");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Custom Fields");
        this.tester.assertTextNotPresent("User picker");
    }

    public void testDeleteIssueSecurityLevelFlushesCache() {
        this.administration.permissionSchemes().defaultScheme().grantPermissionToSingleUser(ProjectPermissions.SET_ISSUE_SECURITY, "admin");
        this.administration.project().associateIssueLevelSecurityScheme("homosapien", "TestScheme");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("add_TestLevel");
        this.tester.checkCheckbox("type", "user");
        this.tester.setFormElement("user", "admin");
        this.tester.submit(" Add ");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("TestLevel");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Update");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("delGroup_admin_TestLevel");
        this.tester.submit("Delete");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextPresent("TestLevel");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("delGroup_customfield_10000_TestLevel");
        this.tester.submit("Delete");
        this.tester.clickLink("security_schemes");
        this.tester.clickLinkWithText("Security Levels");
        this.tester.clickLink("delGroup_customfield_10001_TestLevel");
        this.tester.submit("Delete");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertTextNotPresent("TestLevel");
    }
}

