/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebLink;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS})
public class TestCustomFields
extends JIRAWebTest {
    private static final String CUSTOM_FIELD_NAME_ONE = "Assigned to Section";
    private static final String CUSTOM_FIELD_NAME_TWO = "Affects Project";
    private static final String CUSTOM_FIELD_NAME_THREE = "Time created";
    private static final String CUSTOM_FIELD_NAME_CASCADING_SELECT = "cascading select field name";
    private static final String CUSTOM_FIELD_NAME_MULTI_CHECKBOX = "multicheckboxes field name";
    private static final String CUSTOM_FIELD_NAME_MULTI_SELECT = "multiselect field name";
    private static final String CUSTOM_FIELD_NAME_PROJECT_PICKER = "project picker field name";
    private static final String CUSTOM_FIELD_NAME_TEXT_FIELD = "text field field name";
    private static final String CUSTOM_FIELD_NAME_DATE_TIME = "date time field name";
    private static final String CUSTOM_FIELD_NAME_USER_PICKER = "user picker field name";
    private static final String CUSTOM_FIELD_NAME_MULTI_USER_PICKER = "multi user picker field name";
    private static final String CUSTOM_FIELD_NAME_DATE_PICKER = "date picker field name";
    private static final String CUSTOM_FIELD_NAME_FREE_TEXT = "free text field name";
    private static final String CUSTOM_FIELD_NAME_NUMBER = "number field name";
    private static final String CUSTOM_FIELD_NAME_RADIO_BUTTONS = "radio buttons field name";
    private static final String CUSTOM_FIELD_NAME_SELECT_LIST = "select list field name";
    private static final String CUSTOM_FIELD_NAME_URL_FIELD = "url field name";
    private static final String CUSTOM_FIELD_NAME_VERSION_PICKER = "version picker field name";
    private static final String PARAM_NAME_SELECTED_OPTION_VALUE = "&selectedValue=";
    private static final String GLOBAL_SCOPE = "global";
    private static final String PROJECT_SCOPE = "project";
    private static final String[] customFieldNames = new String[]{"cascading select field name", "multicheckboxes field name", "multiselect field name", "project picker field name", "text field field name", "date time field name", "user picker field name", "date picker field name", "free text field name", "number field name", "radio buttons field name", "select list field name", "url field name", "version picker field name"};
    private static final String freeTextEntry = "This is the default text area value\n with newlines possible\n and stuff.";
    private static final String numberEntry = "43";
    private static final String textEntry = "Text Field - This is the default text";
    private static final String urlEntry = "http://www.testhis.com";
    private static final String userEntry = "custom_field_user";
    private static final String version_oneDotOne = "1.1";
    private static final String version_oneDotTwo = "1.2";
    private static final String summary = "This is the summary of this issue.";
    private String issueKey1;
    private String issueKey2;
    private String issueKey3;
    private String fieldId_global;
    private String fieldId_issue;
    private String fieldId_project;
    private String cascadingSelectId;
    private String datePickerId;
    private String userPickerId;
    private String multiUserPickerId;
    private String versionPickerId;
    private String freeTextId;
    private String multiSelectId;
    private String multiCheckboxId;
    private String projectPickerId;
    private String radioButtonId;
    private String selectListId;
    private String textFieldId;
    private String urlId;
    private String dateTimeId;
    private String numberId;
    private String version_oneDotOneId;
    private String version_oneDotTwoId;
    private String project_Homosap_Id;
    private String project_Neo_Id;

    public TestCustomFields(String name) {
        super(name);
    }

    private void restoreDataForTest() {
        this.restoreData("TestCustomFields.xml");
        this.issueKey1 = "HSP-1";
        this.issueKey2 = "HSP-2";
        this.issueKey3 = "NDT-1";
        this.project_Homosap_Id = "10000";
        this.project_Neo_Id = "10010";
        this.version_oneDotOneId = "10010";
        this.version_oneDotTwoId = "10011";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReturnUrl() {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.restoreBlankInstance();
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
            this.tester.clickLink("add_custom_fields");
            this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
            this.pressCancel();
            this.tester.assertTitleEquals("Custom Fields - jWebTest JIRA installation");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    private void pressCancel() {
        TestCustomFields.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.tester.setWorkingForm("jiraform");
        this.tester.clickLink("cancelButton");
    }

    public void testCustomFields() {
        this.restoreDataForTest();
        this.customFieldsAddField();
        this.customFieldsDeleteField();
        this.customFieldsAddCustomFieldOption();
        this.customFieldsdelCustomFieldOption();
        this.customFieldCreateIssueWithCustomFields();
        this.customFieldCreateIssueWithFieldScope();
        this.customFieldsEditIssueWithCustomFields();
        this.customFieldEditIssueWithFieldScope();
        this.customFieldsMoveIssueWithCustomFieldsforProject();
        this.customFieldWithFieldScreenSchemes();
        this.customFieldsMoveIssueWithCustomFieldsforIssueType();
        this.customFieldCreateSubTaskWithCustomFields();
    }

    public void testAllCustomFields() {
        this.restoreBlankInstance();
        this.restoreDataForTest();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.setupAllCustomFields();
        this.createAndValidateIssue();
        this.viewAndValidateIssue(false);
        this.editAndValidateIssue();
        this.viewAndValidateIssue(true);
        this.viewIssueInNavigator();
    }

    public void testNumberCustomField() {
        this.restoreBlankInstance();
        this.setupNumberField("");
        String xsrfToken = this.page.getXsrfToken();
        this.gotoPage("/secure/CreateIssueDetails.jspa?pid=10000&issuetype=2&atl_token=" + xsrfToken);
        this.tester.setFormElement("customfield_10000", "\"><script>alert(document.cookie);</script>");
        this.tester.submit("Create");
        this.tester.assertTextPresent("&#39;&quot;&gt;&lt;script&gt;alert(document.cookie);&lt;/script&gt;&#39; is an invalid number");
        this.assertFormElementWithNameHasValue("issue-create", "customfield_10000", "\"><script>alert(document.cookie);</script>");
    }

    public void testUserCustomFieldWithInvalidDefaultValue() {
        this.restoreBlankInstance();
        this.userPickerId = this.addCustomField("userpicker", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_USER_PICKER, "user picker field", null, null, null);
        this.configureDefaultCustomFieldValue(this.userPickerId, "user_does_not_exist");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("User 'user_does_not_exist' was not found in the system");
    }

    public void testMultiUserCustomFieldWithInvalidDefaultValue() {
        this.restoreBlankInstance();
        this.multiUserPickerId = this.addCustomField("multiuserpicker", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_MULTI_USER_PICKER, "multi user picker field", null, null, null);
        this.configureDefaultCustomFieldValue(this.multiUserPickerId, "user_does_not_exist");
        this.assertTextPresent("Could not find usernames: user_does_not_exist");
    }

    private void setupAllCustomFields() {
        this.setupCascadingSelect();
        this.setupDateTime("24/Aug/2005 6:00 AM");
        ArrayList<String> options = new ArrayList<String>();
        options.add("MultiSelect One");
        options.add("MultiSelect Two");
        options.add("MultiSelect Three");
        this.setupMultiSelect(options);
        this.setupProjectPicker(this.project_Homosap_Id);
        this.setupTextField(textEntry);
        this.setupUserPicker(userEntry);
        this.setupDatePicker("23/Aug/2005");
        this.setupFreeText(freeTextEntry);
        options.clear();
        options.add("MultiCheckBox One");
        options.add("MultiCheckBox Two");
        options.add("MultiCheckBox Three");
        this.setupMultiCheckboxes(options);
        this.setupNumberField(numberEntry);
        options.clear();
        options.add("Radio One");
        options.add("Radio Two");
        options.add("Radio Three");
        this.setupRadioButtons(options);
        options.clear();
        options.add("Select List One");
        options.add("Select List Two");
        options.add("Select List Three");
        this.setupSelectList(options);
        this.setupURLField(urlEntry);
        this.setupVersionPicker(this.version_oneDotOneId);
    }

    private void viewIssueInNavigator() {
        this.addColumnToIssueNavigator(customFieldNames);
        this.navigation.issueNavigator().createSearch("project = " + this.project_Homosap_Id);
        this.viewAndValidateIssue(true);
        this.restoreColumnDefaults();
    }

    private void createAndValidateIssue() {
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Bug");
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.validateAndSetCustomFieldValues(false);
    }

    private void validateAndSetCustomFieldValues(boolean edit) {
        this.assertTextPresent(CUSTOM_FIELD_NAME_CASCADING_SELECT);
        this.assertTextPresent(CUSTOM_FIELD_NAME_DATE_PICKER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_DATE_TIME);
        this.assertTextPresent(CUSTOM_FIELD_NAME_FREE_TEXT);
        this.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
        this.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_SELECT);
        this.assertTextPresent(CUSTOM_FIELD_NAME_NUMBER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_PROJECT_PICKER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_RADIO_BUTTONS);
        this.assertTextPresent(CUSTOM_FIELD_NAME_SELECT_LIST);
        this.assertTextPresent(CUSTOM_FIELD_NAME_TEXT_FIELD);
        this.assertTextPresent(CUSTOM_FIELD_NAME_URL_FIELD);
        this.assertTextPresent(CUSTOM_FIELD_NAME_USER_PICKER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_VERSION_PICKER);
        if (edit) {
            this.setWorkingForm("issue-edit");
            this.selectOption("customfield_" + this.cascadingSelectId, "Cascade One");
            this.selectOption("customfield_" + this.cascadingSelectId + ":1", "Cascade B");
            this.assertOptionEquals("customfield_" + this.cascadingSelectId, "Cascade One");
            this.assertOptionEquals("customfield_" + this.cascadingSelectId + ":1", "Cascade B");
            this.setFormElement("customfield_" + this.datePickerId, "22/Aug/05");
            this.assertFormElementEquals("customfield_" + this.datePickerId, "22/Aug/05");
            this.setFormElement("customfield_" + this.dateTimeId, "25/Aug/05 7:00 AM");
            this.assertFormElementEquals("customfield_" + this.dateTimeId, "25/Aug/05 7:00 AM");
            this.setFormElement("customfield_" + this.freeTextId, "This is the default text area value\n with newlines possible\n and stuff. edited.");
            this.assertFormElementEquals("customfield_" + this.freeTextId, "This is the default text area value\n with newlines possible\n and stuff. edited.");
            this.setFormElement("customfield_" + this.multiCheckboxId, "10017");
            this.assertFormElementEquals("customfield_" + this.multiCheckboxId, "10017");
            this.setFormElement("customfield_" + this.multiSelectId, "10013");
            this.assertFormElementEquals("customfield_" + this.multiSelectId, "10013");
            this.setFormElement("customfield_" + this.numberId, "433");
            this.assertFormElementEquals("customfield_" + this.numberId, "433");
            this.setFormElement("customfield_" + this.projectPickerId, this.project_Neo_Id);
            this.assertFormElementEquals("customfield_" + this.projectPickerId, this.project_Neo_Id);
            this.setFormElement("customfield_" + this.radioButtonId, "10020");
            this.assertRadioOptionSelected("customfield_" + this.radioButtonId, "10020");
            this.selectOption("customfield_" + this.selectListId, "Select List Three");
            this.assertFormElementEquals("customfield_" + this.selectListId, "10023");
            this.setFormElement("customfield_" + this.textFieldId, "Text Field - This is the default text edited.");
            this.assertFormElementEquals("customfield_" + this.textFieldId, "Text Field - This is the default text edited.");
            this.setFormElement("customfield_" + this.userPickerId, "admin");
            this.assertFormElementEquals("customfield_" + this.userPickerId, "admin");
            this.selectOption("customfield_" + this.versionPickerId, version_oneDotTwo);
            this.assertFormElementEquals("customfield_" + this.versionPickerId, this.version_oneDotTwoId);
            this.setFormElement("customfield_" + this.urlId, "http://www.testhis.com.au");
            this.assertFormElementEquals("customfield_" + this.urlId, "http://www.testhis.com.au");
        } else {
            this.assertOptionEquals("customfield_" + this.cascadingSelectId, "Cascade Three");
            this.assertOptionEquals("customfield_" + this.cascadingSelectId + ":1", "Cascade Beta");
            this.assertFormElementEquals("customfield_" + this.datePickerId, "23/Aug/05");
            this.assertFormElementEquals("customfield_" + this.dateTimeId, "24/Aug/05 6:00 AM");
            this.assertFormElementEquals("customfield_" + this.freeTextId, "\nThis is the default text area value\n with newlines possible\n and stuff.");
            this.assertFormElementEquals("customfield_" + this.multiCheckboxId, "10016");
            this.assertFormElementEquals("customfield_" + this.multiSelectId, "10014");
            this.assertFormElementEquals("customfield_" + this.numberId, numberEntry);
            this.assertFormElementEquals("customfield_" + this.projectPickerId, this.project_Homosap_Id);
            this.assertRadioOptionSelected("customfield_" + this.radioButtonId, "10019");
            this.assertFormElementEquals("customfield_" + this.selectListId, "10022");
            this.assertFormElementEquals("customfield_" + this.textFieldId, textEntry);
            this.assertFormElementEquals("customfield_" + this.urlId, urlEntry);
            this.assertFormElementEquals("customfield_" + this.userPickerId, userEntry);
            this.assertFormElementEquals("customfield_" + this.versionPickerId, this.version_oneDotOneId);
        }
        this.setFormElement("summary", summary);
        this.submit();
    }

    private void viewAndValidateIssue(boolean edited) {
        this.assertTextPresent(CUSTOM_FIELD_NAME_CASCADING_SELECT);
        this.assertTextPresent(CUSTOM_FIELD_NAME_DATE_PICKER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_DATE_TIME);
        this.assertTextPresent(CUSTOM_FIELD_NAME_FREE_TEXT);
        this.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
        this.assertTextPresent(CUSTOM_FIELD_NAME_MULTI_SELECT);
        this.assertTextPresent(CUSTOM_FIELD_NAME_NUMBER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_PROJECT_PICKER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_RADIO_BUTTONS);
        this.assertTextPresent(CUSTOM_FIELD_NAME_SELECT_LIST);
        this.assertTextPresent(CUSTOM_FIELD_NAME_TEXT_FIELD);
        this.assertTextPresent(CUSTOM_FIELD_NAME_URL_FIELD);
        this.assertTextPresent(CUSTOM_FIELD_NAME_USER_PICKER);
        this.assertTextPresent(CUSTOM_FIELD_NAME_VERSION_PICKER);
        if (edited) {
            this.assertTextPresent("Cascade One");
            this.assertTextPresent("Cascade B");
            this.assertTextPresent("22/Aug/05");
            this.assertTextPresent("25/Aug/05 7:00 AM");
            this.assertTextPresent(textEntry);
            this.assertTextPresent("MultiCheckBox Three");
            this.assertTextPresent("MultiSelect Two");
            this.assertTextPresent(numberEntry);
            this.assertTextPresent("homosapien");
            this.assertTextPresent("Radio Three");
            this.assertTextPresent("Select List Three");
            this.assertTextPresent(textEntry);
            this.assertTextPresent(urlEntry);
            this.assertTextPresent("admin");
            this.assertTextPresent(version_oneDotTwo);
        } else {
            this.assertTextPresent("Cascade Three");
            this.assertTextPresent("Cascade Beta");
            this.assertTextPresent("23/Aug/05");
            this.assertTextPresent("24/Aug/05 6:00 AM");
            this.assertTextPresent(textEntry);
            this.assertTextPresent("MultiCheckBox Two");
            this.assertTextPresent("MultiSelect Three");
            this.assertTextPresent(numberEntry);
            this.assertTextPresent("homosapien");
            this.assertTextPresent("Radio Two");
            this.assertTextPresent("Select List Two");
            this.assertTextPresent(textEntry);
            this.assertTextPresent(urlEntry);
            this.assertTextPresent(userEntry);
            this.assertTextPresent(version_oneDotOne);
        }
    }

    private void editAndValidateIssue() {
        this.clickLink("edit-issue");
        this.validateAndSetCustomFieldValues(true);
    }

    private void setupVersionPicker(String version) {
        this.versionPickerId = this.addCustomField("version", PROJECT_SCOPE, CUSTOM_FIELD_NAME_VERSION_PICKER, "version picker field", null, "homosapien", null);
        this.configureDefaultCustomFieldValue(this.versionPickerId, version);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_VERSION_PICKER);
    }

    private void setupURLField(String url) {
        this.urlId = this.addCustomField("url", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_URL_FIELD, "url field", null, null, null);
        this.configureDefaultCustomFieldValue(this.urlId, url);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_URL_FIELD);
    }

    private void setupSelectList(Collection options) {
        this.selectListId = this.addCustomField("select", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_SELECT_LIST, "select list field", null, null, null);
        for (Object option1 : options) {
            String option = (String)option1;
            this.configureCustomFieldOption(this.selectListId, option);
        }
        this.configureDefaultCustomFieldValue(this.selectListId, "10022");
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_SELECT_LIST);
    }

    private void setupRadioButtons(Collection options) {
        this.radioButtonId = this.addCustomField("radiobuttons", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_RADIO_BUTTONS, "radio buttons field", null, null, null);
        for (Object option1 : options) {
            String option = (String)option1;
            this.configureCustomFieldOption(this.radioButtonId, option);
        }
        this.configureDefaultCustomFieldValue(this.radioButtonId, "10019");
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_RADIO_BUTTONS);
    }

    private void setupNumberField(String defaultValue) {
        this.numberId = this.addCustomField("float", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_NUMBER, "number field", null, null, "Number Searcher");
        if (StringUtils.isNotEmpty((String)defaultValue)) {
            this.configureDefaultCustomFieldValue(this.numberId, defaultValue);
        }
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_NUMBER);
    }

    private void setupMultiCheckboxes(Collection options) {
        this.multiCheckboxId = this.addCustomField("multicheckboxes", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_MULTI_CHECKBOX, "multicheckbox field", null, null, null);
        for (Object option1 : options) {
            String option = (String)option1;
            this.configureCustomFieldOption(this.multiCheckboxId, option);
        }
        this.configureDefaultCheckBoxCustomFieldValue(this.multiCheckboxId, "2");
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_MULTI_CHECKBOX);
    }

    private void setupFreeText(String text) {
        this.freeTextId = this.addCustomField("textarea", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_FREE_TEXT, "free text field", null, null, null);
        this.configureDefaultCustomFieldValue(this.freeTextId, text);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_FREE_TEXT);
    }

    private void setupDatePicker(String date) {
        this.datePickerId = this.addCustomField("datepicker", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_DATE_PICKER, "date picker field", null, null, null);
        this.configureDefaultCustomFieldValue(this.datePickerId, date);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_DATE_PICKER);
    }

    private void setupUserPicker(String user) {
        this.userPickerId = this.addCustomField("userpicker", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_USER_PICKER, "user picker field", null, null, null);
        this.configureDefaultCustomFieldValue(this.userPickerId, user);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_USER_PICKER);
    }

    private void setupTextField(String text) {
        this.textFieldId = this.addCustomField("textfield", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_TEXT_FIELD, "text field field", null, null, null);
        this.configureDefaultCustomFieldValue(this.textFieldId, text);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_TEXT_FIELD);
    }

    private void setupProjectPicker(String projectId) {
        this.projectPickerId = this.addCustomField(PROJECT_SCOPE, GLOBAL_SCOPE, CUSTOM_FIELD_NAME_PROJECT_PICKER, "project picker field", null, null, null);
        this.configureDefaultCustomFieldValue(this.projectPickerId, projectId);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_PROJECT_PICKER);
    }

    private void setupMultiSelect(Collection options) {
        this.multiSelectId = this.addCustomField("multiselect", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_MULTI_SELECT, "multiselect field", null, null, null);
        for (Object option1 : options) {
            String option = (String)option1;
            this.configureCustomFieldOption(this.multiSelectId, option);
        }
        this.configureDefaultCustomFieldValue(this.multiSelectId, "10014");
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_MULTI_SELECT);
    }

    private void setupDateTime(String dateTime) {
        this.dateTimeId = this.addCustomField("datetime", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_DATE_TIME, "date time custom field", null, null, null);
        this.configureDefaultCustomFieldValue(this.dateTimeId, dateTime);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_DATE_TIME);
    }

    private void setupCascadingSelect() {
        this.cascadingSelectId = this.addCustomField("cascadingselect", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_CASCADING_SELECT, "cascading select field", null, null, null);
        this.configureCustomFieldOption(this.cascadingSelectId, "Cascade One");
        this.configureCustomFieldOption(this.cascadingSelectId, "Cascade Two");
        this.configureCustomFieldOption(this.cascadingSelectId, "Cascade Three");
        this.clickLinkWithText("Cascade One");
        this.setFormElement("addValue", "Cascade A");
        this.submit("Add");
        this.setFormElement("addValue", "Cascade B");
        this.submit("Add");
        this.setFormElement("addValue", "Cascade C");
        this.submit("Add");
        this.clickLinkWithText("View Custom Field Configuration");
        this.clickLinkWithText("Edit Options");
        this.clickLinkWithText("Cascade Two");
        this.setFormElement("addValue", "Cascade I");
        this.submit("Add");
        this.setFormElement("addValue", "Cascade II");
        this.submit("Add");
        this.setFormElement("addValue", "Cascade III");
        this.submit("Add");
        this.clickLinkWithText("View Custom Field Configuration");
        this.clickLinkWithText("Edit Options");
        this.clickLinkWithText("Cascade Three");
        this.setFormElement("addValue", "Cascade Alhpa");
        this.submit("Add");
        this.setFormElement("addValue", "Cascade Beta");
        this.submit("Add");
        this.setFormElement("addValue", "Cascade Gamma");
        this.submit("Add");
        this.configureDefaultMultiCustomFieldValue(this.cascadingSelectId, "Cascade Three", "Cascade Beta");
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_CASCADING_SELECT);
    }

    public void testAddingACustomFieldAndEditingTheConfiguration() {
        this.restoreDataForTest();
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion");
        this.submit("nextBtn");
        this.setFormElement("fieldName", "Version Picker Custom Field");
        this.selectOption("issuetypes", "Bug");
        this.checkCheckbox(GLOBAL_SCOPE, "false");
        this.selectOption("projects", "homosapien");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.checkCheckbox("associatedScreens", "2");
        this.checkCheckbox("associatedScreens", "3");
        this.submit("Update");
        this.clickLink("config_customfield_10000");
        this.clickLinkWithText("Edit Default Value");
        this.selectOption("customfield_10000", "New Version 1");
        this.submit();
        this.clickLink("edit_10010");
        this.selectOption("issuetypes", "Bug");
        this.selectOption("issuetypes", "Improvement");
        this.submit();
    }

    public void testCustomFieldsOrdering() {
        this.restoreBlankInstance();
        TestCustomFields.log("Testing Ordering of options for multicheckboxes field");
        String fieldId = this.addCustomField("multicheckboxes", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_MULTI_CHECKBOX, "multicheckboxes field for ordering tests", null, null, null);
        this.startCustomFieldsOrderingTest(fieldId, null);
        TestCustomFields.log("Testing Ordering of options for cascading select field");
        fieldId = this.addCustomField("cascadingselect", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_CASCADING_SELECT, "cascading select field for ordering tests", null, null, null);
        String parentOption = this.startCustomFieldsOrderingTest(fieldId, null);
        TestCustomFields.log("Testing Ordering of options for a child option of the cascading select field");
        this.startCustomFieldsOrderingTest(fieldId, parentOption);
    }

    public String startCustomFieldsOrderingTest(String fieldId, String parentOption) {
        int i;
        int numberOfOptions = 6;
        String[] optionValue = new String[numberOfOptions];
        String[] optionId = new String[numberOfOptions];
        for (i = 1; i < numberOfOptions; ++i) {
            optionValue[i] = "Value_" + i;
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
            this.clickLink("config_customfield_" + fieldId);
            this.clickLinkWithText("Edit Options");
            this.assertTextPresent("Edit Options for Custom Field");
            if (parentOption != null) {
                this.clickLinkWithText(parentOption);
            }
            this.setFormElement("addValue", optionValue[i]);
            this.submit("Add");
            this.assertTextPresent(optionValue[i]);
        }
        i = 1;
        try {
            WebLink[] links;
            for (WebLink link : links = this.getDialog().getResponse().getLinks()) {
                if (!link.getID().startsWith("del_")) continue;
                optionId[i] = link.getID().substring(4, 9);
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.resetInAscendingOrdering(optionId, "Option");
        this.checkOrderingUsingArrows(optionValue, optionId);
        return this.checkOrderingUsingMoveToPos(optionValue, optionId, "Option");
    }

    public void customFieldsAddField() {
        TestCustomFields.log("Test adding a custom field");
        this.fieldId_global = this.addCustomField("radiobuttons", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_ONE, "custom field 1", null, null, null);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
    }

    public void customFieldsDeleteField() {
        TestCustomFields.log("Test deleting a custom field");
        this.deleteCustomField(this.fieldId_global);
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.assertTextNotPresent(CUSTOM_FIELD_NAME_ONE);
        this.fieldId_global = this.addCustomField("radiobuttons", GLOBAL_SCOPE, CUSTOM_FIELD_NAME_ONE, "custom field 1", null, null, null);
        TestCustomFields.log("Field: " + this.fieldId_global);
        this.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
        this.fieldId_issue = this.addCustomField(PROJECT_SCOPE, "issuetype", CUSTOM_FIELD_NAME_TWO, "custom field 2", "Bug", null, null);
        TestCustomFields.log("Field: " + this.fieldId_issue);
        this.assertTextPresent(CUSTOM_FIELD_NAME_TWO);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_TWO);
        this.fieldId_project = this.addCustomField("datetime", PROJECT_SCOPE, CUSTOM_FIELD_NAME_THREE, "custom field 3", null, "homosapien", null);
        TestCustomFields.log("Field: " + this.fieldId_project);
        this.assertTextPresent(CUSTOM_FIELD_NAME_THREE);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_THREE);
    }

    public void customFieldsAddCustomFieldOption() {
        TestCustomFields.log("Test adding a custom field option");
        this.addCustomFieldOption("customfield_" + this.fieldId_global, "Blue");
        this.assertTextPresent("Blue");
    }

    public void customFieldsdelCustomFieldOption() {
        TestCustomFields.log("Test deleting a custom field option");
        this.delCustomFieldOption("customfield_" + this.fieldId_global, "10000");
        this.assertTextPresent("There are currently no options available for this select list");
        this.addCustomFieldOption("customfield_" + this.fieldId_global, "Blue");
        this.addCustomFieldOption("customfield_" + this.fieldId_global, "Red");
        this.addCustomFieldOption("customfield_" + this.fieldId_global, "White");
    }

    public void customFieldCreateIssueWithCustomFields() {
        TestCustomFields.log("Create an issue with custom fields");
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Bug");
        this.setFormElement("summary", "issue with custom fields");
        this.selectOption("priority", "Minor");
        this.getDialog().setFormParameter("customfield_" + this.fieldId_global, "10001");
        this.assertRadioOptionSelected("customfield_" + this.fieldId_global, "10001");
        this.selectOption("customfield_" + this.fieldId_issue, "homosapien");
        this.setFormElement("customfield_" + this.fieldId_project, "27/Jan/05 6:00 am");
        this.submit("Create");
        this.assertTextPresent("Details");
        this.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.assertTextPresent(CUSTOM_FIELD_NAME_TWO);
        this.assertTextPresent(CUSTOM_FIELD_NAME_THREE);
        this.clickLink("delete-issue");
        this.submit("Delete");
    }

    public void customFieldCreateIssueWithFieldScope() {
        TestCustomFields.log("Test the availibility of custom fields using field scope for creating an issue");
        this.getNavigation().issue().goToCreateIssueForm("neanderthal", "Bug");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Improvement");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.assertFormElementPresent("customfield_" + this.fieldId_project);
    }

    public void customFieldsEditIssueWithCustomFields() {
        TestCustomFields.log("Edit Issue: " + this.issueKey1 + " with custom fields");
        this.gotoIssue(this.issueKey1);
        this.clickLink("edit-issue");
        this.getDialog().setFormParameter("customfield_" + this.fieldId_global, "10001");
        this.assertRadioOptionSelected("customfield_" + this.fieldId_global, "10001");
        this.selectOption("customfield_" + this.fieldId_issue, "homosapien");
        this.setFormElement("customfield_" + this.fieldId_project, "27/Jan/05 6:00 am");
        this.submit("Update");
        this.assertTextPresent("Details");
        this.assertTextPresent(CUSTOM_FIELD_NAME_ONE);
        this.assertTextPresent(CUSTOM_FIELD_NAME_TWO);
        this.assertTextPresent(CUSTOM_FIELD_NAME_THREE);
    }

    public void customFieldEditIssueWithFieldScope() {
        TestCustomFields.log("Test the availibility of custom fields using field scope for updating an issue");
        this.gotoIssue(this.issueKey3);
        this.clickLink("edit-issue");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.gotoIssue(this.issueKey2);
        this.clickLink("edit-issue");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.assertFormElementPresent("customfield_" + this.fieldId_project);
    }

    public void customFieldsMoveIssueWithCustomFieldsforProject() {
        TestCustomFields.log("Test the availibility of custom fields using field scope for moving an issue to a different project");
        this.gotoIssue(this.issueKey3);
        this.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.submit();
        this.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.assertFormElementPresent("customfield_" + this.fieldId_project);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_global);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.gotoIssue(this.issueKey2);
        this.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal");
        this.navigation.issue().selectIssueType("Bug");
        this.submit();
        this.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_global);
    }

    public void customFieldsMoveIssueWithCustomFieldsforIssueType() {
        TestCustomFields.log("Test the availibility of custom fields using field scope for moving an issue to a different issue type");
        this.gotoIssue(this.issueKey3);
        this.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.submit();
        this.assertTextPresent("Update the fields of the issue to relate to the new project.");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_global);
        this.assertFormElementPresent("customfield_" + this.fieldId_project);
    }

    public void customFieldCreateSubTaskWithCustomFields() {
        this.activateSubTasks();
        this.gotoIssue(this.issueKey1);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.assertFormElementPresent("customfield_" + this.fieldId_project);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.gotoIssue(this.issueKey3);
        this.clickLink("create-subtask");
        this.assertTextPresent("Create Sub-Task");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.deactivateSubTasks();
    }

    public void customFieldWithFieldScreenSchemes() {
        TestCustomFields.log("Test the availabilty of custom fields using the field screen schemes");
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Bug");
        this.assertFormElementPresent("customfield_" + this.fieldId_global);
        this.assertFormElementPresent("customfield_" + this.fieldId_project);
        this.assertFormElementPresent("customfield_" + this.fieldId_issue);
        this.removeFieldFromFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME_ONE});
        this.removeFieldFromFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME_TWO});
        this.removeFieldFromFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME_THREE});
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Bug");
        this.assertFormElementNotPresent("customfield_" + this.fieldId_global);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_project);
        this.assertFormElementNotPresent("customfield_" + this.fieldId_issue);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_ONE);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_TWO);
        this.addFieldToFieldScreen("Default Screen", CUSTOM_FIELD_NAME_THREE);
    }

    public void testCustomFieldUserCFPermissions() {
        this._testViewIssueMultiUserCFPermissionScheme();
        this._testViewIssueMultiUserCFIssueLevelSecurity();
    }

    public void testVersionCustomFieldPromptsForValuesInMove() {
        this.restoreData("TestVersionCustomFields.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("move-issue");
        this.navigation.issue().selectProject("monkey");
        this.submit();
        this.assertTextPresent("multi version picker cf");
        this.selectOption("customfield_10000", "New Version 3");
        this.assertTextPresent("single version picker cf");
        this.selectOption("customfield_10001", "New Version 3");
        this.submit();
        this.submit("Move");
        this.gotoIssue("MKY-1");
        this.assertTextPresent("New Version 3");
        this.assertTextNotPresent("New Version 2");
        this.assertTextNotPresent("New Version 1");
    }

    public void testVersionCustomFieldPromptsForValuesInBulkMove() {
        this.restoreData("TestVersionCustomFields.xml");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssue("HSP-1");
        this.chooseOperationBulkMove();
        this.navigation.issue().selectProject("monkey", "10010_1_pid");
        this.navigation.clickOnNext();
        this.assertTextPresent("multi version picker cf");
        this.selectOption("customfield_10000_10010", "New Version 3");
        this.selectOption("customfield_10000_10011", "New Version 3");
        this.assertTextPresent("single version picker cf");
        this.selectOption("customfield_10001_10011", "New Version 3");
        this.navigation.clickOnNext();
        this.navigation.clickOnNext();
        this.gotoIssue("MKY-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10000"), "New Version 3");
        this.text.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10001"), "New Version 3");
        this.assertTextNotPresent("New Version 2");
        this.assertTextNotPresent("New Version 1");
    }

    private void _testViewIssueMultiUserCFIssueLevelSecurity() {
        this.restoreData("multiuser_cf_issue_perm.xml");
        this._testViewIssuePerm();
    }

    private void _testViewIssueMultiUserCFPermissionScheme() {
        this.restoreData("multiuser_cf_perm_scheme.xml");
        this._testViewIssuePerm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testViewIssuePerm() {
        try {
            this.logout();
            this.login("bob", "bob");
            this.gotoIssue("HSP-1");
            this.assertTextPresent("This is a test issue");
            this.logout();
            this.login("admin", "admin");
            this.showIssues("project=HSP AND issuetype=bug");
            this.assertTextPresent("This is a test issue");
            this.editIssueWithCustomFields("HSP-1", "10001", "", "userpicker");
            this.logout();
            this.login("bob", "bob");
            this.gotoIssue("HSP-1");
            this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform");
            this.showIssues("project=HSP AND issuetype=bug");
            this.assertTextNotPresent("This is a test issue");
        }
        finally {
            this.logout();
            this.login("admin", "admin");
        }
    }

    public void testEditIssueTypeDoesNotCauseCustomFieldToDisappear() {
        this.restoreBlankInstance();
        String issueTypeName = "todo";
        String issueTypeId = this.addIssueType(issueTypeName, "a todo item");
        String customFieldName = "TodoTextField";
        String todoTextFieldId = this.addCustomField("textfield", GLOBAL_SCOPE, customFieldName, "field for testing todo issue type", issueTypeName, null, null);
        this.addFieldToFieldScreen("Default Screen", customFieldName);
        this.getNavigation().issue().goToCreateIssueForm("monkey", issueTypeName);
        this.setFormElement("summary", "testing todo");
        this.setFormElement("customfield_10000", "contents of the todo field");
        this.submit("Create");
        this.assertTextPresent("contents of the todo field");
        this.editIssueType(issueTypeId, issueTypeName, "a todo item");
        this.gotoIssue("MKY-1");
        this.assertTextPresent("contents of the todo field");
        this.assertTextPresent("TodoTextField:");
    }

    public void testEditSelectWithMultipleValuesFixesField() {
        this.restoreData("TestSelectCustomFieldBroken.xml");
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("HSP-1");
        this.clickLink("edit-issue");
        this.selectOption("customfield_10010", "dude");
        this.submit("Update");
        this.assertTextPresent("dude");
        this.assertTextPresent("select cf");
    }

    public void testEditUserCFWithDeletedUsersValuesSelected() {
        this.restoreData("TestUserCustomFieldBroken.xml");
        this.gotoIssue("HSP-1");
        this.assertTextNotPresent("Fred Normal");
        this.assertTextPresent("fred");
        this.assertTextPresent("user cf");
        this.clickLinkWithText("HSP-1");
        this.clickLink("edit-issue");
        this.setFormElement("customfield_10000", "admin");
        this.submit("Update");
        this.assertTextPresent("Administrator");
        this.assertTextPresent("user cf");
    }

    public void testMissingIssueTypesForCustomField() {
        this.restoreBlankInstance();
        String issueTypeId = this.addIssueType("A Thorn", "A Thorn In My Side");
        this.addCustomField("version", PROJECT_SCOPE, "versionP1", "versionP1", "A Thorn", "homosapien", null);
        this.addCustomFieldWithMultipleIssueTypes("version", PROJECT_SCOPE, "versionP2", "versionP2", new String[]{"A Thorn", "Bug"}, "homosapien", null);
        this.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=" + issueTypeId);
        this.submit("Delete");
        this.clickLink("view_custom_fields");
        this.assertTextSequence(new String[]{"versionP1", "Not configured for any context"});
        this.assertTextSequence(new String[]{"versionP2", "Issue type", "Project"});
        this.assertTextPresentBeforeText("Not configured for any context", "versionP2");
        this.clickLink("view_custom_fields");
        this.clickLink("config_customfield_10001");
        this.clickLink("edit_10011");
        this.submit("Modify");
        this.assertTextPresent("Default Configuration Scheme for versionP2");
    }

    @WebTest(value={Category.TIME_ZONES})
    public void testDateTimeCustomFieldShouldRespectUserTimeZone() throws Exception {
        String HSP_1 = "HSP-1";
        String SYDNEY_TZ = "Australia/Sydney";
        String ROME_TZ = "Europe/Rome";
        this.administration.restoreData("TestCustomFields.xml");
        this.administration.generalConfiguration().setDefaultUserTimeZone("Australia/Sydney");
        String CF_NAME = "tzAwareDateTime";
        String CF_ID = this.addCustomField("datetime", "tzAwareDateTime");
        this.addFieldToFieldScreen("Default Screen", "tzAwareDateTime");
        String DATE_1_SYDNEY = "10/Jan/99 12:00 PM";
        String DATE_1_ROME = "10/Jan/99 2:00 AM";
        this.setCustomFieldValue("HSP-1", CF_ID, "10/Jan/99 12:00 PM");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99 12:00 PM"));
        this.navigation.userProfile().changeUserTimeZone("Europe/Rome");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99 2:00 AM"));
        String DATE_2_ROME = "05/Jan/99 1:00 AM";
        String DATE_2_SYDNEY = "05/Jan/99 11:00 AM";
        this.setCustomFieldValue("HSP-1", CF_ID, "05/Jan/99 1:00 AM");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"05/Jan/99 1:00 AM"));
        this.navigation.userProfile().changeUserTimeZone("Australia/Sydney");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"05/Jan/99 11:00 AM"));
    }

    @WebTest(value={Category.TIME_ZONES})
    public void testDateCustomFieldShouldBeDisplayedInSystemTimeZone() throws Exception {
        String HSP_1 = "HSP-1";
        String ROME_TZ = "Europe/Rome";
        this.administration.restoreData("TestCustomFields.xml");
        String CF_NAME = "dateOnly";
        String CF_ID = this.addCustomField("datepicker", "dateOnly");
        this.addFieldToFieldScreen("Default Screen", "dateOnly");
        String DATE_STRING_SYDNEY = "10/Jan/99";
        this.setCustomFieldValue("HSP-1", CF_ID, "10/Jan/99");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99"));
        this.administration.generalConfiguration().setDefaultUserTimeZone("Europe/Rome");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99"));
        this.setCustomFieldValue("HSP-1", CF_ID, "10/Jan/99");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99"));
        this.navigation.userProfile().changeUserTimeZone("Europe/Rome");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99"));
        this.setCustomFieldValue("HSP-1", CF_ID, "10/Jan/99");
        Assert.assertThat((Object)this.customField("HSP-1", CF_ID).getText(), (Matcher)IsEqual.equalTo((Object)"10/Jan/99"));
    }

    protected void setCustomFieldValue(String issueKey, String cfId, String dateString) {
        this.navigation.issue().gotoEditIssue(issueKey);
        this.tester.setFormElement(String.format("customfield_%s", cfId), dateString);
        this.tester.submit();
    }

    protected CssLocator customField(String issueKey, String cfId) {
        this.navigation.issue().gotoIssue(issueKey);
        return this.locator.css(String.format("#customfield_%s-val", cfId));
    }
}

