/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.CUSTOM_FIELDS, Category.FIELDS, Category.SECURITY})
public class TestCustomFieldXss
extends FuncTestCase {
    private static final String ON_DEMAND_FEATURE = "com.atlassian.jira.config.CoreFeatures.ON_DEMAND";
    private static final String RAW_DESC_TEMPLATE = "description *wiki* markup <div>%s</div>";
    private static final String HTML_DESC_TEMPLATE = "description *wiki* markup <div>%s</div>";
    private static final String WIKI_DESC_TEMPLATE = "<p>description <b>wiki</b> markup &lt;div&gt;%s&lt;/div&gt;</p>";
    private static final String CUSTOM_FIELD_TITLE = "<div>xsstest</div>";
    private static final String CUSTOM_FIELD_WIKI = "&lt;div&gt;xsstest&lt;/div&gt;";
    private static final Iterable<String> CUSTOM_FIELD_TYPES = ImmutableList.of((Object)TestCustomFieldXss.builtInCustomFieldKey("select"), (Object)TestCustomFieldXss.builtInCustomFieldKey("radiobuttons"), (Object)TestCustomFieldXss.builtInCustomFieldKey("multicheckboxes"), (Object)TestCustomFieldXss.builtInCustomFieldKey("textfield"), (Object)TestCustomFieldXss.builtInCustomFieldKey("multiselect"), (Object)TestCustomFieldXss.builtInCustomFieldKey("userpicker"), (Object)TestCustomFieldXss.builtInCustomFieldKey("multiuserpicker"), (Object)TestCustomFieldXss.builtInCustomFieldKey("datepicker"), (Object)TestCustomFieldXss.builtInCustomFieldKey("datetime"), (Object)TestCustomFieldXss.builtInCustomFieldKey("grouppicker"), (Object)TestCustomFieldXss.builtInCustomFieldKey("multigrouppicker"));
    private static final Map<String, List<String>> SEARCHERS = ImmutableMap.builder().put((Object)TestCustomFieldXss.builtInCustomFieldKey("textsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("textfield")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("exacttextsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("url")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("daterange"), TestCustomFieldXss.toBuiltInCustomFieldKeys("datepicker")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("exactnumber"), TestCustomFieldXss.toBuiltInCustomFieldKeys("float")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("numberrange"), TestCustomFieldXss.toBuiltInCustomFieldKeys("float")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("projectsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("project")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("grouppickersearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("multigrouppicker")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("multiselectsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("select", "radiobuttons", "multicheckboxes")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("cascadingselectsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("cascadingselect")).put((Object)TestCustomFieldXss.builtInCustomFieldKey("labelsearcher"), TestCustomFieldXss.toBuiltInCustomFieldKeys("labels")).build();
    private static final ImmutableMap<String, String> SEARCHERS_NON_RENDERING = ImmutableMap.of((Object)TestCustomFieldXss.builtInCustomFieldKey("versionsearcher"), (Object)TestCustomFieldXss.builtInCustomFieldKey("version"), (Object)TestCustomFieldXss.builtInCustomFieldKey("userpickergroupsearcher"), (Object)TestCustomFieldXss.builtInCustomFieldKey("userpicker"));

    private static List<String> toBuiltInCustomFieldKeys(String ... keys) {
        ArrayList customFieldKeys = Lists.newArrayListWithCapacity((int)keys.length);
        for (String key : keys) {
            customFieldKeys.add(TestCustomFieldXss.builtInCustomFieldKey(key));
        }
        return customFieldKeys;
    }

    @Override
    protected void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    @Override
    protected void tearDownTest() {
        this.backdoor.darkFeatures().disableForSite(ON_DEMAND_FEATURE);
    }

    public void testCustomFieldDescriptionsCanBeRenderedAsRawHtmlOrWikiMarkup() throws Exception {
        for (String type : CUSTOM_FIELD_TYPES) {
            this.testSingleCustomFieldDescriptionOnCustomFieldsScreen(type);
        }
    }

    public void testCustomFieldDescriptionsCanBeRenderedAsRawHtmlOrWikiMarkUpInIssueNavigator() throws Exception {
        for (Map.Entry<String, List<String>> entry : SEARCHERS.entrySet()) {
            this.testSingleCustomFieldDescriptionOnIssueNavigatorScreen(entry.getValue(), entry.getKey());
        }
    }

    public void testCustomFieldDescriptionsInIssueNavigatorNoXss() throws Exception {
        for (Map.Entry entry : SEARCHERS_NON_RENDERING.entrySet()) {
            this.testSingleCustomFieldOnIssueNavigatorScreen((String)entry.getValue(), (String)entry.getKey());
        }
    }

    public void testCustomFieldDescriptionsInBulkChangeIssue() throws Exception {
        this.restoreDataForTest();
        this.backdoor.project().addProject("TestProject", "TEST", "admin");
        this.backdoor.issues().createIssue("TEST", "This is just a test");
        this.backdoor.darkFeatures().enableForSite(ON_DEMAND_FEATURE);
        this.navigation.issueNavigator().displayAllIssues();
        String closeIssue = "jira_2_6";
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.TRANSITION).chooseWorkflowTransition(new BulkChangeWizard.BulkOperationsCustom("jira_2_6"));
        TestCustomFieldXss.assertFalse((String)"ON_DEMAND is enabled so the description should not be rendered as html in this page", (boolean)this.getPageSource().contains(CUSTOM_FIELD_TITLE));
        TestCustomFieldXss.assertTrue((String)"ON_DEMAND is enabled so the description should be rendered as wiki markup in this page", (boolean)this.getPageSource().contains(CUSTOM_FIELD_WIKI));
    }

    private void testSingleCustomFieldOnIssueNavigatorScreen(String customFieldType, String customFieldSearcher) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", TestCustomFieldXss.fieldDescription(customFieldType), customFieldType, customFieldSearcher);
        this.backdoor.darkFeatures().enableForSite(ON_DEMAND_FEATURE);
        this.navigation.issueNavigator().displayAllIssues();
        TestCustomFieldXss.assertFalse((String)("ON_DEMAND is enabled so the description should be rendered as wiki markup for " + customFieldSearcher), (boolean)this.getPageSource().contains("<div>" + customFieldType + "</div>"));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void testSingleCustomFieldDescriptionOnIssueNavigatorScreen(List<String> customFieldTypes, String customFieldSearcher) {
        for (String customFieldType : customFieldTypes) {
            this.testSingleCustomFieldDescriptionOnIssueNavigatorScreen(customFieldType, customFieldSearcher);
        }
    }

    private void testSingleCustomFieldDescriptionOnIssueNavigatorScreen(String customFieldType, String customFieldSearcher) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", TestCustomFieldXss.fieldDescription(customFieldType), customFieldType, customFieldSearcher);
        this.backdoor.darkFeatures().disableForSite(ON_DEMAND_FEATURE);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=" + fieldId + "&decorator=none&jqlContext=");
        TestCustomFieldXss.assertTrue((String)("ON_DEMAND is disabled so the description should be rendered as raw HTML for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldXss.fieldDescriptionHtml(customFieldType)));
        this.backdoor.darkFeatures().enableForSite(ON_DEMAND_FEATURE);
        this.tester.gotoPage("secure/QueryComponentRendererEdit!Default.jspa?fieldId=" + fieldId + "&decorator=none&jqlContext=");
        TestCustomFieldXss.assertTrue((String)("ON_DEMAND is enabled so the description should be rendered as wiki markup for " + customFieldSearcher), (boolean)this.getPageSource().contains(TestCustomFieldXss.fieldDescriptionWikiFormat(customFieldType)));
        TestCustomFieldXss.assertFalse((String)("ON_DEMAND is enabled so the description should be rendered as wiki markup for " + customFieldSearcher), (boolean)this.getPageSource().contains("<div>" + customFieldType + "</div>"));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void testSingleCustomFieldDescriptionOnCustomFieldsScreen(String customFieldType) {
        String fieldId = this.backdoor.customFields().createCustomField(customFieldType + "-name", TestCustomFieldXss.fieldDescription(customFieldType), customFieldType, null);
        this.backdoor.darkFeatures().disableForSite(ON_DEMAND_FEATURE);
        this.goToCustomFields();
        TestCustomFieldXss.assertTrue((String)("ON_DEMAND is disabled so the description should be rendered as raw HTML for " + customFieldType), (boolean)this.getPageSource().contains(TestCustomFieldXss.fieldDescriptionHtml(customFieldType)));
        this.backdoor.darkFeatures().enableForSite(ON_DEMAND_FEATURE);
        this.goToCustomFields();
        TestCustomFieldXss.assertTrue((String)("ON_DEMAND is enabled so the description should be rendered as wiki markup for " + customFieldType), (boolean)this.getPageSource().contains(TestCustomFieldXss.fieldDescriptionWikiFormat(customFieldType)));
        TestCustomFieldXss.assertFalse((String)("ON_DEMAND is enabled so the description should be rendered as wiki markup for " + customFieldType), (boolean)this.getPageSource().contains("<div>" + customFieldType + "</div>"));
        this.backdoor.customFields().deleteCustomField(fieldId);
    }

    private void restoreDataForTest() {
        this.administration.restoreData("TestCustomFieldTitle.xml");
    }

    private static String fieldDescription(String fieldId) {
        return String.format("description *wiki* markup <div>%s</div>", fieldId);
    }

    private static String fieldDescriptionHtml(String fieldId) {
        return String.format("description *wiki* markup <div>%s</div>", fieldId);
    }

    private static String fieldDescriptionWikiFormat(String fieldId) {
        return String.format(WIKI_DESC_TEMPLATE, fieldId);
    }

    private void goToCustomFields() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
    }

    private String getPageSource() {
        return this.tester.getDialog().getResponseText();
    }

    private CssLocator locatorForDescription(String fieldId) {
        return this.locator.css(String.format("#custom-fields-%s-name div.description", fieldId));
    }
}

