/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.UserFilterUtils;
import com.atlassian.jira.util.json.JSONException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.CUSTOM_FIELDS})
public class TestCustomFieldUserPicker
extends FuncTestCase {
    private static final String FIELD_NAME = "Developer";
    private static final String[] ALL_GROUPS = new String[]{"jira-users", "jira-developers", "jira-administrators"};
    private static final long[] ALL_ROLE_IDS = new long[]{10000L, 10001L, 10002L};
    private static final Map<Long, String> ALL_ROLE_ID_TO_NAME_MAP = Maps.newHashMap();

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
    }

    public void testCreateAndSetDefaultValue() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createUserPickerAndGoToConfigurationPage();
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.assertTextNotPresent("fred");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.assertTextPresent("Fred Normal");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "fred");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "admin");
        this.tester.setFormElement("customfield_10000", "");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.assertFormElementEquals("customfield_10000", "");
    }

    public void testUserFilterSelection() throws JSONException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createUserPickerAndGoToConfigurationPage();
        this.assertUserFilterSummary(UserFilter.DISABLED);
        UserFilter[] testData = new UserFilter[]{UserFilter.DISABLED, this.f(this.r(new Long[0]), this.g("jira-developers")), this.f(this.r(new Long[0]), this.g("jira-developers", "jira-administrators")), this.f(this.r(new Long[0]), this.g("jira-developers", "jira-administrators", "jira-users")), this.f(this.r(10002L), this.g("jira-developers", "jira-administrators", "jira-users")), this.f(this.r(10002L, 10001L), this.g("jira-developers", "jira-administrators", "jira-users")), this.f(this.r(10002L, 10001L, 10000L), this.g("jira-developers", "jira-administrators", "jira-users")), this.f(this.r(10002L, 10001L, 10000L), this.g("jira-developers", "jira-administrators")), this.f(this.r(10002L, 10001L, 10000L), this.g("jira-developers")), this.f(this.r(10002L, 10001L, 10000L), this.g(new String[0])), this.f(this.r(10002L, 10001L), this.g(new String[0])), this.f(this.r(10002L), this.g(new String[0])), this.f(this.r(new Long[0]), this.g(new String[0]))};
        UserFilter originalUserFilter = UserFilter.DISABLED;
        for (UserFilter newUserFilter : testData) {
            this.setFilterAndAssert(originalUserFilter, newUserFilter);
            originalUserFilter = newUserFilter;
        }
    }

    public void testSetDefaultValueWithUserFilter() throws JSONException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createUserPickerAndGoToConfigurationPage();
        this.setUserFilter(this.f(this.r(new Long[0]), this.g("jira-administrators")));
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.clickLink("cancelButton");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.setUserFilter(this.f(this.r(new Long[0]), this.g("jira-administrators", "jira-developers")));
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.clickLink("cancelButton");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.setUserFilter(this.f(this.r(new Long[0]), this.g("jira-administrators", "jira-developers", "jira-users")));
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Set Default");
        this.tester.assertTextNotPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.setUserFilter(this.f(this.r(new Long[0]), this.g("jira-users")));
        this.tester.clickLink("customfield_10000-edit-default");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Set Default");
        this.tester.assertTextPresent("Fred Normal");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
    }

    public void testSetValueWithUserFilterByGroups() throws JSONException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createUserPickerAndGoToConfigurationPage();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Create");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.setUserFilter(this.f(this.r(new Long[0]), this.g("jira-developers")), true);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Create");
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent("There are no comments yet on this issue.");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Create");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.navigation.issue().gotoEditIssue("HSP-1");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Update");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Update");
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent("There are no comments yet on this issue.");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Update");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.setUserFilter(this.f(this.r(new Long[0]), this.g("jira-users")), true);
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Update");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
    }

    public void testSetValueWithUserFilterByProjectRoles() throws JSONException {
        this.administration.roles().addProjectRoleForUser("homosapien", "Administrators", "admin");
        this.administration.roles().addProjectRoleForUser("homosapien", "Users", "fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.createUserPickerAndGoToConfigurationPage();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Create");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.setUserFilter(this.f(this.r(10002L), this.g(new String[0])), true);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.tester.setFormElement("summary", "summary");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Create");
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent("There are no comments yet on this issue.");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Create");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.navigation.issue().gotoEditIssue("HSP-1");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Update");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Update");
        this.tester.assertTextPresent("User &#39;fred&#39; is not valid for this user picker.");
        this.tester.assertTextNotPresent("There are no comments yet on this issue.");
        this.tester.setFormElement("customfield_10000", "admin");
        this.tester.submit("Update");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
        this.setUserFilter(this.f(this.r(10000L), this.g(new String[0])), true);
        this.navigation.issue().gotoEditIssue("HSP-2");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.submit("Update");
        this.tester.assertTextPresent("There are no comments yet on this issue.");
    }

    private void createUserPickerAndGoToConfigurationPage() {
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", FIELD_NAME);
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Custom Fields");
        this.text.assertTextPresent(this.locator.id("custom-fields-customfield_10000-name"), FIELD_NAME);
        this.text.assertTextPresent(this.locator.id("custom-fields-customfield_10000-type"), "User Picker");
        this.tester.clickLink("config_customfield_10000");
    }

    private UserFilter f(Collection<Long> roleIds, Collection<String> groups) {
        return new UserFilter(true, roleIds, groups);
    }

    private Collection<Long> r(Long ... roleIds) {
        return ImmutableList.copyOf((Object[])roleIds);
    }

    private Collection<String> g(String ... groups) {
        return ImmutableList.copyOf((Object[])groups);
    }

    private void setFilterAndAssert(UserFilter originalUserFilter, UserFilter newUserFilter) throws JSONException {
        this.tester.clickLink("customfield_10000-edit-userpickerfilter");
        this.tester.assertTextPresent("User filtering for Custom Field : Developer");
        this.tester.setFormElement("userFilterJson", UserFilterUtils.toJson((UserFilter)newUserFilter, null).toString());
        this.tester.submit("Save");
        this.tester.assertTextPresent("Default Configuration Scheme for Developer");
        this.assertUserFilterSummary(newUserFilter);
    }

    private void setUserFilter(UserFilter userFilter) throws JSONException {
        this.setUserFilter(userFilter, false);
    }

    private void setUserFilter(UserFilter userFilter, boolean navigateToPageFirst) throws JSONException {
        if (navigateToPageFirst) {
            this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
            this.tester.clickLink("config_customfield_10000");
        }
        this.setFilterAndAssert(null, userFilter);
    }

    private void assertUserFilterSummary(UserFilter userFilter) {
        if (!userFilter.isEnabled()) {
            this.tester.assertTextPresent("All active users are allowed");
            this.tester.assertTextNotPresent("Filtering users by the following");
        } else if (CollectionUtils.isNotEmpty((Collection)userFilter.getGroups()) || CollectionUtils.isNotEmpty((Collection)userFilter.getRoleIds())) {
            this.tester.assertTextPresent("Filtering users by the following");
            for (Long roleId : userFilter.getRoleIds()) {
                this.tester.assertTextPresent("<b>Project Role</b>: " + ALL_ROLE_ID_TO_NAME_MAP.get(roleId));
            }
            long[] lArray = ALL_ROLE_IDS;
            int len$ = lArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Long roleId = lArray[i$];
                if (userFilter.getRoleIds().contains(roleId)) continue;
                this.tester.assertTextNotPresent("<b>Project Role</b>: " + ALL_ROLE_ID_TO_NAME_MAP.get(roleId));
            }
            for (String groupName : userFilter.getGroups()) {
                this.tester.assertTextPresent("<b>Group</b>: " + groupName);
            }
            for (String groupName : ALL_GROUPS) {
                if (userFilter.getGroups().contains(groupName)) continue;
                this.tester.assertTextNotPresent("<b>Group</b>: " + groupName);
            }
        } else {
            this.tester.assertTextPresent("No users are allowed");
            this.tester.assertTextNotPresent("Filtering users by the following");
        }
    }

    static {
        ALL_ROLE_ID_TO_NAME_MAP.put(10002L, "Administrators");
        ALL_ROLE_ID_TO_NAME_MAP.put(10001L, "Developers");
        ALL_ROLE_ID_TO_NAME_MAP.put(10000L, "Users");
    }
}

