/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.UsersResourceTest;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.crowd.embedded.CrowdEmbeddedServer;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestCrowdUsersResource
extends UsersResourceTest
implements EnvironmentAware {
    private static final String USERNAME_PARAM = "username";
    private static final String KEY_PARAM = "key";
    private static final String EXTERNAL_ID = "externalId";
    private static final String EXTERNAL_ID_WITH_DIRECTORY = "2:externalId";

    public TestCrowdUsersResource(String name) {
        super(name, (RestServer)new CrowdEmbeddedServer().usingXmlBackup("TestCrowdRestAPI.xml"));
    }

    @Override
    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        this.setRestServer(new CrowdEmbeddedServer(environmentData).usingXmlBackup("TestCrowdRestAPI.xml"));
    }

    public void testGetUserWithAttributes() {
    }

    public void testGetNestedGroups() {
    }

    public void testGetDirectGroups() {
    }

    public void testGetUserWithAttributesByKey() {
        URI uri = this.getBaseUriBuilder().path("user").queryParam(KEY_PARAM, new Object[]{"{key}"}).queryParam("expand", new Object[]{"attributes"}).build(new Object[]{EXTERNAL_ID_WITH_DIRECTORY});
        WebResource webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        TestCrowdUsersResource.assertValidUserWithAttributes(webResource);
        TestCrowdUsersResource.assertEquals((Object)this.userResourceByNameUri("admin"), (Object)((UserEntity)webResource.get(UserEntity.class)).getLink().getHref());
    }

    private URI userResourceByNameUri(String username) {
        return this.getBaseUriBuilder().path("user").queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{username});
    }

    private static void assertValidUserWithAttributes(WebResource webResource) {
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        TestCrowdUsersResource.assertEquals((String)"admin", (String)user.getName());
        TestCrowdUsersResource.assertEquals((String)"bob", (String)user.getFirstName());
        TestCrowdUsersResource.assertEquals((String)"the builder", (String)user.getLastName());
        TestCrowdUsersResource.assertEquals((String)"bob the builder", (String)user.getDisplayName());
        TestCrowdUsersResource.assertEquals((String)"bob@example.net", (String)user.getEmail());
        TestCrowdUsersResource.assertEquals((String)EXTERNAL_ID_WITH_DIRECTORY, (String)user.getKey());
        TestCrowdUsersResource.assertTrue((boolean)user.isActive());
        MultiValuedAttributeEntityList attributeList = user.getAttributes();
        TestCrowdUsersResource.assertNotNull((Object)attributeList);
        HashSet attributeNames = Sets.newHashSet();
        for (MultiValuedAttributeEntity attribute : attributeList) {
            attributeNames.add(attribute.getName());
        }
        MatcherAssert.assertThat((Object)attributeNames, (Matcher)Matchers.hasItems((Object[])new String[]{"invalidPasswordAttempts", "lastAuthenticated", "requiresPasswordChange"}));
    }
}

