/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.GroupsResourceTest;
import com.atlassian.crowd.integration.rest.entity.MembershipsEntity;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.crowd.embedded.CrowdEmbeddedServer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sun.jersey.api.client.WebResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestCrowdGroupsResource
extends GroupsResourceTest
implements EnvironmentAware {
    public TestCrowdGroupsResource(String name) {
        super(name, (RestServer)new CrowdEmbeddedServer().usingXmlBackup("TestCrowdRestAPI.xml"));
    }

    @Override
    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        this.setRestServer(new CrowdEmbeddedServer(environmentData).usingXmlBackup("TestCrowdRestAPI.xml"));
    }

    public void testStoreGroupAttributes() {
    }

    public void testDeleteGroupAttribute() {
    }

    public void testGetGroup_Expanded() {
    }

    public void testAddDirectChildGroup_NoNestedGroups() {
    }

    public void testGetMembershipsReturnsExactlyExpectedMemberships() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("group").path("membership");
        MembershipsEntity mems = (MembershipsEntity)webResource.get(MembershipsEntity.class);
        TestCrowdGroupsResource.assertNotNull((Object)mems.getList());
        HashMap<String, Set> users = new HashMap<String, Set>(64);
        HashMap<String, Set> childGroups = new HashMap<String, Set>(64);
        for (Membership e : mems.getList()) {
            users.put(e.getGroupName(), e.getUserNames());
            childGroups.put(e.getGroupName(), e.getChildGroupNames());
        }
        Set empty = Collections.emptySet();
        ImmutableMap expectedUsers = ImmutableMap.builder().put((Object)"animals", empty).put((Object)"badgers", TestCrowdGroupsResource.users("admin", "eeeep")).put((Object)"birds", empty).put((Object)"cats", empty).put((Object)"crowd-administrators", TestCrowdGroupsResource.users("admin", "secondadmin")).put((Object)"crowd-testers", TestCrowdGroupsResource.users("penny")).put((Object)"crowd-users", empty).put((Object)"dogs", empty).put((Object)"jira-users", TestCrowdGroupsResource.users("admin", "regularuser")).put((Object)"jira-developers", TestCrowdGroupsResource.users("admin")).put((Object)"jira-administrators", TestCrowdGroupsResource.users("admin")).put((Object)"UpperCaseGroupName", TestCrowdGroupsResource.users("regularuser")).build();
        ImmutableMap expectedChildGroups = ImmutableMap.builder().put((Object)"animals", empty).put((Object)"badgers", empty).put((Object)"birds", empty).put((Object)"cats", empty).put((Object)"crowd-administrators", TestCrowdGroupsResource.users("crowd-testers")).put((Object)"crowd-testers", TestCrowdGroupsResource.users("badgers")).put((Object)"crowd-users", TestCrowdGroupsResource.users("badgers")).put((Object)"dogs", empty).put((Object)"jira-users", empty).put((Object)"jira-developers", empty).put((Object)"jira-administrators", empty).put((Object)"UpperCaseGroupName", empty).build();
        TestCrowdGroupsResource.assertEquals((Object)expectedUsers, users);
        TestCrowdGroupsResource.assertEquals((Object)expectedChildGroups, childGroups);
    }

    private static Set<String> users(String ... users) {
        return ImmutableSet.copyOf((Object[])users);
    }
}

