/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.SECURITY})
public class TestConcurrentAttributeUpdates
extends FuncTestCase {
    public static final String REST_AUTH_RESOURCE = "/rest/auth/latest/session";
    private JSONObject fredGoodCredentials;
    private RestRule restRule;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.restRule = new RestRule(this);
        this.restRule.before();
        this.administration.restoreBlankInstance();
        try {
            this.fredGoodCredentials = new JSONObject();
            this.fredGoodCredentials.put("username", "fred");
            this.fredGoodCredentials.put("password", "fred");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void tearDownTest() {
        this.restRule.after();
    }

    public void testConcurrentLogin() throws Exception {
        this.navigation.login("fred", "fred");
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    WebResponse response = null;
                    try {
                        response = TestConcurrentAttributeUpdates.this.loginAs(TestConcurrentAttributeUpdates.this.fredGoodCredentials);
                        TestConcurrentAttributeUpdates.this.log.log((Object)"Logging on concurrently");
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                    catch (SAXException e) {
                        Assert.fail((String)e.getMessage());
                    }
                    Assert.assertEquals((int)200, (int)response.getResponseCode());
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        List<Map<String, String>> rows = this.backdoor.entityEngine().findByAnd("UserAttribute", EasyMap.build((Object)"userId", (Object)10010L, (Object)"name", (Object)"login.count"));
        TestConcurrentAttributeUpdates.assertEquals((int)1, (int)rows.size());
    }

    protected WebResponse loginAs(JSONObject json) throws IOException, SAXException {
        return this.restRule.POST(REST_AUTH_RESOURCE, json);
    }
}

