/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.crowd.embedded;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.testkit.client.restclient.AtlassianTenantFilter;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ReflectionUtils;

class CrowdEmbeddedServer
implements RestServer {
    static final String XML_BACKUP = "TestCrowdRestAPI.xml";
    private final JIRAEnvironmentData environmentData;
    private String xmlBackup = null;
    private final URL base;

    public CrowdEmbeddedServer() {
        this(new LocalTestEnvironmentData());
    }

    public CrowdEmbeddedServer(JIRAEnvironmentData environmentData) {
        this.environmentData = environmentData;
        URL base = environmentData.getBaseUrl();
        if (StringUtils.isEmpty((String)base.getPath())) {
            try {
                base = new URL(base.toString() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.base = base;
    }

    public CrowdEmbeddedServer usingXmlBackup(String xmlBackup) {
        this.xmlBackup = xmlBackup;
        return this;
    }

    public void before() throws Exception {
        if (this.xmlBackup != null) {
            FakeTestCase ftc = new FakeTestCase();
            ftc.setEnvironmentData(this.environmentData);
            Method setUp = TestCase.class.getDeclaredMethod("setUp", null);
            ReflectionUtils.makeAccessible((Method)setUp);
            setUp.invoke((Object)ftc, (Object[])null);
            ftc.restore(this.xmlBackup);
        }
    }

    public void after() {
    }

    public URL getBaseUrl() {
        return this.base;
    }

    public Client decorateClient(Client client) {
        if (StringUtils.isNotBlank((String)this.environmentData.getTenant())) {
            client.addFilter((ClientFilter)new AtlassianTenantFilter(this.environmentData.getTenant()));
        }
        return client;
    }

    static class FakeTestCase
    extends FuncTestCase {
        FakeTestCase() {
        }

        public void restore(String xmlBackup) {
            this.administration.restoreData(xmlBackup);
        }
    }
}

