/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
public class TestCommentNotifications
extends EmailFuncTestCase {
    private static final String ISSUE_KEY = "TEST-1";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestCommentNotifications.xml");
        this.configureAndStartSmtpServer();
    }

    public void testDeletingACommentSendsEmail() throws Exception {
        this.deleteCommentOn(ISSUE_KEY);
        this.assertEmailWasSentTo("admin@localhost", "updated", "an issue", ISSUE_KEY, "some&nbsp;comment", "Change By:", "Add Comment", "Bug", "This message was sent by Atlassian JIRA");
    }

    private void deleteCommentOn(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel");
        this.tester.clickLink("delete_comment_10000");
        this.tester.submit("Delete");
    }

    private void assertEmailWasSentTo(String emailAddress, String ... expectedTexts) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        Assert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
        for (String expectedText : expectedTexts) {
            this.assertEmailBodyContains(messagesForRecipient.get(0), expectedText);
        }
    }
}

