/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
public class TestCommentDelete
extends JIRAWebTest {
    public TestCommentDelete(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestCommentDelete.xml");
    }

    public void testDeleteOwnCommentWithOwnPermission() {
        this.logout();
        this.login("detkin", "detkin");
        this.gotoIssue("TST-1");
        this.clickLink("delete_comment_10020");
        this.submit("Delete");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteCommentWithAllPermission() {
        this.gotoIssue("TST-1");
        this.clickLink("delete_comment_10020");
        this.submit("Delete");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteOthersCommentWithOwnPermission() {
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteCommentLinkNotAvailableWithNonEditableWorkflowState() {
        this.gotoIssue("TST-1");
        this.clickLinkWithText("Close Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.assertLinkNotPresent("delete_comment_10020");
    }

    public void testDeleteCommentReindexesIssue() {
        this.navigation.issueNavigator().createSearch("comment ~ \"Unique Comment\"");
        this.assertTextPresent("TST-1");
        this.gotoIssue("TST-1");
        this.clickLink("delete_comment_10020");
        this.submit("Delete");
        this.navigation.issueNavigator().createSearch("comment ~ \"Unique Comment\"");
        this.assertTextNotPresent("TST-1");
        this.assertElementNotPresent("issuetable");
    }

    public void testDeleteCommentWithNoPermissions() {
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.DELETE_ALL_COMMENTS, 10002L);
        this.backdoor.permissionSchemes().removeProjectRolePermission(0L, ProjectPermissions.DELETE_OWN_COMMENTS, 10000L);
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=10020");
        this.tester.assertTitleEquals("Error - Your Company JIRA");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You do not have the permission for this comment.");
    }

    public void testDeleteCommentWithNonEditableWorkflowState() {
        this.gotoIssue("TST-1");
        this.clickLinkWithText("Close Issue");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=10020");
        this.tester.assertTitleEquals("Error - Your Company JIRA");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You do not have the permission for this comment.");
    }

    public void testOneCanNotDeleteCommentThatOneCanNotSee() {
        this.gotoIssue("TST-1");
        this.addCommentOnCurrentIssue("This comment is visible by developers only!", "Developers");
        this.assertTextPresent("This comment is visible by developers only!");
        this.administration.usersAndGroups().addUserToGroup("barney", "jira-administrators");
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertTextNotPresent("This comment is visible by developers only!");
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=10030");
        this.tester.assertTitleEquals("Error - Your Company JIRA");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You do not have the permission for this comment.");
        this.gotoPage("/secure/DeleteComment!default.jspa?id=10000&commentId=100301");
        this.tester.assertTitleEquals("Error - Your Company JIRA");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You do not have the permission for this comment.");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue("TST-1");
        this.assertTextPresent("This comment is visible by developers only!");
    }

    public void testOneCanNotEditCommentThatOneCanNotSee() {
        this.gotoIssue("TST-1");
        this.addCommentOnCurrentIssue("This comment is visible by developers only!", "Developers");
        this.assertTextPresent("This comment is visible by developers only!");
        this.administration.usersAndGroups().addUserToGroup("barney", "jira-administrators");
        this.logout();
        this.login("barney", "barney");
        this.gotoIssue("TST-1");
        this.assertTextNotPresent("This comment is visible by developers only!");
        this.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=10030");
        this.tester.assertTitleEquals("Error - Your Company JIRA");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You do not have the permission for this comment.");
        this.gotoPage("/secure/EditComment!default.jspa?id=10000&commentId=100301");
        this.tester.assertTitleEquals("Error - Your Company JIRA");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "You do not have the permission for this comment.");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue("TST-1");
        this.assertTextPresent("This comment is visible by developers only!");
    }
}

