/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.comment;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class TestAddComment
extends FuncTestCase {
    private static final String smartQuoteOpen = "\u201c";
    private static final String smartQuoteClose = "\u201d";
    private static final String htmlEscQuote = "&quot;";
    private static final String chineseChars = "\u963f\u725b\u54e5";
    private static final String fiveHTMLquotes = "&quot;&quot;&quot;&quot;&quot;";
    private static final String TEST_ADD_COMMENT_XML = "TestAddComment.xml";
    private final String commentLinkid;

    TestAddComment(String commentLinkid) {
        this.commentLinkid = commentLinkid;
    }

    public void testRemoveMe() throws Exception {
    }

    @Override
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testCannotAddCommentWithoutIssue() {
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa"));
        this.tester.assertTitleEquals("Error - jWebTest JIRA installation");
        this.text.assertTextPresent(new CssLocator(this.tester, "#content .error"), "The issue no longer exists.");
    }

    public void testCommentVisiblityOrdering() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        String FIRST_GROUP_NAME = "a group";
        String LAST_GROUP_NAME = "z group";
        this.administration.usersAndGroups().addGroup("a group");
        this.administration.usersAndGroups().addGroup("z group");
        this.administration.usersAndGroups().addUserToGroup("admin", "a group");
        this.administration.usersAndGroups().addUserToGroup("admin", "z group");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink(this.commentLinkid);
        this.tester.setWorkingForm("comment-add");
        String[] commentLevels = this.tester.getDialog().getOptionsFor("commentLevel");
        TestAddComment.assertEquals((int)9, (int)commentLevels.length);
        TestAddComment.assertEquals((String)"All Users", (String)commentLevels[0]);
        TestAddComment.assertEquals((String)"Administrators", (String)commentLevels[1]);
        TestAddComment.assertEquals((String)"Developers", (String)commentLevels[2]);
        TestAddComment.assertEquals((String)"Users", (String)commentLevels[3]);
        TestAddComment.assertEquals((String)"a group", (String)commentLevels[4]);
        TestAddComment.assertEquals((String)"jira-administrators", (String)commentLevels[5]);
        TestAddComment.assertEquals((String)"jira-developers", (String)commentLevels[6]);
        TestAddComment.assertEquals((String)"jira-users", (String)commentLevels[7]);
        TestAddComment.assertEquals((String)"z group", (String)commentLevels[8]);
    }

    public void testAddInvalidComment() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.navigation.issue().gotoIssue("HSP-1");
        this.addComment("All Users", "");
        this.tester.assertTextPresent("Comment body can not be empty!");
        this.navigation.issue().gotoIssue("HSP-1");
        this.addComment("All Users", "     ");
        this.tester.assertTextPresent("Comment body can not be empty!");
    }

    public void testAddCommentWithVisibility() {
        String allUsersComment = "This is a comment assigned to all users";
        String jiraUsersGroupComment = "this comment visible to jira-users group";
        String jiraUsersRoleComment = "this is a comment visible to Users role";
        String jiraDevelopersGroupComment = "this is a comment visible to jira-developers group";
        String jiraDevelopersRoleComment = "this is a comment visible to Developers role";
        String jiraAdminsGroupComment = "this is a comment visible to jira-admin group";
        String jiraAdminsRoleComment = "this is a comment visible to Administrators role";
        this.administration.restoreData("TestBlankInstancePlusAFewUsers.xml");
        this.navigation.issue().gotoIssue("HSP-5");
        this.addComment("All Users", allUsersComment);
        this.addComment("jira-users", jiraUsersGroupComment);
        this.addComment("Users", jiraUsersRoleComment);
        this.addComment("jira-developers", jiraDevelopersGroupComment);
        this.addComment("Developers", jiraDevelopersRoleComment);
        this.addComment("jira-administrators", jiraAdminsGroupComment);
        this.addComment("Administrators", jiraAdminsRoleComment);
        List<String> userComments = Arrays.asList(allUsersComment, jiraUsersRoleComment, jiraUsersGroupComment);
        List<String> devComments = Arrays.asList(jiraDevelopersGroupComment, jiraDevelopersRoleComment);
        List<String> adminComments = Arrays.asList(jiraAdminsGroupComment, jiraAdminsRoleComment);
        this.checkCommentVisibility("fred", "HSP-5", userComments, Iterables.concat(devComments, adminComments));
        this.checkCommentVisibility("admin", "HSP-5", Iterables.concat((Iterable)Iterables.concat(userComments, devComments), adminComments), null);
        this.checkCommentVisibility("devman", "HSP-5", Iterables.concat(devComments, userComments), adminComments);
        this.checkCommentVisibility("onlyadmin", "HSP-5", Iterables.concat(adminComments, userComments), devComments);
    }

    private void checkCommentVisibility(String username, String issueKey, Iterable<String> expectedVisible, Iterable<String> expectedNotVisible) {
        if (expectedVisible != null) {
            this.assertions.comments(expectedVisible).areVisibleTo(username, issueKey);
        }
        if (expectedNotVisible != null) {
            this.assertions.comments(expectedNotVisible).areNotVisibleTo(username, issueKey);
        }
    }

    public void testAddCommentErrorWhenLoggedOut() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.navigation.logout();
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        String theCommentEscaped = "comment with html &lt;input type=&quot;input&quot; id=&quot;invalid&quot;/&gt;";
        this.page.getFreshXsrfToken();
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=10000&comment=" + theComment));
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    public void testAddCommentErrorWhenNoPermission() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ADD_COMMENTS, "jira-users");
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        String theCommentEscaped = "comment with html &lt;input type=&quot;input&quot; id=&quot;invalid&quot;/&gt;";
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=10000&comment=" + theComment));
        this.tester.assertTextPresent("Administrator, you do not have the permission to comment on this issue.");
    }

    public void testAddCommentErrorWhenIssueDoesNotExist() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.navigation.issue().deleteIssue("HSP-1");
        String theComment = "comment with html <input type=\"input\" id=\"invalid\"/>";
        String theCommentEscaped = "comment with html &lt;input type=&quot;input&quot; id=&quot;invalid&quot;/&gt;";
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=10000&comment=" + theComment));
        this.tester.assertTextPresent("The issue no longer exists.");
        this.tester.assertTextNotPresent(theComment);
        this.tester.assertTextPresent("The issue no longer exists.");
    }

    private void addComment(String visibleTo, String comment) {
        this.tester.clickLink(this.commentLinkid);
        this.tester.selectOption("commentLevel", visibleTo);
        this.tester.setFormElement("comment", comment);
        this.tester.submit();
    }

    public void testAddCommentWithGroupButNotLoggedIn() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue");
        this.navigation.issue().gotoIssue(key);
        this.tester.assertTextPresent("Test Issue");
        String id = this.navigation.issue().getId(key);
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=" + id + "&comment=Hello"));
        this.tester.assertTextPresent("Test Issue");
        this.tester.assertTextPresent("Hello");
        this.tester.assertTextNotPresent("Ahoj");
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=" + id + "&comment=Ahoj&commentLevel=group%3Ajira-users"));
        this.tester.assertTextPresent("Test Issue");
        this.tester.assertTextPresent("Hello");
        this.tester.assertTextPresent("Ahoj");
        this.addBrowseProjectPermissionToAnonymous();
        this.addCreateCommentPermissionToAnonymous();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.navigation.logout();
        this.page.getFreshXsrfToken();
        this.navigation.gotoPage(this.page.addXsrfToken("/secure/AddComment.jspa?id=" + id + "&comment=Hola&commentLevel=group%3Ajira-users"));
        this.tester.assertTextNotPresent("NullPointerException");
        this.tester.assertTextPresent("You cannot add a comment for specific groups or roles, as your session has expired. Please log in and try again.");
        this.navigation.login("admin", "admin");
    }

    public void testAddCommentCheckUpdatedDate() throws ParseException {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.navigation.issue().gotoIssue("HSP-1");
        String startTagNoQuote = "<span class=date>";
        this.text.assertTextPresent(new IdLocator(this.tester, "create-date"), "14/Aug/06 4:26 PM");
        this.text.assertTextPresent(new IdLocator(this.tester, "updated-date"), "14/Aug/06 4:26 PM");
        String commentText = "This is my first test comment!";
        this.tester.assertTextNotPresent("This is my first test comment!");
        this.tester.clickLink(this.commentLinkid);
        this.tester.setFormElement("comment", "This is my first test comment!");
        this.tester.submit();
        this.tester.assertTextPresent("This is my first test comment!");
        String dateString = this.locator.css("span.date").getNodes()[0].getNodeValue();
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy h:mm a");
        Date date = format.parse(dateString);
        SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm a");
        String timeString = timeFormat.format(date);
        this.text.assertTextPresent(new IdLocator(this.tester, "create-date"), "14/Aug/06 4:26 PM");
        this.text.assertTextPresent(new IdLocator(this.tester, "updated-date"), timeString);
    }

    public void testAddTooLongComment() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(10L);
        this.navigation.issue().gotoIssue("HSP-1");
        this.addComment("All Users", "This is too long comment");
        this.tester.assertTextPresent("The entered text is too long. It exceeds the allowed limit of 10 characters.");
    }

    public void testAddCommentWithTextLengthLimitOn() {
        this.administration.restoreData(TEST_ADD_COMMENT_XML);
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(10L);
        this.navigation.issue().gotoIssue("HSP-1");
        String correctCommentBody = "AllGood";
        this.addComment("All Users", "AllGood");
        this.assertions.comments(Collections.singletonList("AllGood")).areVisibleTo("admin", "HSP-1");
    }

    private void addBrowseProjectPermissionToAnonymous() {
        this.goToDefaultPermissionScheme();
        this.tester.clickLink("add_perm_" + ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
    }

    private void addCreateCommentPermissionToAnonymous() {
        this.goToDefaultPermissionScheme();
        this.tester.clickLink("add_perm_" + ProjectPermissions.ADD_COMMENTS.permissionKey());
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
    }

    private void goToDefaultPermissionScheme() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
    }
}

