/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.streams;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.ACTIVITY_STREAMS})
public class TestActivityStreams
extends FuncTestCase {
    private final HttpClient client = new HttpClient();
    private static final Logger log = LoggerFactory.getLogger(TestActivityStreams.class);

    public void testContentEncodingIsNotEmpty() throws Exception {
        GetMethod request = new GetMethod(this.tester.getTestContext().getBaseUrl() + "plugins/servlet/streams?maxResults=10&relativeLinks=true");
        request.setRequestHeader("Accept-Encoding", "gzip");
        int status = this.client.executeMethod((HttpMethod)request);
        TestActivityStreams.assertEquals((int)200, (int)status);
        Header responseHeader = request.getResponseHeader("Content-Encoding");
        if (responseHeader == null) {
            return;
        }
        TestActivityStreams.assertNotNull((String)"It's not possible for a header to have a NULL value", (Object)responseHeader.getValue());
        MatcherAssert.assertThat((Object)responseHeader.getValue(), (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)"")));
    }
}

