/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util;

import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

public class PropertyAssertions {
    public static void assertUniformInterfaceException(Callable<Void> callable, Response.Status expectedStatus) {
        PropertyAssertions.assertUniformInterfaceException(callable, expectedStatus, null);
    }

    public static void assertUniformInterfaceException(Callable<Void> callable, Response.Status expectedStatus, String contentSubstring) {
        try {
            callable.call();
            Assert.fail((String)("Expected uniform interface exception with status " + expectedStatus.toString()));
        }
        catch (UniformInterfaceException e) {
            Assert.assertThat((Object)e.getResponse().getStatus(), (Matcher)Matchers.is((Object)expectedStatus.getStatusCode()));
            if (contentSubstring != null) {
                Assert.assertThat((Object)PropertyAssertions.readContent(e.getResponse()), (Matcher)Matchers.containsString((String)contentSubstring));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String readContent(ClientResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntityInputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Matcher<EntityPropertyKeys.EntityPropertyKey> propertyKey(final String propertyKey) {
        return new TypeSafeMatcher<EntityPropertyKeys.EntityPropertyKey>(){

            protected boolean matchesSafely(EntityPropertyKeys.EntityPropertyKey issuePropertyKey) {
                return issuePropertyKey.key.equals(propertyKey) && issuePropertyKey.self.endsWith(propertyKey);
            }

            public void describeTo(Description description) {
                description.appendText("List does not contain property with key").appendValue((Object)propertyKey);
            }
        };
    }
}

