/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.UserBean;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class WorkflowSchemeClient
extends RestApiClient<WorkflowSchemeClient> {
    private final boolean draft;
    private final JIRAEnvironmentData data;

    public WorkflowSchemeClient(JIRAEnvironmentData environmentData) {
        this(environmentData, false);
    }

    public WorkflowSchemeClient(JIRAEnvironmentData environmentData, boolean draft) {
        super(environmentData);
        this.draft = draft;
        this.data = environmentData;
    }

    public WorkflowSchemeClient asDraft() {
        return new WorkflowSchemeClient(this.data, true);
    }

    public Response<WorkflowScheme> getWorkflowSchemeResponse(final long id) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createWorkflowSchemeResource(id).get(ClientResponse.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme getWorkflowScheme(long id) {
        return this.getWorkflowScheme(id, false);
    }

    public WorkflowScheme getWorkflowScheme(long id, boolean draftIfThere) {
        return (WorkflowScheme)this.createWorkflowSchemeResource(id).queryParam("returnDraftIfExists", String.valueOf(draftIfThere)).get(WorkflowScheme.class);
    }

    protected WebResource createResource() {
        return super.createResource().path("workflowscheme");
    }

    private WebResource createWorkflowSchemeResource(long id) {
        WebResource resource = this.createResource().path(String.valueOf(id));
        if (this.draft) {
            resource = resource.path("draft");
        }
        return resource;
    }

    private WebResource createWorkflowSchemeWorkflowResource(long id, String workflowName) {
        return this.createWorkflowSchemeResource(id).path("workflow").queryParam("workflowName", workflowName);
    }

    private WebResource createWorkflowSchemeIssueTypeResource(long id, String issueType) {
        return this.createWorkflowSchemeResource(id).path("issuetype").path(issueType);
    }

    public WorkflowScheme createScheme(WorkflowScheme workflowScheme) {
        return (WorkflowScheme)this.createResource().type(MediaType.APPLICATION_JSON_TYPE).post(WorkflowScheme.class, (Object)workflowScheme);
    }

    public Response<WorkflowScheme> createSchemeResponse(final WorkflowScheme workflowScheme) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createResource().type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)workflowScheme);
            }
        }, WorkflowScheme.class);
    }

    public void deleteScheme(Long id) {
        this.createWorkflowSchemeResource(id).type(MediaType.APPLICATION_JSON_TYPE).delete();
    }

    public Response<Void> deleteSchemeResponse(final Long id) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createWorkflowSchemeResource(id).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        }, Void.class);
    }

    public Response<WorkflowScheme> updateWorkflowSchemeResponse(final WorkflowScheme workflowSchemeData) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createWorkflowSchemeResource(workflowSchemeData.getId()).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)workflowSchemeData);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme updateWorkflowScheme(WorkflowScheme workflowSchemeData) {
        return (WorkflowScheme)this.createWorkflowSchemeResource(workflowSchemeData.getId()).type(MediaType.APPLICATION_JSON_TYPE).put(WorkflowScheme.class, (Object)workflowSchemeData);
    }

    public WorkflowScheme createDraft(long id) {
        return (WorkflowScheme)this.createWorkflowSchemeResource(id).path("createdraft").post(WorkflowScheme.class);
    }

    public Response<WorkflowScheme> createDraftResponse(final long id) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createWorkflowSchemeResource(id).path("createdraft").post(ClientResponse.class);
            }
        }, WorkflowScheme.class);
    }

    public List<WorkflowMapping> getWorkflowMappings(long id, boolean maybeDraft) {
        WebResource workflow = this.createWorkflowSchemeResource(id).path("workflow").queryParam("returnDraftIfExists", String.valueOf(maybeDraft));
        return (List)workflow.get(WorkflowMapping.LIST);
    }

    public Response<List<WorkflowMapping>> getWorkflowMappingsResponse(final long id, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeResource(id).path("workflow").queryParam("returnDraftIfExists", String.valueOf(maybeDraft));
                return (ClientResponse)workflow.get(ClientResponse.class);
            }
        }, WorkflowMapping.LIST.getRawClass());
    }

    public WorkflowMapping getWorkflowMapping(long id, String workflowName, boolean maybeDraft) {
        WebResource workflow = this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("returnDraftIfExists", String.valueOf(maybeDraft));
        return (WorkflowMapping)workflow.get(WorkflowMapping.class);
    }

    public Response<WorkflowMapping> getWorkflowMappingResponse(final long id, final String workflowName, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("returnDraftIfExists", String.valueOf(maybeDraft));
                return (ClientResponse)workflow.get(ClientResponse.class);
            }
        }, WorkflowMapping.class);
    }

    public WorkflowScheme deleteWorkflowMapping(long id, String workflowName, boolean maybeDraft) {
        WebResource workflow = this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("updateDraftIfNeeded", String.valueOf(maybeDraft));
        return (WorkflowScheme)workflow.type(MediaType.APPLICATION_JSON_TYPE).delete(WorkflowScheme.class);
    }

    public Response<WorkflowScheme> deleteWorkflowMappingResponse(final long id, final String workflowName, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeWorkflowResource(id, workflowName).queryParam("updateDraftIfNeeded", String.valueOf(maybeDraft));
                return (ClientResponse)workflow.type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme updateWorkflowMapping(long id, WorkflowMapping mapping) {
        return this.updateWorkflowMapping(id, mapping.getWorkflow(), mapping);
    }

    public WorkflowScheme updateWorkflowMapping(long id, String workflowName, WorkflowMapping mapping) {
        WebResource workflow = this.createWorkflowSchemeWorkflowResource(id, workflowName);
        return (WorkflowScheme)workflow.type(MediaType.APPLICATION_JSON_TYPE).put(WorkflowScheme.class, (Object)mapping);
    }

    public Response<WorkflowScheme> updateWorkflowMappingResponse(final long id, final WorkflowMapping mapping) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeWorkflowResource(id, mapping.getWorkflow());
                return (ClientResponse)workflow.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)mapping);
            }
        }, WorkflowScheme.class);
    }

    public IssueTypeMappingBean getIssueTypeMapping(long id, String issueType, boolean maybeDraft) {
        WebResource workflow = this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("returnDraftIfExists", String.valueOf(maybeDraft));
        return (IssueTypeMappingBean)workflow.get(IssueTypeMappingBean.class);
    }

    public Response<IssueTypeMappingBean> getIssueTypeMappingResponse(final long id, final String issueType, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("returnDraftIfExists", String.valueOf(maybeDraft));
                return (ClientResponse)workflow.get(ClientResponse.class);
            }
        }, IssueTypeMappingBean.class);
    }

    public WorkflowScheme deleteIssueMapping(long id, String issueType, boolean maybeDraft) {
        WebResource workflow = this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("updateDraftIfNeeded", String.valueOf(maybeDraft));
        return (WorkflowScheme)workflow.type(MediaType.APPLICATION_JSON_TYPE).delete(WorkflowScheme.class);
    }

    public Response<WorkflowScheme> deleteIssueMappingResponse(final long id, final String issueType, final boolean maybeDraft) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeIssueTypeResource(id, issueType).queryParam("updateDraftIfNeeded", String.valueOf(maybeDraft));
                return (ClientResponse)workflow.type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme updateIssueTypeMapping(long id, IssueTypeMappingBean mapping) {
        return this.updateIssueTypeMapping(id, mapping.getIssueType(), mapping);
    }

    public WorkflowScheme updateIssueTypeMapping(long id, String issueType, IssueTypeMappingBean mapping) {
        WebResource workflow = this.createWorkflowSchemeIssueTypeResource(id, issueType);
        return (WorkflowScheme)workflow.type(MediaType.APPLICATION_JSON_TYPE).put(WorkflowScheme.class, (Object)mapping);
    }

    public Response<WorkflowScheme> updateIssueTypeMappingResponse(final long id, final IssueTypeMappingBean mapping) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                WebResource workflow = WorkflowSchemeClient.this.createWorkflowSchemeIssueTypeResource(id, mapping.getIssueType());
                return (ClientResponse)workflow.type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)mapping);
            }
        }, WorkflowScheme.class);
    }

    public DefaultBean getDefault(long id, boolean draft) {
        return (DefaultBean)this.createDefaultResource(id).queryParam("returnDraftIfExists", String.valueOf(draft)).get(DefaultBean.class);
    }

    public Response<DefaultBean> getDefaultResponse(final long id, final boolean draft) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createDefaultResource(id).queryParam("returnDraftIfExists", String.valueOf(draft)).get(ClientResponse.class);
            }
        }, DefaultBean.class);
    }

    public WorkflowScheme deleteDefault(long id, boolean updateDraftIfNeeded) {
        return (WorkflowScheme)this.createDefaultResource(id).queryParam("updateDraftIfNeeded", String.valueOf(updateDraftIfNeeded)).type(MediaType.APPLICATION_JSON_TYPE).delete(WorkflowScheme.class);
    }

    public Response<WorkflowScheme> deleteDefaultResponse(final long id, final boolean updateDraftIfNeeded) {
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createDefaultResource(id).queryParam("updateDraftIfNeeded", String.valueOf(updateDraftIfNeeded)).type(MediaType.APPLICATION_JSON_TYPE).delete(ClientResponse.class);
            }
        }, WorkflowScheme.class);
    }

    public WorkflowScheme setDefault(long id, String workflowName, boolean updateDraft) {
        DefaultBean requestEntity = new DefaultBean(workflowName);
        requestEntity.setUpdateDraftIfNeeded(updateDraft);
        return (WorkflowScheme)this.createDefaultResource(id).type(MediaType.APPLICATION_JSON_TYPE).put(WorkflowScheme.class, (Object)requestEntity);
    }

    public Response<WorkflowScheme> setDefaultResponse(final long id, String workflowName, boolean updateDraft) {
        final DefaultBean requestEntity = new DefaultBean(workflowName);
        requestEntity.setUpdateDraftIfNeeded(updateDraft);
        return this.toResponse(new RestApiClient.Method(){

            public ClientResponse call() {
                return (ClientResponse)WorkflowSchemeClient.this.createDefaultResource(id).type(MediaType.APPLICATION_JSON_TYPE).put(ClientResponse.class, (Object)requestEntity);
            }
        }, WorkflowScheme.class);
    }

    private WebResource createDefaultResource(long id) {
        return this.createWorkflowSchemeResource(id).path("default");
    }

    public static class DefaultBean {
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Boolean updateDraftIfNeeded;

        public DefaultBean() {
        }

        public DefaultBean(String workflow) {
            this.workflow = workflow;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(String workflow) {
            this.workflow = workflow;
        }
    }

    public static class IssueType {
        @JsonProperty
        private URI self;
        @JsonProperty
        private URI iconUrl;
        @JsonProperty
        private String id;
        @JsonProperty
        private String description;
        @JsonProperty
        private String name;
        @JsonProperty
        private boolean subtask;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class WorkflowMapping {
        public static final GenericType<List<WorkflowMapping>> LIST = new GenericType<List<WorkflowMapping>>(){};
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Set<String> issueTypes;
        @JsonProperty
        private Boolean defaultMapping;
        @JsonProperty
        private Boolean updateDraftIfNeeded;

        public WorkflowMapping(String workflow) {
            this.workflow = workflow;
        }

        public WorkflowMapping() {
        }

        public Set<String> getIssueTypes() {
            return this.issueTypes;
        }

        public void setIssueTypes(Set<String> issueTypes) {
            this.issueTypes = issueTypes;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(String workflow) {
            this.workflow = workflow;
        }

        void addIssueType(String issueType) {
            this.issueTypes.add(issueType);
        }

        public Boolean isDefaultMapping() {
            return this.defaultMapping;
        }

        public void setDefaultMapping(Boolean defaultMapping) {
            this.defaultMapping = defaultMapping;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowMapping that = (WorkflowMapping)o;
            if (this.defaultMapping != null ? !this.defaultMapping.equals(that.defaultMapping) : that.defaultMapping != null) {
                return false;
            }
            if (this.issueTypes != null ? !this.issueTypes.equals(that.issueTypes) : that.issueTypes != null) {
                return false;
            }
            return !(this.workflow != null ? !this.workflow.equals(that.workflow) : that.workflow != null);
        }

        public int hashCode() {
            int result = this.workflow != null ? this.workflow.hashCode() : 0;
            result = 31 * result + (this.issueTypes != null ? this.issueTypes.hashCode() : 0);
            result = 31 * result + (this.defaultMapping != null ? this.defaultMapping.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class IssueTypeMappingBean {
        @JsonProperty
        private String issueType;
        @JsonProperty
        private String workflow;
        @JsonProperty
        private Boolean updateDraftIfNeeded;

        public IssueTypeMappingBean() {
        }

        public IssueTypeMappingBean(String issueType, String workflow) {
            this.issueType = issueType;
            this.workflow = workflow;
        }

        public String getIssueType() {
            return this.issueType;
        }

        public void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(String workflow) {
            this.workflow = workflow;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class WorkflowScheme {
        @JsonProperty
        private Long id;
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;
        @JsonProperty
        private String defaultWorkflow;
        @JsonProperty
        private Map<String, String> issueTypeMappings;
        @JsonProperty
        private Map<String, String> originalIssueTypeMappings;
        @JsonProperty
        private Map<String, IssueType> issueTypes;
        @JsonProperty
        private boolean draft;
        @JsonProperty
        private UserBean lastModifiedUser;
        @JsonProperty
        private String lastModified;
        @JsonProperty
        private URI self;
        @JsonProperty
        private Boolean updateDraftIfNeeded;
        @JsonProperty
        private String originalDefaultWorkflow;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getDefaultWorkflow() {
            return this.defaultWorkflow;
        }

        public void setDefaultWorkflow(String defaultWorkflow) {
            this.defaultWorkflow = defaultWorkflow;
        }

        public String getOriginalDefaultWorkflow() {
            return this.originalDefaultWorkflow;
        }

        public void setOriginalDefaultWorkflow(String originalDefaultWorkflow) {
            this.originalDefaultWorkflow = originalDefaultWorkflow;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public URI getSelf() {
            return this.self;
        }

        public void setSelf(URI self) {
            this.self = self;
        }

        public boolean isDraft() {
            return this.draft;
        }

        public void setDraft(boolean draft) {
            this.draft = draft;
        }

        public void setLastModifiedUser(UserBean lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public UserBean getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public Boolean getUpdateDraftIfNeeded() {
            return this.updateDraftIfNeeded;
        }

        public void setUpdateDraftIfNeeded(Boolean updateDraftIfNeeded) {
            this.updateDraftIfNeeded = updateDraftIfNeeded;
        }

        public Map<String, String> getIssueTypeMappings() {
            return this.issueTypeMappings;
        }

        public Map<String, String> getOriginalIssueTypeMappings() {
            return this.originalIssueTypeMappings;
        }

        public void setIssueTypeMappings(Map<String, String> issueTypeMappings) {
            this.issueTypeMappings = issueTypeMappings;
        }

        public void setOriginalIssueTypeMappings(Map<String, String> originalIssueTypeMappings) {
            this.originalIssueTypeMappings = originalIssueTypeMappings;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

