/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.UserJson;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.testkit.client.restclient.WorklogWithPaginationBean;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.WORKLOGS})
public class TestWorklogResource
extends RestFuncTest {
    public static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String ISSUE_KEY = "HSP-1";
    private WorklogClient worklogClient;
    private IssueClient issueClient;

    public void testViewWorklog() throws Exception {
        Worklog worklog = this.getDefaultWorklogFromJira();
        TestWorklogResource.assertTrue((boolean)this.getDefaultWorklog().equals((Object)worklog));
    }

    public void testViewWorklogNotFound() throws Exception {
        Response response123 = this.worklogClient.getResponse(ISSUE_KEY, "123");
        TestWorklogResource.assertEquals((int)404, (int)response123.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response123.entity.errorMessages.size());
        TestWorklogResource.assertEquals((String)"Cannot find worklog with id: '123'.", (String)((String)response123.entity.errorMessages.get(0)));
        Response responseAbc = this.worklogClient.getResponse(ISSUE_KEY, "abc");
        TestWorklogResource.assertEquals((int)404, (int)responseAbc.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)responseAbc.entity.errorMessages.size());
        TestWorklogResource.assertEquals((String)"Cannot find worklog with id: 'abc'.", (String)((String)responseAbc.entity.errorMessages.get(0)));
    }

    public void testViewAllWorklogs() throws Exception {
        WorklogWithPaginationBean response = this.worklogClient.getAll(ISSUE_KEY);
        TestWorklogResource.assertEquals((Object)new Integer(0), (Object)response.startAt);
        TestWorklogResource.assertEquals((Object)new Integer(1), (Object)response.maxResults);
        TestWorklogResource.assertEquals((Object)new Integer(1), (Object)response.total);
        TestWorklogResource.assertEquals((int)1, (int)response.worklogs.size());
        Worklog worklog = (Worklog)response.worklogs.get(0);
        TestWorklogResource.assertTrue((boolean)this.getDefaultWorklog().equals((Object)worklog));
    }

    public void testAddWorklog() throws Exception {
        Date now = new Date();
        Worklog toAdd = new Worklog();
        toAdd.timeSpent = "1h";
        toAdd.started = TestWorklogResource.asTimeString(now);
        toAdd.comment = "This is my comment";
        this.addWorkLog(toAdd, now);
    }

    public void testAddWorklogUsingSeconds() throws Exception {
        Date now = new Date();
        Worklog toAdd = new Worklog();
        toAdd.timeSpentSeconds = 3600L;
        toAdd.started = TestWorklogResource.asTimeString(now);
        toAdd.comment = "This is my comment";
        this.addWorkLog(toAdd, now);
    }

    private void addWorkLog(Worklog toAdd, Date now) {
        Response response = this.worklogClient.post(ISSUE_KEY, toAdd);
        TestWorklogResource.assertEquals((int)201, (int)response.statusCode);
        TestWorklogResource.assertNotNull((Object)response.body);
        Worklog worklog = (Worklog)response.body;
        String id = worklog.id;
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/issue/10000/worklog/" + id), (String)worklog.self);
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/user?username=admin"), (String)worklog.author.self);
        TestWorklogResource.assertEquals((String)"admin", (String)worklog.author.name);
        TestWorklogResource.assertEquals((String)"Administrator", (String)worklog.author.displayName);
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/user?username=admin"), (String)worklog.updateAuthor.self);
        TestWorklogResource.assertEquals((String)"admin", (String)worklog.updateAuthor.name);
        TestWorklogResource.assertEquals((String)"Administrator", (String)worklog.updateAuthor.displayName);
        TestWorklogResource.assertNotNull((Object)worklog.created);
        TestWorklogResource.assertNotNull((Object)worklog.updated);
        this.assertEqualDateStrings(TestWorklogResource.asTimeString(now), worklog.started);
        TestWorklogResource.assertEquals((String)"1h", (String)worklog.timeSpent);
        Worklog response2 = this.worklogClient.get(ISSUE_KEY, worklog.id);
        TestWorklogResource.assertTrue((boolean)worklog.equals((Object)response2));
        toAdd = new Worklog();
        toAdd.started = TestWorklogResource.asTimeString(now);
        response = this.worklogClient.post(ISSUE_KEY, toAdd);
        TestWorklogResource.assertEquals((int)400, (int)response.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response.entity.errors.size());
    }

    public void testAddWorklogWhenRoleDoesntExist() {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "role";
        worklog.visibility.value = "not-existing-role";
        Response post = this.worklogClient.post(ISSUE_KEY, worklog);
        TestWorklogResource.assertEquals((int)400, (int)post.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testAddWorklogWhenGroupDoesntExist() {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "group";
        worklog.visibility.value = "not-existing-group";
        Response post = this.worklogClient.post(ISSUE_KEY, worklog);
        TestWorklogResource.assertEquals((int)400, (int)post.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testEditWorklog() throws Exception {
        DateTime date = new DateTime();
        date.plusDays(10);
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.timeSpent = "10h";
        worklog.timeSpentSeconds = null;
        worklog.started = TestWorklogResource.asTimeString(date.toDate());
        worklog.comment = "This is the new comment";
        Response post = this.worklogClient.put(ISSUE_KEY, worklog);
        TestWorklogResource.assertEquals((int)200, (int)post.statusCode);
        TestWorklogResource.assertTrue((boolean)worklog.equals(post.body));
        Worklog freshWorklog = new Worklog();
        freshWorklog.id = worklog.id;
        post = this.worklogClient.put(ISSUE_KEY, freshWorklog);
        TestWorklogResource.assertTrue((boolean)worklog.equals(post.body));
    }

    public void testEditWorklogToRoleWhichDoesntExist() {
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.visibility = new Visibility();
        worklog.visibility.type = "role";
        worklog.visibility.value = "not-existing-role";
        Response post = this.worklogClient.post(ISSUE_KEY, worklog);
        TestWorklogResource.assertEquals((int)400, (int)post.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testEditWorklogToGroupWhichDoesntExist() {
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "group";
        worklog.visibility.value = "not-existing-group";
        Response post = this.worklogClient.post(ISSUE_KEY, worklog);
        TestWorklogResource.assertEquals((int)400, (int)post.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)post.entity.errors.size());
    }

    public void testAddWorklogIssueFields() throws Exception {
        Worklog toAdd = new Worklog();
        toAdd.timeSpent = "1h";
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long totalTime = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
        this.worklogClient.post(ISSUE_KEY, toAdd);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 60L, totalTime += 60L);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "auto").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 60L, totalTime += 60L);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "leave").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        timeEstimate = TimeUnit.HOURS.toMinutes(6L);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "6h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        timeEstimate = TimeUnit.HOURS.toMinutes(5L) + 10L;
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "5h%2010m").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        Response response = this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "new").toMap());
        TestWorklogResource.assertEquals((int)400, (int)response.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response.entity.errors.size());
        TestWorklogResource.assertEquals((String)"Value is required when adjustEstimate is new", (String)((String)response.entity.errors.get("newEstimate")));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "manual").add("reduceBy", "2h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 120L, totalTime += 60L);
        response = this.worklogClient.post(ISSUE_KEY, toAdd, MapBuilder.newBuilder().add("adjustEstimate", "manual").toMap());
        TestWorklogResource.assertEquals((int)400, (int)response.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response.entity.errors.size());
        TestWorklogResource.assertEquals((String)"A value is required for manual estimate adjustment", (String)((String)response.entity.errors.get("reduceBy")));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
    }

    public void testEditWorklogIssueFields() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long totalTime = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
        Worklog worklog = this.getDefaultWorklogFromJira();
        worklog.timeSpent = "1h";
        this.worklogClient.put(ISSUE_KEY, worklog);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate += 60L, totalTime -= 60L);
        worklog.timeSpent = "3h";
        this.worklogClient.put(ISSUE_KEY, worklog);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 120L, totalTime += 120L);
        worklog.timeSpentSeconds = 3600L;
        this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "auto").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate += 120L, totalTime -= 120L);
        worklog.timeSpentSeconds = 7200L;
        this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "leave").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime += 60L);
        worklog.timeSpent = "1h";
        timeEstimate = TimeUnit.HOURS.toMinutes(8L);
        this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "8h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime -= 60L);
        Response response = this.worklogClient.put(ISSUE_KEY, worklog, MapBuilder.newBuilder().add("adjustEstimate", "manual").add("reduceBy", "2h").toMap());
        TestWorklogResource.assertEquals((int)400, (int)response.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response.entity.errors.size());
        TestWorklogResource.assertEquals((String)"Manual adjustment of remaining estimate not allowed when editing a worklog", (String)((String)response.entity.errors.get("adjustEstimate")));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
    }

    public void testDeleteWorklog() throws Exception {
        Date now = new Date();
        Worklog toAdd = new Worklog();
        toAdd.timeSpent = "1h";
        toAdd.started = TestWorklogResource.asTimeString(now);
        Response addReponse = this.worklogClient.post(ISSUE_KEY, toAdd);
        Response deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)addReponse.body);
        TestWorklogResource.assertEquals((int)204, (int)deleteResponse.statusCode);
        Response response = this.worklogClient.getResponse(ISSUE_KEY, ((Worklog)addReponse.body).id);
        TestWorklogResource.assertEquals((int)404, (int)response.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)response.entity.errorMessages.size());
        TestWorklogResource.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("Cannot find worklog with id"));
        deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)addReponse.body);
        TestWorklogResource.assertEquals((int)404, (int)deleteResponse.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)deleteResponse.entity.errorMessages.size());
        TestWorklogResource.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("Cannot find worklog with id"));
    }

    public void testDeleteWorklogAdjustEstimate() throws Exception {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long totalTime = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        Response response = this.worklogClient.post(ISSUE_KEY, worklog);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body);
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "auto").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "leave").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate -= 60L, totalTime);
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        Response deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "new").toMap());
        TestWorklogResource.assertEquals((int)400, (int)deleteResponse.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)deleteResponse.entity.errors.size());
        TestWorklogResource.assertEquals((String)"Value is required when adjustEstimate is new", (String)((String)deleteResponse.entity.errors.get("newEstimate")));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate - 60L, totalTime + 60L);
        timeEstimate = TimeUnit.HOURS.toMinutes(8L);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "new").add("newEstimate", "8h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime);
        timeEstimate -= 60L;
        response = this.worklogClient.post(ISSUE_KEY, worklog);
        deleteResponse = this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "manual").toMap());
        TestWorklogResource.assertEquals((int)400, (int)deleteResponse.statusCode);
        TestWorklogResource.assertEquals((int)1, (int)deleteResponse.entity.errors.size());
        TestWorklogResource.assertEquals((String)"A value is required for manual estimate adjustment", (String)((String)deleteResponse.entity.errors.get("increaseBy")));
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate, totalTime + 60L);
        this.worklogClient.delete(ISSUE_KEY, (Worklog)response.body, MapBuilder.newBuilder().add("adjustEstimate", "manual").add("increaseBy", "2h").toMap());
        this.verifyTimeTracking(ISSUE_KEY, timeEstimate += 120L, totalTime);
    }

    public void testWorklogVisibility() throws Exception {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.visibility.type = "group";
        worklog.visibility.value = "jira-administrators";
        Response response = this.worklogClient.post(ISSUE_KEY, worklog);
        TestWorklogResource.assertEquals((String)worklog.visibility.type, (String)((Worklog)response.body).visibility.type);
        TestWorklogResource.assertEquals((String)worklog.visibility.value, (String)((Worklog)response.body).visibility.value);
        worklog = (Worklog)response.body;
        Worklog doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = null;
        TestWorklogResource.assertTrue((boolean)worklog.equals((Object)doubleCheck));
        worklog.visibility.value = "jira-users";
        worklog.timeSpentSeconds = null;
        response = this.worklogClient.put(ISSUE_KEY, worklog);
        doubleCheck.timeSpentSeconds = null;
        TestWorklogResource.assertTrue((boolean)worklog.equals(response.body));
        doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = null;
        TestWorklogResource.assertTrue((boolean)worklog.equals((Object)doubleCheck));
        this.PUT("rest/api/2/issue/HSP-1/worklog/" + worklog.id, "{\"timeSpent\": \"2h\"}");
        doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        worklog.timeSpent = "2h";
        doubleCheck.timeSpentSeconds = 3600L;
        TestWorklogResource.assertTrue((boolean)worklog.equals((Object)doubleCheck));
        Worklog freshWorklog = new Worklog();
        freshWorklog.id = worklog.id;
        response = this.worklogClient.put(ISSUE_KEY, freshWorklog);
        TestWorklogResource.assertNull((Object)((Worklog)response.body).visibility);
        doubleCheck = this.worklogClient.get(ISSUE_KEY, worklog.id);
        doubleCheck.timeSpentSeconds = null;
        TestWorklogResource.assertNull((Object)doubleCheck.visibility);
    }

    private void verifyTimeTracking(String issueKey, long expectedEstimateHours, long totalTimeHours) throws InvalidDurationException {
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        long timeEstimate = DateUtils.getDuration((String)issue.fields.timetracking.remainingEstimate);
        long timeSpent = DateUtils.getDuration((String)issue.fields.timetracking.timeSpent);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestWorklogAndTimeTracking.xml");
    }

    private static String asTimeString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(TIME_FORMAT).format(date) : null;
    }

    private Worklog getDefaultWorklog() {
        Worklog ew = new Worklog();
        ew.started = "2010-05-24T09:52:00.000+1000";
        ew.created = "2010-05-24T09:52:41.092+1000";
        ew.updated = "2010-05-24T09:52:41.092+1000";
        ew.timeSpent = "2h";
        ew.id = "10000";
        ew.comment = "I'm finished finally!";
        ew.self = this.getBaseUrlPlus("rest/api/2/issue/10000/worklog/10000");
        UserJson user = new UserJson();
        user.self = this.getBaseUrlPlus("rest/api/2/user?username=admin");
        user.name = "admin";
        user.displayName = "Administrator";
        ew.author = user;
        ew.updateAuthor = user;
        return ew;
    }

    private Worklog getDefaultWorklogFromJira() {
        Worklog worklog = this.worklogClient.get(ISSUE_KEY, "10000");
        TestWorklogResource.assertNotNull((Object)worklog);
        return worklog;
    }
}

