/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestWorkflowTransitionProperties
extends RestFuncTest {
    public static final int INITIAL_ACTION = 1;
    public static final int COMMON_ACTION = 5;
    public static final int SIMPLE_ACTION = 301;
    public static final int GLOBAL_ACTION = 711;
    public static final int INVALID_ACTION = 3738;
    public static final String ACTIVE_WORKFLOW_WITH_DRAFT = "ActiveWorkflowWithDraft";
    public static final String ACTIVE_WORKFLOW = "ActiveWorkflow";
    public static final String INACTIVE_WORKFLOW = "InactiveWorkflow";
    public static final String BAD_WORKFLOW = "BadWorkflow";
    public static final String TRANSITION_ID = "transitionId";
    public static final String WORKFLOW_NAME = "workflowName";
    public static final String WORKFLOW_MODE = "workflowMode";
    public static final String KEY = "key";
    public static final String INVALID_MODE = "wAT?";
    public static final String ID_KEY = "ID";
    public static final String INVALID_KEY = "InvalidKey";
    public static final String NON_ADMIN = "fred";
    public static final String VALUE = "value";
    private WorkflowRestApi restApi;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreDataFromResource("TestWorkflowTransitionProperties.xml");
        this.restApi = new WorkflowRestApi(this.environmentData);
    }

    public void testGetAll() {
        this.checkGetAll(ACTIVE_WORKFLOW, false);
        this.checkGetAll(ACTIVE_WORKFLOW_WITH_DRAFT, false);
        this.checkGetAll(ACTIVE_WORKFLOW_WITH_DRAFT, true);
        this.checkGetAll(INACTIVE_WORKFLOW, false);
        this.runInWebsudo(new Runnable(){

            @Override
            public void run() {
                TestWorkflowTransitionProperties.this.checkGetAll(TestWorkflowTransitionProperties.INACTIVE_WORKFLOW, false);
            }
        });
        Response<Map<String, String>> response = this.restApi.getWorkflow(BAD_WORKFLOW).transition(1).getAllResponse();
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(ACTIVE_WORKFLOW).draft().transition(1).getAllResponse();
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(ACTIVE_WORKFLOW).mode(INVALID_MODE).transition(1).getAllResponse();
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, WORKFLOW_MODE);
        response = ((WorkflowRestApi)this.restApi.loginAs(NON_ADMIN)).getWorkflow(ACTIVE_WORKFLOW).transition(1).getAllResponse();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
        response = ((WorkflowRestApi)this.restApi.anonymous()).getWorkflow(ACTIVE_WORKFLOW).transition(1).getAllResponse();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
    }

    public void testGet() {
        this.checkGet(ACTIVE_WORKFLOW, false);
        this.runInWebsudo(new Runnable(){

            @Override
            public void run() {
                TestWorkflowTransitionProperties.this.checkGet(TestWorkflowTransitionProperties.ACTIVE_WORKFLOW, false);
            }
        });
        this.checkGet(ACTIVE_WORKFLOW_WITH_DRAFT, false);
        this.checkGet(ACTIVE_WORKFLOW_WITH_DRAFT, true);
        this.checkGet(INACTIVE_WORKFLOW, false);
        Response<String> response = this.restApi.getWorkflow(BAD_WORKFLOW).transition(1).getPropertyResponse(ID_KEY);
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(ACTIVE_WORKFLOW).draft().transition(1).getPropertyResponse(ID_KEY);
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(ACTIVE_WORKFLOW).mode(INVALID_MODE).transition(1).getPropertyResponse(ID_KEY);
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, WORKFLOW_MODE);
        response = ((WorkflowRestApi)this.restApi.loginAs(NON_ADMIN)).getWorkflow(ACTIVE_WORKFLOW).transition(1).getPropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
        response = ((WorkflowRestApi)this.restApi.anonymous()).getWorkflow(ACTIVE_WORKFLOW).transition(1).getPropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
    }

    public void testPost() {
        this.checkPost(INACTIVE_WORKFLOW, false);
        this.checkPost(ACTIVE_WORKFLOW_WITH_DRAFT, true);
        this.runInWebsudo(new Runnable(){

            @Override
            public void run() {
                WorkflowRestApi.Workflow restApiWorkflow = TestWorkflowTransitionProperties.this.getWorkflow(TestWorkflowTransitionProperties.ACTIVE_WORKFLOW_WITH_DRAFT, true);
                WorkflowRestApi.Transition transition = restApiWorkflow.transition(1);
                Response<?> response = transition.addPropertyResponse("websudo", "Add Me");
                MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
            }
        });
        this.checkPostReadOnly(ACTIVE_WORKFLOW_WITH_DRAFT, false);
        this.checkPostReadOnly(ACTIVE_WORKFLOW, false);
        Response<?> response = this.restApi.getWorkflow(BAD_WORKFLOW).transition(1).addPropertyResponse("ABC", "DEF");
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(INACTIVE_WORKFLOW).draft().transition(1).addPropertyResponse("ABC", "DEF");
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(INACTIVE_WORKFLOW).mode(INVALID_MODE).transition(1).addPropertyResponse("ABC", "DEF");
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, WORKFLOW_MODE);
        response = ((WorkflowRestApi)this.restApi.loginAs(NON_ADMIN)).getWorkflow(INACTIVE_WORKFLOW).transition(1).addPropertyResponse("ABC", "DEF");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
        response = ((WorkflowRestApi)this.restApi.anonymous()).getWorkflow(INACTIVE_WORKFLOW).transition(1).addPropertyResponse("ABC", "DEF");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
    }

    public void testPut() {
        this.checkPut(INACTIVE_WORKFLOW, false);
        this.checkPut(ACTIVE_WORKFLOW_WITH_DRAFT, true);
        this.runInWebsudo(new Runnable(){

            @Override
            public void run() {
                WorkflowRestApi.Workflow restApiWorkflow = TestWorkflowTransitionProperties.this.getWorkflow(TestWorkflowTransitionProperties.ACTIVE_WORKFLOW_WITH_DRAFT, true);
                WorkflowRestApi.Transition transition = restApiWorkflow.transition(1);
                Response<?> response = transition.setPropertyResponse("websudo", "Add Me");
                MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
            }
        });
        this.checkPutReadOnly(ACTIVE_WORKFLOW_WITH_DRAFT, false);
        this.checkPutReadOnly(ACTIVE_WORKFLOW, false);
        Response<?> response = this.restApi.getWorkflow(BAD_WORKFLOW).transition(1).setPropertyResponse("ABC", "DEF");
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(INACTIVE_WORKFLOW).draft().transition(1).setPropertyResponse("ABC", "DEF");
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(INACTIVE_WORKFLOW).mode(INVALID_MODE).transition(1).setPropertyResponse("ABC", "DEF");
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, WORKFLOW_MODE);
        response = ((WorkflowRestApi)this.restApi.loginAs(NON_ADMIN)).getWorkflow(INACTIVE_WORKFLOW).transition(1).setPropertyResponse("ABC", "DEF");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
        response = ((WorkflowRestApi)this.restApi.anonymous()).getWorkflow(INACTIVE_WORKFLOW).transition(1).setPropertyResponse("ABC", "DEF");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
    }

    public void testDelete() {
        this.checkDelete(INACTIVE_WORKFLOW, false);
        this.checkDelete(ACTIVE_WORKFLOW_WITH_DRAFT, true);
        this.runInWebsudo(new Runnable(){

            @Override
            public void run() {
                WorkflowRestApi.Workflow restApiWorkflow = TestWorkflowTransitionProperties.this.getWorkflow(TestWorkflowTransitionProperties.ACTIVE_WORKFLOW_WITH_DRAFT, true);
                WorkflowRestApi.Transition transition = restApiWorkflow.transition(1);
                Response<?> response = transition.deletePropertyResponse("websudo");
                MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
            }
        });
        this.checkDeleteReadOnly(ACTIVE_WORKFLOW_WITH_DRAFT, false);
        this.checkDeleteReadOnly(ACTIVE_WORKFLOW, false);
        Response<?> response = this.restApi.getWorkflow(BAD_WORKFLOW).transition(1).deletePropertyResponse(ID_KEY);
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(INACTIVE_WORKFLOW).draft().transition(1).deletePropertyResponse(ID_KEY);
        this.assertBadResponse(response, HttpStatus.NOT_FOUND, WORKFLOW_NAME);
        response = this.restApi.getWorkflow(INACTIVE_WORKFLOW).mode(INVALID_MODE).transition(1).deletePropertyResponse(ID_KEY);
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, WORKFLOW_MODE);
        response = ((WorkflowRestApi)this.restApi.loginAs(NON_ADMIN)).getWorkflow(INACTIVE_WORKFLOW).transition(1).deletePropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
        response = ((WorkflowRestApi)this.restApi.anonymous()).getWorkflow(INACTIVE_WORKFLOW).transition(1).deletePropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.UNAUTHORIZED.code));
    }

    private void checkDeleteReadOnly(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        this.checkDeleteReadOnly(restApiWorkflow.transition(1));
        this.checkDeleteReadOnly(restApiWorkflow.transition(711));
        this.checkDeleteReadOnly(restApiWorkflow.transition(5));
        this.checkDeleteReadOnly(restApiWorkflow.transition(301));
    }

    public void checkDeleteReadOnly(WorkflowRestApi.Transition transition) {
        Response<?> response = transition.deletePropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.BAD_REQUEST.code));
    }

    private void checkDelete(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        this.checkDelete(restApiWorkflow.transition(1));
        this.checkDelete(restApiWorkflow.transition(711));
        this.checkDelete(restApiWorkflow.transition(5));
        this.checkDelete(restApiWorkflow.transition(301));
    }

    private void checkDelete(WorkflowRestApi.Transition transition) {
        Object id = transition.deletePropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)id.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.OK.code));
        id = transition.getPropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)id.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.NOT_FOUND.code));
        id = transition.deletePropertyResponse(ID_KEY);
        MatcherAssert.assertThat((Object)id.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.NOT_MODIFIED.code));
        id = transition.deletePropertyResponse("   \t\n\r\t  ");
        this.assertBadResponse((Response<?>)id, HttpStatus.BAD_REQUEST, KEY);
    }

    private void checkPut(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        this.checkPut(restApiWorkflow, 1);
        this.checkPut(restApiWorkflow, 5);
        this.checkPut(restApiWorkflow, 711);
        this.checkPut(restApiWorkflow, 301);
    }

    private void checkPut(WorkflowRestApi.Workflow restApiWorkflow, int transitionId) {
        WorkflowRestApi.Transition transition = restApiWorkflow.transition(transitionId);
        transition.setProperty("NEW", "Property");
        MatcherAssert.assertThat((Object)transition.getProperty("NEW"), (Matcher)Matchers.equalTo((Object)"Property"));
        transition.setProperty("NEW", "Property2");
        MatcherAssert.assertThat((Object)transition.getProperty("NEW"), (Matcher)Matchers.equalTo((Object)"Property2"));
        transition.setProperty("NEW", "\t\r\n\t");
        MatcherAssert.assertThat((Object)transition.getProperty("NEW"), (Matcher)Matchers.equalTo((Object)""));
        Response<?> response = transition.setPropertyResponse("   \t\n\r\t  ", "BAD_VALUE");
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, KEY);
        response = transition.addPropertyResponse("BAD_VALUE", null);
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, VALUE);
    }

    private void checkPutReadOnly(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        this.checkPutReadOnly(restApiWorkflow, 1);
        this.checkPutReadOnly(restApiWorkflow, 5);
        this.checkPutReadOnly(restApiWorkflow, 711);
        this.checkPutReadOnly(restApiWorkflow, 301);
    }

    private void checkPutReadOnly(WorkflowRestApi.Workflow restApiWorkflow, int transitionId) {
        WorkflowRestApi.Transition transition = restApiWorkflow.transition(transitionId);
        Response<?> response = transition.setPropertyResponse("Valid", "ReadOnly");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.BAD_REQUEST.code));
    }

    private void checkPostReadOnly(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        this.checkPostReadOnly(restApiWorkflow, 1);
        this.checkPostReadOnly(restApiWorkflow, 5);
        this.checkPostReadOnly(restApiWorkflow, 711);
        this.checkPostReadOnly(restApiWorkflow, 301);
    }

    private void checkPostReadOnly(WorkflowRestApi.Workflow restApiWorkflow, int transitionId) {
        WorkflowRestApi.Transition transition = restApiWorkflow.transition(transitionId);
        Response<?> response = transition.addPropertyResponse("Valid", "ReadOnly");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.BAD_REQUEST.code));
    }

    private void checkPost(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        this.checkPost(restApiWorkflow, 1);
        this.checkPost(restApiWorkflow, 5);
        this.checkPost(restApiWorkflow, 711);
        this.checkPost(restApiWorkflow, 301);
    }

    private void checkPost(WorkflowRestApi.Workflow restApiWorkflow, int transitionId) {
        WorkflowRestApi.Transition transition = restApiWorkflow.transition(transitionId);
        transition.addProperty("NEW", "Property");
        MatcherAssert.assertThat((Object)transition.getProperty("NEW"), (Matcher)Matchers.equalTo((Object)"Property"));
        transition.addProperty("EMPTY", "       ");
        MatcherAssert.assertThat((Object)transition.getProperty("EMPTY"), (Matcher)Matchers.equalTo((Object)""));
        Response<?> response = transition.addPropertyResponse("NEW", "Dup");
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, KEY);
        response = transition.addPropertyResponse("   \t\n\r\t  ", "BAD_VALUE");
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, KEY);
        response = transition.addPropertyResponse("BAD_VALUE", null);
        this.assertBadResponse(response, HttpStatus.BAD_REQUEST, VALUE);
    }

    private void checkGet(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        MatcherAssert.assertThat((Object)restApiWorkflow.transition(1).getProperty(ID_KEY), (Matcher)Matchers.equalTo((Object)String.valueOf(1)));
        MatcherAssert.assertThat((Object)restApiWorkflow.transition(5).getProperty(ID_KEY), (Matcher)Matchers.equalTo((Object)String.valueOf(5)));
        MatcherAssert.assertThat((Object)restApiWorkflow.transition(301).getProperty(ID_KEY), (Matcher)Matchers.equalTo((Object)String.valueOf(301)));
        MatcherAssert.assertThat((Object)restApiWorkflow.transition(711).getProperty(ID_KEY), (Matcher)Matchers.equalTo((Object)String.valueOf(711)));
        Response<String> singleResponse = restApiWorkflow.transition(3738).getPropertyResponse(ID_KEY);
        this.assertBadResponse(singleResponse, HttpStatus.NOT_FOUND, TRANSITION_ID);
        singleResponse = restApiWorkflow.transition(3738).getPropertyResponse(INVALID_KEY);
        this.assertBadResponse(singleResponse, HttpStatus.NOT_FOUND, TRANSITION_ID);
    }

    private WorkflowRestApi.Workflow getWorkflow(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = draft ? this.restApi.getWorkflow(workflowName).draft() : this.restApi.getWorkflow(workflowName);
        return restApiWorkflow;
    }

    private void checkGetAll(String workflowName, boolean draft) {
        WorkflowRestApi.Workflow restApiWorkflow = this.getWorkflow(workflowName, draft);
        MatcherAssert.assertThat(restApiWorkflow.transition(1).getAllProperties(), (Matcher)Matchers.equalTo(this.expectedProperties(workflowName, draft, 1, false)));
        MatcherAssert.assertThat(restApiWorkflow.transition(5).getAllProperties(), (Matcher)Matchers.equalTo(this.expectedProperties(workflowName, draft, 5, false)));
        MatcherAssert.assertThat(restApiWorkflow.transition(301).getAllProperties(), (Matcher)Matchers.equalTo(this.expectedProperties(workflowName, draft, 301, false)));
        MatcherAssert.assertThat(restApiWorkflow.transition(711).getAllProperties(), (Matcher)Matchers.equalTo(this.expectedProperties(workflowName, draft, 711, true)));
        Response<Map<String, String>> allResponse = restApiWorkflow.transition(3738).getAllResponse();
        this.assertBadResponse(allResponse, HttpStatus.NOT_FOUND, TRANSITION_ID);
    }

    private void assertBadResponse(Response<?> allResponse, HttpStatus status, String errorKey) {
        MatcherAssert.assertThat((Object)allResponse.body, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)allResponse.statusCode, (Matcher)Matchers.equalTo((Object)status.code));
        MatcherAssert.assertThat((Object)allResponse.entity.errors, (Matcher)Matchers.hasKey((Object)errorKey));
    }

    private Map<String, String> expectedProperties(String workflowName, boolean draft, int id, boolean global) {
        HashMap expectedProperties = Maps.newHashMap();
        expectedProperties.put(ID_KEY, String.valueOf(id));
        expectedProperties.put("WF", workflowName);
        if (draft) {
            expectedProperties.put("DRAFT", "YES");
        }
        if (global) {
            expectedProperties.put("GLOBAL", "YES");
        }
        return expectedProperties;
    }

    public Map<String, String> toMap(Object ... args) {
        if ((args.length & 1) == 0) {
            HashMap result = Maps.newHashMap();
            int i = 0;
            while (i < args.length) {
                result.put(String.valueOf(args[i++]), String.valueOf(args[i++]));
            }
            return result;
        }
        throw new IllegalArgumentException("Odd number of arguments.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInWebsudo(Runnable runnable) {
        this.backdoor.websudo().enable();
        try {
            runnable.run();
        }
        finally {
            this.backdoor.websudo().disable();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PropertyBean {
        public static final GenericType<List<PropertyBean>> LIST = new GenericType<List<PropertyBean>>(){};
        private final String key;
        private final String value;

        @JsonCreator
        public PropertyBean(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }

        @JsonProperty
        public String getKey() {
            return this.key;
        }

        @JsonProperty
        public String getValue() {
            return this.value;
        }

        @JsonProperty
        public String getId() {
            return this.getKey();
        }

        public static Map<String, String> toMap(List<PropertyBean> beans) {
            HashMap map = Maps.newHashMap();
            for (PropertyBean bean : beans) {
                map.put(bean.getKey(), bean.getValue());
            }
            return map;
        }
    }

    public static class WorkflowRestApi
    extends RestApiClient<WorkflowRestApi> {
        protected WorkflowRestApi(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        protected WebResource createResource() {
            return super.createResource().path("workflow");
        }

        public ActiveWorkflow getWorkflow(String name) {
            return new ActiveWorkflow(name);
        }

        public class Transition {
            private final Workflow workflow;
            private final long transition;

            private Transition(Workflow workflow, long transition) {
                this.workflow = workflow;
                this.transition = transition;
            }

            public String getProperty(String key) {
                PropertyBean propertyBean = (PropertyBean)this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).get(PropertyBean.class);
                return propertyBean.getValue();
            }

            public Response<String> getPropertyResponse(final String key) {
                Response response = WorkflowRestApi.this.toResponse(new RestApiClient.Method(){

                    public ClientResponse call() {
                        return (ClientResponse)Transition.this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
                    }
                }, PropertyBean.class);
                if (response.body != null) {
                    return new Response(response.statusCode, response.entity, (Object)((PropertyBean)response.body).getValue());
                }
                return new Response(response.statusCode, response.entity, null);
            }

            public Map<String, String> getAllProperties() {
                return PropertyBean.toMap((List)this.propertiesResource().get(PropertyBean.LIST));
            }

            public Response<Map<String, String>> getAllResponse() {
                Response response = WorkflowRestApi.this.toResponse(new RestApiClient.Method(){

                    public ClientResponse call() {
                        return (ClientResponse)Transition.this.propertiesResource().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
                    }
                }, PropertyBean.LIST);
                if (response.body != null) {
                    return new Response(response.statusCode, response.entity, PropertyBean.toMap((List)response.body));
                }
                return new Response(response.statusCode, response.entity, null);
            }

            public void addProperty(String key, String value) {
                this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).type(MediaType.APPLICATION_JSON_TYPE).post((Object)new PropertyBean(key, value));
            }

            public Response<?> addPropertyResponse(final String key, final String value) {
                return WorkflowRestApi.this.toResponse(new RestApiClient.Method(){

                    public ClientResponse call() {
                        return (ClientResponse)((WebResource.Builder)Transition.this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).post(ClientResponse.class, (Object)new PropertyBean(key, value));
                    }
                });
            }

            public void setProperty(String key, String value) {
                this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).type(MediaType.APPLICATION_JSON_TYPE).put((Object)new PropertyBean(key, value));
            }

            public Response<?> setPropertyResponse(final String key, final String value) {
                return WorkflowRestApi.this.toResponse(new RestApiClient.Method(){

                    public ClientResponse call() {
                        return (ClientResponse)((WebResource.Builder)Transition.this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).put(ClientResponse.class, (Object)new PropertyBean(key, value));
                    }
                });
            }

            public void deleteProperty(String key) {
                this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).type(MediaType.APPLICATION_JSON_TYPE).delete();
            }

            public Response<?> deletePropertyResponse(final String key) {
                return WorkflowRestApi.this.toResponse(new RestApiClient.Method(){

                    public ClientResponse call() {
                        return (ClientResponse)((WebResource.Builder)Transition.this.propertiesResource().queryParam(TestWorkflowTransitionProperties.KEY, key).type(MediaType.APPLICATION_JSON_TYPE).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).delete(ClientResponse.class);
                    }
                });
            }

            WebResource propertiesResource() {
                return this.resource().path("properties");
            }

            WebResource resource() {
                return this.workflow.resource().path("transitions").path(String.valueOf(this.transition));
            }
        }

        public class ConstantMode
        extends Workflow {
            private final String mode;

            private ConstantMode(String name, String mode) {
                super(name);
                this.mode = mode;
            }

            @Override
            String getMode() {
                return this.mode;
            }
        }

        public class DraftWorkflow
        extends Workflow {
            private DraftWorkflow(String name) {
                super(name);
            }

            public ActiveWorkflow parent() {
                return new ActiveWorkflow(this.getName());
            }

            @Override
            String getMode() {
                return "draft";
            }
        }

        public class ActiveWorkflow
        extends Workflow {
            private ActiveWorkflow(String name) {
                super(name);
            }

            @Override
            String getMode() {
                return "live";
            }

            public DraftWorkflow draft() {
                return new DraftWorkflow(this.getName());
            }

            public ConstantMode mode(String mode) {
                return new ConstantMode(this.getName(), mode);
            }
        }

        public abstract class Workflow {
            private final String name;

            public Workflow(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            WebResource resource() {
                return WorkflowRestApi.this.createResource().queryParam(TestWorkflowTransitionProperties.WORKFLOW_NAME, this.name).queryParam(TestWorkflowTransitionProperties.WORKFLOW_MODE, this.getMode());
            }

            abstract String getMode();

            public Transition transition(int i) {
                return new Transition(this, i);
            }
        }
    }
}

