/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestUserResourceForCreateUpdateDelete
extends RestFuncTest {
    private static final String SELF = "self";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String PASSWORD = "password";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String DISPLAY_NAME = "displayName";
    private static final String KEY_VALUE = "charlie";
    private static final String NAME_VALUE = "Charlie";
    private static final String PASSWORD_VALUE = "abracadabra";
    private static final String EMAIL_ADDRESS_VALUE = "charlie@localhost";
    private static final String DISPLAY_NAME_VALUE = "Charlie of Atlassian";
    private static final String NAME_CHANGED_VALUE = "Charlie2";
    private static final String EMAIL_ADDRESS_CHANGED_VALUE = "charlie2@localhost";
    private static final String DISPLAY_NAME_CHANGED_VALUE = "Charlie of Atlassian II";
    private static final String REST_URL = "/rest/api/2/user?";
    private UserClient userClient;
    private com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.environmentData = this.getEnvironmentData();
        this.userClient = new UserClient(this.environmentData);
        this.backdoor.restoreBlankInstance();
    }

    @Override
    protected void tearDownTest() {
        this.userClient.close();
    }

    public void testHappyPathUseCase() {
        this.thereIsNoUser(KEY_VALUE);
        String createdUserKey = this.createUser();
        this.updateUser(createdUserKey);
        this.changeUserPassword(createdUserKey);
        this.removeExistingUser(createdUserKey);
        this.removeNotExistingUser(createdUserKey);
    }

    private String createUser() {
        ClientResponse responseCreate = this.userClient.createUser(NAME_VALUE, PASSWORD_VALUE, EMAIL_ADDRESS_VALUE, DISPLAY_NAME_VALUE);
        Assert.assertThat((Object)responseCreate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.CREATED.getStatusCode()));
        String createResult = (String)((List)responseCreate.getHeaders().get((Object)"Location")).get(0);
        Assert.assertThat((Object)createResult, (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
        String createdUserKey = this.verifyCreatedUserAndReturnKey(responseCreate);
        responseCreate.close();
        ClientResponse responseRead = this.userClient.getUser(createdUserKey);
        Assert.assertThat((Object)responseRead.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        this.verifyCreatedUserAndReturnKey(responseRead);
        responseRead.close();
        return createdUserKey;
    }

    private String verifyCreatedUserAndReturnKey(ClientResponse responseCreate) {
        UserBean userBean = this.getMapEntity(responseCreate);
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.getName(), (Matcher)Matchers.equalTo((Object)NAME_VALUE));
        Assert.assertThat((Object)userBean.getEmailAddress(), (Matcher)Matchers.equalTo((Object)EMAIL_ADDRESS_VALUE));
        Assert.assertThat((Object)userBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)DISPLAY_NAME_VALUE));
        Assert.assertThat((Object)userBean.getSelf().toString(), (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
        return userBean.getKey();
    }

    private String getJiraExperimentalApiUserPath() {
        return this.environmentData.getBaseUrl() + REST_URL;
    }

    private void updateUser(String userKey) {
        ClientResponse responseUpdate = this.userClient.updateUser(userKey, NAME_CHANGED_VALUE, EMAIL_ADDRESS_CHANGED_VALUE, DISPLAY_NAME_CHANGED_VALUE);
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        UserBean userBean = this.getMapEntity(responseUpdate);
        responseUpdate.close();
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.getName(), (Matcher)Matchers.equalTo((Object)NAME_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getEmailAddress(), (Matcher)Matchers.equalTo((Object)EMAIL_ADDRESS_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)DISPLAY_NAME_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getSelf().toString(), (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
    }

    private void changeUserPassword(String userKey) {
        ClientResponse response = this.userClient.changePassword(userKey, "hocuspocus");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        response.close();
    }

    private void removeExistingUser(String userKey) {
        ClientResponse response = this.userClient.deleteUser(userKey);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        response.close();
        this.thereIsNoUser(userKey);
    }

    private void thereIsNoUser(String userKey) {
        ClientResponse response = this.userClient.getUser(userKey);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private void removeNotExistingUser(String userKey) {
        ClientResponse response = this.userClient.deleteUser(userKey);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        response.close();
    }

    private UserBean getMapEntity(ClientResponse responseRead) {
        return (UserBean)responseRead.getEntity(UserBean.class);
    }

    private class UserClient
    extends RestApiClient<UserClient> {
        private static final String USER_PATH = "user";
        private static final String PASSWORD_PATH = "password";
        private final Set<ClientResponse> responses;

        protected UserClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
            this.responses = Sets.newHashSet();
        }

        protected WebResource createResource() {
            return this.resourceRoot(TestUserResourceForCreateUpdateDelete.this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2");
        }

        private ClientResponse createUser(String name, String password, String emailAddress, String displayName) {
            WebResource webResource = this.createResource().path(USER_PATH);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)TestUserResourceForCreateUpdateDelete.NAME, (Object)name);
            builder.put((Object)"password", (Object)password);
            builder.put((Object)TestUserResourceForCreateUpdateDelete.EMAIL_ADDRESS, (Object)emailAddress);
            builder.put((Object)TestUserResourceForCreateUpdateDelete.DISPLAY_NAME, (Object)displayName);
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").post(ClientResponse.class, (Object)builder.build());
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse getUser(String key) {
            Preconditions.checkNotNull((Object)key);
            WebResource webResource = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, key);
            ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse updateUser(String key, String name, String emailAddress, String displayName) {
            Preconditions.checkNotNull((Object)key);
            WebResource webResource = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, key);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (name != null) {
                builder.put((Object)TestUserResourceForCreateUpdateDelete.NAME, (Object)name);
            }
            if (emailAddress != null) {
                builder.put((Object)TestUserResourceForCreateUpdateDelete.EMAIL_ADDRESS, (Object)emailAddress);
            }
            if (displayName != null) {
                builder.put((Object)TestUserResourceForCreateUpdateDelete.DISPLAY_NAME, (Object)displayName);
            }
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").put(ClientResponse.class, (Object)builder.build());
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse changePassword(String key, String password) {
            Preconditions.checkNotNull((Object)key);
            WebResource webResource = this.createResource().path("user/password").queryParam(TestUserResourceForCreateUpdateDelete.KEY, key);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (password != null) {
                builder.put((Object)"password", (Object)password);
            }
            ClientResponse clientResponse = (ClientResponse)webResource.type("application/json").put(ClientResponse.class, (Object)builder.build());
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse deleteUser(String key) {
            Preconditions.checkNotNull((Object)key);
            WebResource webResource = this.createResource().path(USER_PATH).queryParam(TestUserResourceForCreateUpdateDelete.KEY, key);
            ClientResponse delete = (ClientResponse)webResource.delete(ClientResponse.class);
            this.responses.add(delete);
            return delete;
        }

        private void close() {
            for (ClientResponse response : this.responses) {
                response.close();
            }
        }
    }
}

