/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.atlassian.jira.testkit.client.restclient.UserPickerResults;
import com.atlassian.jira.testkit.client.restclient.UserPickerUser;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestUserResource
extends RestFuncTest {
    private static final String USER_PATH = "user";
    private static final String REST_PATH = "rest/api/2";
    private static final String REST_USER_URL = "rest/api/2/user";
    private UserClient userClient;

    public void testUserResourceNoUsernameNorKey() throws Exception {
        Response response = this.userClient.getUserResponse(null);
        TestUserResource.assertEquals((int)404, (int)response.statusCode);
        TestUserResource.assertTrue((boolean)response.entity.errorMessages.contains("Either the 'username' or the 'key' query parameters need to be provided"));
    }

    public void testUserResourceForUserByNameThatDoesntExist() throws Exception {
        Response response = this.userClient.getUserResponse("bofh");
        TestUserResource.assertEquals((int)404, (int)response.statusCode);
        TestUserResource.assertTrue((boolean)response.entity.errorMessages.contains("The user named 'bofh' does not exist"));
    }

    public void testUserResourceForUserByKeyThatDoesntExist() throws Exception {
        Response response = this.userClient.getUserResponseByKey("bofh");
        TestUserResource.assertEquals((int)404, (int)response.statusCode);
        TestUserResource.assertTrue((boolean)response.entity.errorMessages.contains("The user with the key 'bofh' does not exist"));
    }

    public void testUserResourceForUserByName() throws Exception {
        User fred = this.userClient.get("bloblaw", new User.Expand[0]);
        TestUserResource.assertNotNull((Object)fred);
        TestUserResource.assertEquals((String)"bloblaw", (String)fred.name);
        TestUserResource.assertEquals((String)"bob", (String)fred.key);
    }

    public void testUserResourceForUserByKey() throws Exception {
        User fred = this.userClient.getByKey("bob", new User.Expand[0]);
        TestUserResource.assertNotNull((Object)fred);
        TestUserResource.assertEquals((String)"bloblaw", (String)fred.name);
        TestUserResource.assertEquals((String)"bob", (String)fred.key);
    }

    public void testUserResourceForUserByUsernameAndKey() throws Exception {
        WebResponse response = this.GET("rest/api/2/user?username=bloblaw&key=bob");
        TestUserResource.assertEquals((int)400, (int)response.getResponseCode());
    }

    public void testUserResourceTimeZone() throws Exception {
        User user = this.userClient.get("admin", new User.Expand[0]);
        TestUserResource.assertEquals((String)"Australia/Sydney", (String)user.timeZone);
    }

    public void testUserResourceLocale() {
        User user = this.userClient.get("admin", new User.Expand[0]);
        TestUserResource.assertEquals((String)"en_AU", (String)user.locale);
    }

    public void testSearchUsers() {
        List users = this.userClient.search("fre", "0", null);
        TestUserResource.assertEquals((int)1, (int)users.size());
        User user = (User)users.get(0);
        TestUserResource.assertEquals((String)"fred", (String)user.name);
        TestUserResource.assertEquals((String)"Fred Normal", (String)user.displayName);
        users = this.userClient.search("", "0", null);
        TestUserResource.assertEquals((int)0, (int)users.size());
        users = this.userClient.search("love", "0", null);
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"\u611b", (String)((User)users.get((int)0)).name);
        users = this.userClient.search("a", null, null);
        TestUserResource.assertEquals((int)3, (int)users.size());
        TestUserResource.assertEquals((String)"a\\b", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"admin", (String)((User)users.get((int)1)).name);
        TestUserResource.assertEquals((String)"sp ace", (String)((User)users.get((int)2)).name);
        users = this.userClient.search("a", "0", "1");
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"a\\b", (String)((User)users.get((int)0)).name);
        users = this.userClient.search("a", "1", "30");
        TestUserResource.assertEquals((int)2, (int)users.size());
        TestUserResource.assertEquals((String)"admin", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"sp ace", (String)((User)users.get((int)1)).name);
        users = this.userClient.search("fred", null, null, null, null);
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"fred", (String)((User)users.get((int)0)).name);
        users = this.userClient.search("fred", null, null, null, Boolean.valueOf(true));
        TestUserResource.assertEquals((int)2, (int)users.size());
        TestUserResource.assertEquals((String)"fred", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"fredx", (String)((User)users.get((int)1)).name);
        users = this.userClient.search("fred", null, null, Boolean.valueOf(true), Boolean.valueOf(true));
        TestUserResource.assertEquals((int)2, (int)users.size());
        TestUserResource.assertEquals((String)"fred", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"fredx", (String)((User)users.get((int)1)).name);
        users = this.userClient.search("fred", null, null, Boolean.valueOf(false), Boolean.valueOf(true));
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"fredx", (String)((User)users.get((int)0)).name);
        users = this.userClient.search("fred", null, null, Boolean.valueOf(false), Boolean.valueOf(false));
        TestUserResource.assertEquals((int)0, (int)users.size());
        users = this.userClient.search("blo", null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"bloblaw", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"bob", (String)((User)users.get((int)0)).key);
    }

    public void testPickerUsers() {
        UserPickerResults results = this.userClient.picker("fre", null);
        TestUserResource.assertEquals((int)1, (int)results.users.size());
        UserPickerUser user = (UserPickerUser)results.users.get(0);
        TestUserResource.assertEquals((String)"fred", (String)user.name);
        TestUserResource.assertEquals((String)"fred", (String)user.key);
        TestUserResource.assertEquals((String)"Fred Normal", (String)user.displayName);
        TestUserResource.assertEquals((String)"<strong>Fre</strong>d Normal - <strong>fre</strong>d@example.com (<strong>fre</strong>d)", (String)user.html);
        TestUserResource.assertEquals((String)"Showing 1 of 1 matching users", (String)results.header);
        results = this.userClient.picker("love", null);
        TestUserResource.assertEquals((int)1, (int)results.users.size());
        TestUserResource.assertEquals((String)"\u611b", (String)((UserPickerUser)results.users.get((int)0)).name);
        TestUserResource.assertEquals((String)"Showing 1 of 1 matching users", (String)results.header);
        results = this.userClient.picker("a", null);
        TestUserResource.assertEquals((int)3, (int)results.users.size());
        TestUserResource.assertEquals((String)"<strong>a</strong>\\b - <strong>a</strong>b@example.com (<strong>a</strong>\\b)", (String)((UserPickerUser)results.users.get((int)0)).html);
        TestUserResource.assertEquals((String)"<strong>A</strong>dministrator - <strong>a</strong>dmin@example.com (<strong>a</strong>dmin)", (String)((UserPickerUser)results.users.get((int)1)).html);
        TestUserResource.assertEquals((String)"sp <strong>a</strong>ce - space@example.com (sp <strong>a</strong>ce)", (String)((UserPickerUser)results.users.get((int)2)).html);
        TestUserResource.assertEquals((String)"Showing 3 of 3 matching users", (String)results.header);
    }

    public void testUsersByPermission() {
        Backdoor testkit = new Backdoor((JIRAEnvironmentData)this.getEnvironmentData());
        testkit.usersAndGroups().addGroup("group");
        testkit.usersAndGroups().addUser("groupie");
        testkit.usersAndGroups().addUserToGroup("groupie", "group");
        testkit.usersAndGroups().addUser("singleton");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToSingleUser(ProjectPermissions.EDIT_ALL_COMMENTS, "singleton");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.EDIT_OWN_COMMENTS, "group");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ASSIGNABLE_USER, "group");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToCurrentAssignee(ProjectPermissions.DELETE_OWN_COMMENTS);
        TestUserResource.assertEquals((String)"HSP-1", (String)testkit.issues().createIssue((String)"HSP", (String)"Permissions test").key);
        class TemporaryClient
        extends UserClient {
            protected TemporaryClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
                super((JIRAEnvironmentData)environmentData);
            }

            private WebResource applyPagingParams(String query, String startAt, String maxResults, WebResource resource) {
                resource = resource.queryParam("username", query);
                if (StringUtils.isNotBlank((String)startAt)) {
                    resource = resource.queryParam("startAt", startAt);
                }
                if (StringUtils.isNotBlank((String)maxResults)) {
                    resource = resource.queryParam("maxResults", maxResults);
                }
                return resource;
            }

            public List<User> searchByPermission(String query, Iterable<String> permissions, String issueKey, String projectKey, String startAt, String maxResults) {
                String permissionString = Joiner.on((String)",").join(permissions);
                WebResource resource = this.getSearchByPermissionResource(query, permissionString, issueKey, projectKey, startAt, maxResults);
                return Arrays.asList((Object[])resource.get(User[].class));
            }

            public WebResource getSearchByPermissionResource(String query, String permissions, String issueKey, String projectKey, String startAt, String maxResults) {
                WebResource resource = this.applyPagingParams(query, startAt, maxResults, this.createResource().path(TestUserResource.USER_PATH).path("permission").path("search"));
                if (issueKey != null) {
                    resource = resource.queryParam("issueKey", issueKey);
                }
                if (projectKey != null) {
                    resource = resource.queryParam("projectKey", projectKey);
                }
                return resource.queryParam("permissions", permissions);
            }
        }
        TemporaryClient temporaryClient = new TemporaryClient(this.getEnvironmentData());
        Function<User, String> USERNAME = new Function<User, String>(){

            public String apply(User input) {
                return input.name;
            }
        };
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"singleton"), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"COMMENT_EDIT_ALL"), "HSP-1", null, null, null), (Function)USERNAME));
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"singleton"), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"COMMENT_EDIT_ALL"), null, "HSP", null, null), (Function)USERNAME));
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"groupie"), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"COMMENT_EDIT_OWN"), null, "HSP", null, null), (Function)USERNAME));
        TestUserResource.assertEquals((Object)ImmutableList.of(), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"COMMENT_EDIT_OWN", (Object)"COMMENT_DELETE_OWN"), "HSP-1", null, null, null), (Function)USERNAME));
        testkit.issues().assignIssue("HSP-1", "groupie");
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"groupie"), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"COMMENT_EDIT_OWN", (Object)"COMMENT_DELETE_OWN"), "HSP-1", null, null, null), (Function)USERNAME));
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"a\\b", (Object)"admin", (Object)"bloblaw", (Object)"c/d", (Object)"groupie"), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"ASSIGNABLE_USER"), "HSP-1", null, null, null), (Function)USERNAME));
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"admin", (Object)"bloblaw"), (Object)Lists.transform(temporaryClient.searchByPermission("", (Iterable<String>)ImmutableList.of((Object)"ASSIGNABLE_USER"), "HSP-1", null, "1", "2"), (Function)USERNAME));
        TestUserResource.assertEquals((Object)ImmutableList.of((Object)"groupie"), (Object)Lists.transform(temporaryClient.searchByPermission("gro", (Iterable<String>)ImmutableList.of((Object)"ASSIGNABLE_USER"), "HSP-1", null, "0", "1"), (Function)USERNAME));
    }

    public void testAssignableAndViewableUsers() {
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ASSIGNABLE_USER, "jira-administrators");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.BROWSE_PROJECTS, "jira-developers");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Sample Issue");
        List users = this.userClient.search("a", null, null);
        TestUserResource.assertEquals((int)3, (int)users.size());
        TestUserResource.assertEquals((String)"a\\b", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"admin", (String)((User)users.get((int)1)).name);
        TestUserResource.assertEquals((String)"sp ace", (String)((User)users.get((int)2)).name);
        users = this.userClient.searchAssignable("a", issueKey, null, null);
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"admin", (String)((User)users.get((int)0)).name);
        users = this.userClient.searchViewableIssue("a", issueKey, null, null);
        TestUserResource.assertEquals((int)2, (int)users.size());
        TestUserResource.assertEquals((String)"a\\b", (String)((User)users.get((int)0)).name);
        TestUserResource.assertEquals((String)"admin", (String)((User)users.get((int)1)).name);
    }

    public void testUnprivilegedAccessToBrowseUsersYieldsNoResults() {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Sample Issue");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-users");
        this.backdoor.permissions().removeGlobalPermission(27, "jira-developers");
        this.backdoor.permissions().addGlobalPermission(27, "jira-administrators");
        List users = this.userClient.searchViewableIssue("a", issueKey, null, null);
        TestUserResource.assertEquals((int)3, (int)users.size());
        this.userClient.loginAs("fred");
        users = this.userClient.searchViewableIssue("a", issueKey, null, null);
        TestUserResource.assertEquals((int)0, (int)users.size());
    }

    public void testUnprivilegedAccessToAssignableUsersIsDenied() {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Sample Issue");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGN_ISSUES, "jira-administrators");
        Response response = this.userClient.getResponse(this.userClient.getSearchAssignableResource("a", issueKey, null, null));
        TestUserResource.assertEquals((int)401, (int)response.statusCode);
    }

    public void testDoNotRequireBrowseUserPermissionToListAssignableUsers() {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Sample Issue");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGN_ISSUES, "jira-users");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGN_ISSUES, "jira-administrators");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGNABLE_USER, "jira-users");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ASSIGNABLE_USER, "jira-administrators");
        this.administration.permissionSchemes().defaultScheme().removePermission(GlobalPermissionKey.USER_PICKER, "jira-users");
        this.administration.permissionSchemes().defaultScheme().removePermission(GlobalPermissionKey.USER_PICKER, "jira-developers");
        this.administration.permissionSchemes().defaultScheme().removePermission(GlobalPermissionKey.USER_PICKER, "jira-administrators");
        this.userClient.loginAs("c/d", "c/d");
        List users = this.userClient.searchAssignable("a", issueKey, null, null);
        TestUserResource.assertEquals((int)1, (int)users.size());
        TestUserResource.assertEquals((String)"admin", (String)((User)users.get((int)0)).name);
    }

    public void testUserResourceGroupsNotExpanded() throws Exception {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        User user = this.userClient.get("fred", new User.Expand[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.self);
        TestUserResource.assertEquals((String)"groups", (String)user.expand);
        TestUserResource.assertNotNull((Object)user.groups.size);
        TestUserResource.assertEquals((long)1L, (long)user.groups.size);
        TestUserResource.assertNotNull((Object)user.groups.items);
        TestUserResource.assertTrue((boolean)user.groups.items.isEmpty());
    }

    public void testUserResourceGroupsExpanded() throws Exception {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        User user = this.userClient.get("fred", new User.Expand[]{User.Expand.groups});
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.self);
        TestUserResource.assertNotNull((Object)user.groups);
        TestUserResource.assertEquals((long)1L, (long)user.groups.size);
        TestUserResource.assertNotNull((Object)user.groups.items);
        TestUserResource.assertEquals((int)1, (int)user.groups.items.size());
        TestUserResource.assertEquals((String)"jira-users", (String)((Group)user.groups.items.get(0)).name());
    }

    public void testGetAnonymouslyUserResource() throws Exception {
        Response response = ((UserClient)this.userClient.anonymous()).getUserResponse("fred");
        TestUserResource.assertEquals((int)401, (int)response.statusCode);
    }

    public void testUnicodeCharacters() throws Exception {
        String username = "\u611b";
        String userPath = this.getPathFor("%E6%84%9B");
        User user = this.userClient.get("\u611b", new User.Expand[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.self);
        TestUserResource.assertEquals((String)"\u611b", (String)user.name);
        TestUserResource.assertEquals((String)"\u611b \u6237", (String)user.displayName);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/user?username=%E6%84%9B"), (String)user.self);
    }

    public void testAvatarUrls() throws Exception {
        String username = "fred";
        User user = this.userClient.get("fred", new User.Expand[0]);
        Assert.assertThat((Object)user.avatarUrls, (Matcher)CoreMatchers.equalTo(this.createUserAvatarUrls(10062L)));
    }

    public void testUsernamesWithInterestingCharacters() throws Exception {
        this.assertUserRepresentationIsOK("a\\b", "a%5Cb");
        this.assertUserRepresentationIsOK("c/d", "c/d");
        this.assertUserRepresentationIsOK("sp ace", "sp+ace");
        this.assertUserRepresentationIsOK("pl+us", "pl%2Bus");
        this.assertUserRepresentationIsOK("per%cent", "per%25cent");
        this.assertUserRepresentationIsOK("\u611b", "%E6%84%9B");
    }

    public void testUserResourceShouldMaskEmailAddresses() throws Exception {
        this.administration.generalConfiguration().setUserEmailVisibility(GeneralConfiguration.EmailVisibility.MASKED);
        User user = this.userClient.get("fred", new User.Expand[0]);
        Assert.assertThat((Object)user.emailAddress, (Matcher)CoreMatchers.equalTo((Object)"fred at example dot com"));
    }

    public void testUserResourceShouldHideEmailAddresses() throws Exception {
        this.administration.generalConfiguration().setUserEmailVisibility(GeneralConfiguration.EmailVisibility.HIDDEN);
        User user = this.userClient.get("fred", new User.Expand[0]);
        TestUserResource.assertNull((Object)user.emailAddress);
    }

    public void testUserGetAndSetColumns() {
        List<ColumnControl.ColumnItem> items = this.backdoor.columnControl().getLoggedInUserColumns();
        ArrayList defaultColumns = Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"});
        for (int i = 0; i < items.size(); ++i) {
            TestUserResource.assertEquals((String)((String)defaultColumns.get(0)), (String)items.get((int)0).value);
        }
        TestUserResource.assertEquals((int)defaultColumns.size(), (int)items.size());
        ArrayList newColumns = Lists.newArrayList((Iterable)defaultColumns);
        newColumns.add("description");
        newColumns.add("resolutiondate");
        newColumns.remove("summary");
        newColumns.remove("status");
        TestUserResource.assertTrue((String)"No errors when setting the column", (boolean)this.backdoor.columnControl().setLoggedInUserColumns(newColumns));
        items = this.backdoor.columnControl().getLoggedInUserColumns();
        for (int i = 0; i < items.size(); ++i) {
            TestUserResource.assertEquals((String)((String)newColumns.get(0)), (String)items.get((int)0).value);
        }
        TestUserResource.assertEquals((int)newColumns.size(), (int)items.size());
        TestUserResource.assertTrue((String)"No errors when removing all columns", (boolean)this.backdoor.columnControl().setLoggedInUserColumns(Lists.newArrayList()));
        TestUserResource.assertEquals((int)0, (int)this.backdoor.columnControl().getLoggedInUserColumns().size());
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.userClient = new UserClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestUserResource.xml");
    }

    protected String getPathFor(String username) {
        return this.getPathFor(username, Collections.emptyMap());
    }

    private void assertUserRepresentationIsOK(String username, String encodedUsername) {
        String userPath = this.getPathFor(encodedUsername);
        User user = this.userClient.get(username, new User.Expand[0]);
        TestUserResource.assertEquals((String)username, (String)user.name);
        TestUserResource.assertEquals((String)"The username is not encoded in the self link", (String)this.getBaseUrlPlus("rest/api/2/user?username=" + encodedUsername), (String)user.self);
    }

    protected String getPathFor(String username, Map<?, ?> queryParams) {
        return "rest/api/2/user?username=" + username + StringUtils.join((Collection)Collections2.transform(queryParams.entrySet(), (Function)new Function<Map.Entry, Object>(){

            public Object apply(Map.Entry from) {
                return String.format("&%s=%s", from.getKey(), from.getValue());
            }
        }), (String)"");
    }

    private Map<String, String> createUserAvatarUrls(Long avatarId) {
        return ImmutableMap.builder().put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/useravatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/useravatar?avatarId=" + avatarId)).build();
    }
}

