/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.SystemPropertiesControl;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.upgrade.UpgradeManagerClient;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Collections;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestUpgradeManagerResource
extends RestFuncTest {
    private static final String UPGRADE_PROPERTY_NAME = "UpgradeTaskForTesting.invocationCount";
    private static final String UPGRADE_REINDEX_ALLOWED_PROPERTY = "upgrade.reindex.allowed";
    private UpgradeManagerClient upgradeManagerClient;
    private SystemPropertiesControl systemPropertiesClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.upgradeManagerClient = new UpgradeManagerClient(this.getEnvironmentData());
        this.systemPropertiesClient = new SystemPropertiesControl((JIRAEnvironmentData)this.getEnvironmentData());
        this.systemPropertiesClient.unsetProperty(UPGRADE_PROPERTY_NAME);
        this.systemPropertiesClient.unsetProperty(UPGRADE_REINDEX_ALLOWED_PROPERTY);
        this.administration.restoreData("TestEditIssue.xml");
    }

    @Override
    protected void tearDownTest() {
        this.administration.restoreBlankInstance();
        super.tearDownTest();
    }

    public void testRunUpgradeTask() {
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.UpgradeTaskForTesting");
        this.upgradeManagerClient.doUpgrade();
        String ic = this.systemPropertiesClient.getProperty(UPGRADE_PROPERTY_NAME);
        TestUpgradeManagerResource.assertEquals((String)"Expected upgrade task to run once.", (String)"1", (String)ic);
    }

    public void testUpgradeTaskWithReindex() {
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestUpgradeManagerResource.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.UpgradeTaskForTesting");
        this.upgradeManagerClient.doUpgrade();
        String ic = this.systemPropertiesClient.getProperty(UPGRADE_PROPERTY_NAME);
        TestUpgradeManagerResource.assertEquals((String)"Expected upgrade task to run once.", (String)"1", (String)ic);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestUpgradeManagerResource.assertEquals((String)"Issue not found.", (int)1, (int)result.issues.size());
    }

    public void testUpgradeTaskWithoutReindex() {
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestUpgradeManagerResource.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.UpgradeTaskForTestingNoReindex");
        this.upgradeManagerClient.doUpgrade();
        String ic = this.systemPropertiesClient.getProperty(UPGRADE_PROPERTY_NAME);
        TestUpgradeManagerResource.assertEquals((String)"Expected upgrade task to run once.", (String)"1", (String)ic);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestUpgradeManagerResource.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
    }

    public void testReindexNotAllowed() {
        this.systemPropertiesClient.setProperty(UPGRADE_REINDEX_ALLOWED_PROPERTY, Boolean.FALSE.toString());
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestUpgradeManagerResource.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.UpgradeTaskForTesting");
        this.upgradeManagerClient.doUpgrade();
        String ic = this.systemPropertiesClient.getProperty(UPGRADE_PROPERTY_NAME);
        TestUpgradeManagerResource.assertEquals((String)"Expected upgrade task to run once.", (String)"1", (String)ic);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestUpgradeManagerResource.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
    }

    public void testFailedUpgradePreventsSubsequentTasksFromRunning() {
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.UpgradeTaskForTesting");
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.FailingUpgradeTaskForTesting");
        this.upgradeManagerClient.addUpgradeTask("com.atlassian.jira.dev.backdoor.UpgradeTaskForTestingNoReindex");
        try {
            this.upgradeManagerClient.doUpgrade();
            TestUpgradeManagerResource.fail((String)"Expected 500 error.");
        }
        catch (UniformInterfaceException uniformInterfaceException) {
            // empty catch block
        }
        String ic = this.systemPropertiesClient.getProperty(UPGRADE_PROPERTY_NAME);
        TestUpgradeManagerResource.assertEquals((String)"Wrong upgrade task execution count.", (String)"2", (String)ic);
    }
}

