/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.Arrays;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestTextFieldCharacterLengthValidator
extends RestFuncTest {
    private static final String DESCRIPTION_ERRORS_KEY = "description";
    private static final String ENVIRONMENT_ERRORS_KEY = "environment";
    private static final int LIMIT = 100;
    private static final String EXPECTED_WARNING_MESSAGE = "The entered text is too long. It exceeds the allowed limit of 100 characters.";
    final String veryLongText = TestTextFieldCharacterLengthValidator.createTooLongText(100);
    final String tooLongText = TestTextFieldCharacterLengthValidator.createTooLongText(101);
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        Assert.assertThat((String)"expecting a text not longer than 100 characters", (Object)this.veryLongText.length(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100)))));
        Assert.assertThat((String)"expecting a text longer than 100 characters", (Object)this.tooLongText.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100))));
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit(100L);
    }

    public void testDescriptionAndEnvironmentSystemField() throws Exception {
        this.runCreateIssueWithVeryLongDescriptionFieldTest();
        this.runCreateIssueWithTooLongDescriptionFieldTest();
        this.runCreateIssueWithVeryLongEnvironmentFieldTest();
        this.runCreateIssueWithTooLongEnvironmentFieldTest();
        this.runEditIssueWithVeryLongDescriptionFieldTest();
        this.runEditIssueWithTooLongDescriptionFieldTest();
        this.runEditIssueWithVeryLongEnvironmentFieldTest();
        this.runEditIssueWithTooLongEnvironmentFieldTest();
    }

    private void runCreateIssueWithVeryLongDescriptionFieldTest() {
        IssueFields fields = this.createIssue().description(this.veryLongText);
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields);
        ((IssueClient)this.issueClient.loginAs("admin")).create(request);
    }

    private void runCreateIssueWithTooLongDescriptionFieldTest() {
        IssueFields fields = this.createIssue().description(this.tooLongText);
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields);
        Response response = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(request);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)400));
        Assert.assertThat(response.entity.errors.get(DESCRIPTION_ERRORS_KEY), (Matcher)Matchers.is((Object)EXPECTED_WARNING_MESSAGE));
    }

    private void runCreateIssueWithVeryLongEnvironmentFieldTest() {
        IssueFields fields = this.createIssue().environment(this.veryLongText);
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields);
        ((IssueClient)this.issueClient.loginAs("admin")).create(request);
    }

    private void runCreateIssueWithTooLongEnvironmentFieldTest() {
        IssueFields fields = this.createIssue().environment(this.tooLongText);
        IssueUpdateRequest request = new IssueUpdateRequest().fields(fields);
        Response response = ((IssueClient)this.issueClient.loginAs("admin")).getResponse(request);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)400));
        Assert.assertThat(response.entity.errors.get(ENVIRONMENT_ERRORS_KEY), (Matcher)Matchers.is((Object)EXPECTED_WARNING_MESSAGE));
    }

    private void runEditIssueWithVeryLongDescriptionFieldTest() {
        IssueUpdateRequest updateDescriptionRequest = new IssueUpdateRequest().fields(new IssueFields().description(this.veryLongText));
        this.issueClient.update("TST-1", updateDescriptionRequest);
    }

    private void runEditIssueWithTooLongDescriptionFieldTest() {
        IssueUpdateRequest updateDescriptionRequest = new IssueUpdateRequest().fields(new IssueFields().description(this.tooLongText));
        Response response = this.issueClient.updateResponse("TST-1", updateDescriptionRequest);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)400));
        Assert.assertThat(response.entity.errors.get(DESCRIPTION_ERRORS_KEY), (Matcher)Matchers.is((Object)EXPECTED_WARNING_MESSAGE));
    }

    private void runEditIssueWithVeryLongEnvironmentFieldTest() {
        IssueUpdateRequest updateEnvironmentRequest = new IssueUpdateRequest().fields(new IssueFields().environment(this.veryLongText));
        this.issueClient.update("TST-1", updateEnvironmentRequest);
    }

    private void runEditIssueWithTooLongEnvironmentFieldTest() {
        IssueUpdateRequest updateEnvironmentRequest = new IssueUpdateRequest().fields(new IssueFields().environment(this.tooLongText));
        Response response = this.issueClient.updateResponse("TST-1", updateEnvironmentRequest);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)400));
        Assert.assertThat(response.entity.errors.get(ENVIRONMENT_ERRORS_KEY), (Matcher)Matchers.is((Object)EXPECTED_WARNING_MESSAGE));
    }

    private IssueFields createIssue() {
        IssueFields fields = new IssueFields();
        fields.project(ResourceRef.withId((String)"10000"));
        fields.issueType(ResourceRef.withId((String)"1"));
        fields.summary("my first fields");
        fields.description(DESCRIPTION_ERRORS_KEY);
        fields.fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10001")});
        fields.components(new ResourceRef[]{ResourceRef.withId((String)"10000")});
        fields.labels(Arrays.asList("abc", "def"));
        fields.dueDate("2011-03-01");
        fields.versions(new ResourceRef[]{ResourceRef.withId((String)"10000")});
        fields.environment(ENVIRONMENT_ERRORS_KEY);
        fields.timeTracking(new TimeTracking("2h", null));
        return fields;
    }

    private static String createTooLongText(int numberOfCharacters) {
        return RandomStringUtils.random((int)numberOfCharacters, (char[])"abcdefghijklmnopqrstuvwxyz ".toCharArray());
    }
}

