/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.ArrayList;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestSystemColumns
extends RestFuncTest {
    private Function<ColumnControl.ColumnItem, String> COLUMNITEM_TO_STRING = new Function<ColumnControl.ColumnItem, String>(){

        public String apply(ColumnControl.ColumnItem input) {
            return input.value;
        }
    };

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testGetAndSetSystemDefaultColumnsNotAdmin() {
        boolean hasException;
        block2: {
            this.backdoor.usersAndGroups().removeUserFromGroup("admin", "jira-administrators");
            TestSystemColumns.assertFalse((String)"Non admin has no access to set system columns", (boolean)this.backdoor.columnControl().setSystemDefaultColumns(Lists.newArrayList()));
            hasException = false;
            try {
                this.backdoor.columnControl().getSystemDefaultColumns();
            }
            catch (UniformInterfaceException e) {
                if (e.getResponse().getStatus() != 403) break block2;
                hasException = true;
            }
        }
        TestSystemColumns.assertTrue((String)"Non admin has no access to get system columns", (boolean)hasException);
        this.backdoor.usersAndGroups().addUserToGroup("admin", "jira-administrators");
    }

    public void testGetAndSetSystemDefaultColumns() {
        ArrayList defaultColumns = Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "assignee", "reporter", "priority", "status", "resolution", "created", "updated", "duedate"});
        TestSystemColumns.assertEquals((Object)defaultColumns, (Object)Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), this.COLUMNITEM_TO_STRING));
        ArrayList systemColumns = Lists.newArrayList((Iterable)defaultColumns);
        systemColumns.add("description");
        systemColumns.add("resolutiondate");
        systemColumns.remove("summary");
        systemColumns.remove("status");
        TestSystemColumns.assertTrue((String)"No errors when setting the column", (boolean)this.backdoor.columnControl().setSystemDefaultColumns(systemColumns));
        TestSystemColumns.assertEquals((Object)systemColumns, (Object)Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), this.COLUMNITEM_TO_STRING));
        TestSystemColumns.assertEquals((Object)systemColumns, (Object)Lists.transform(this.backdoor.columnControl().getLoggedInUserColumns(), this.COLUMNITEM_TO_STRING));
        ArrayList userColumns = Lists.newArrayList((Iterable)systemColumns);
        userColumns.add("status");
        userColumns.add("summary");
        TestSystemColumns.assertTrue((String)"No errors when setting the column", (boolean)this.backdoor.columnControl().setLoggedInUserColumns(userColumns));
        TestSystemColumns.assertEquals((Object)userColumns, (Object)Lists.transform(this.backdoor.columnControl().getLoggedInUserColumns(), this.COLUMNITEM_TO_STRING));
        TestSystemColumns.assertEquals((Object)systemColumns, (Object)Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), this.COLUMNITEM_TO_STRING));
        TestSystemColumns.assertTrue((String)"No errors when removing all columns", (boolean)this.backdoor.columnControl().setSystemDefaultColumns(Lists.newArrayList()));
        TestSystemColumns.assertEquals((int)0, (int)this.backdoor.columnControl().getSystemDefaultColumns().size());
    }
}

