/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Status;
import com.atlassian.jira.testkit.client.restclient.StatusClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestStatusResource
extends RestFuncTest {
    private static final String STATUS_ID = "10000";
    private static final String STATUS_NAME = "Insane";
    private static final String STATUS_NAME_TRANSLATED = "NotStarted";
    private StatusClient statusClient;

    public void testStatusReturned() throws Exception {
        Status status = this.statusClient.get(STATUS_ID);
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/status/10000"), (String)status.self());
        TestStatusResource.assertEquals((String)"Custom status", (String)status.description());
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("images/icons/statuses/generic.png"), (String)status.iconUrl());
        TestStatusResource.assertEquals((String)STATUS_NAME, (String)status.name());
        TestStatusResource.assertEquals((String)STATUS_ID, (String)status.id());
        status = this.statusClient.get(STATUS_NAME);
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/status/10000"), (String)status.self());
        TestStatusResource.assertEquals((String)"Custom status", (String)status.description());
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("images/icons/statuses/generic.png"), (String)status.iconUrl());
        TestStatusResource.assertEquals((String)STATUS_NAME, (String)status.name());
        TestStatusResource.assertEquals((String)STATUS_ID, (String)status.id());
        status = this.statusClient.get(STATUS_NAME_TRANSLATED);
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/status/1"), (String)status.self());
        TestStatusResource.assertEquals((String)"Translated version of Open", (String)status.description());
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("images/icons/statuses/open.png"), (String)status.iconUrl());
        TestStatusResource.assertEquals((String)STATUS_NAME_TRANSLATED, (String)status.name());
        TestStatusResource.assertEquals((String)"1", (String)status.id());
        status = this.statusClient.get("Open");
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/status/1"), (String)status.self());
        TestStatusResource.assertEquals((String)"Translated version of Open", (String)status.description());
        TestStatusResource.assertEquals((String)this.getBaseUrlPlus("images/icons/statuses/open.png"), (String)status.iconUrl());
        TestStatusResource.assertEquals((String)STATUS_NAME_TRANSLATED, (String)status.name());
        TestStatusResource.assertEquals((String)"1", (String)status.id());
    }

    public void testAllStatuses() throws Exception {
        List statuses = this.statusClient.get();
        TestStatusResource.assertEquals((int)6, (int)statuses.size());
        this.assertStatusesContain(statuses, "1");
        this.assertStatusesContain(statuses, "3");
        this.assertStatusesContain(statuses, "4");
        this.assertStatusesContain(statuses, "5");
        this.assertStatusesContain(statuses, "6");
        this.assertStatusesContain(statuses, STATUS_ID);
    }

    private void assertStatusesContain(List<Status> statuses, String id) {
        for (Status status : statuses) {
            if (!status.id().equals(id)) continue;
            return;
        }
        TestStatusResource.fail((String)("Status " + id + " not in list"));
    }

    public void testStatusFilteredByPermissions() throws Exception {
        Response response = ((StatusClient)this.statusClient.loginAs("fred")).getResponse(STATUS_ID);
        TestStatusResource.assertEquals((int)404, (int)response.statusCode);
        response = ((StatusClient)this.statusClient.loginAs("fred")).getResponse(STATUS_NAME);
        TestStatusResource.assertEquals((int)404, (int)response.statusCode);
        List statuses = this.statusClient.get();
        TestStatusResource.assertEquals((int)5, (int)statuses.size());
        this.assertStatusesContain(statuses, "1");
        this.assertStatusesContain(statuses, "3");
        this.assertStatusesContain(statuses, "4");
        this.assertStatusesContain(statuses, "5");
        this.assertStatusesContain(statuses, "6");
    }

    public void testStatusDoesntExist() throws Exception {
        Response resp123 = this.statusClient.getResponse("123");
        TestStatusResource.assertEquals((int)404, (int)resp123.statusCode);
        TestStatusResource.assertEquals((String)"The status with id '123' does not exist", (String)((String)resp123.entity.errorMessages.get(0)));
        Response respAbc = this.statusClient.getResponse("abc");
        TestStatusResource.assertEquals((int)404, (int)respAbc.statusCode);
        TestStatusResource.assertEquals((String)"The status with id 'abc' does not exist", (String)((String)respAbc.entity.errorMessages.get(0)));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.statusClient = new StatusClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestStatusResource.xml");
    }
}

