/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.backdoor.PluginIndexConfigurationControl;
import com.atlassian.jira.functest.framework.backdoor.SearchAutoCompleteControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.JQL, Category.REFERENCE_PLUGIN})
public class TestSearchAutoCompleteResource
extends RestFuncTest {
    private static final String CUSTOM_FIELD_TYPE = String.format("%s:%s", "com.atlassian.jira.plugin.system.customfieldtypes", "textfield");
    private SearchAutoCompleteControl client;
    private PluginIndexConfigurationControl configurationControlClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.client = new SearchAutoCompleteControl(this.getEnvironmentData());
        this.configurationControlClient = new PluginIndexConfigurationControl(this.getEnvironmentData());
    }

    public void testAutoCompleteControlContainsJqlAlias() throws Exception {
        this.updatePluginIndexConfiguration("com.atlassian.jira.dev.reference-plugin", "pluginindexconfiguration1.xml", this.configurationControlClient);
        SearchAutoCompleteControl.AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        SearchAutoCompleteControl.AutoCompleteField labelField = this.createAutoCompleteField("label", "label", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        SearchAutoCompleteControl.AutoCompleteField labelDate = this.createAutoCompleteField("labelDate", "labelDate", false, OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, Date.class, true);
        SearchAutoCompleteControl.AutoCompleteField labelDescription = this.createAutoCompleteField("labelDescription", "labelDescription", false, OperatorClasses.TEXT_OPERATORS, String.class, true);
        SearchAutoCompleteControl.AutoCompleteField labelId = this.createAutoCompleteField("labelId", "labelId", false, OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY, Number.class, true);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new SearchAutoCompleteControl.AutoCompleteField[]{labelField, labelDate, labelDescription, labelId}));
    }

    public void testAutoCompleteWithConflictingAliases() throws Exception {
        this.updatePluginIndexConfiguration("plugin 1", "conflict_indexconf1.xml", this.configurationControlClient);
        this.updatePluginIndexConfiguration("plugin 2", "conflict_indexconf2.xml", this.configurationControlClient);
        SearchAutoCompleteControl.AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        SearchAutoCompleteControl.AutoCompleteField firstLabelField = this.createAutoCompleteField("\"issue.property[label].value\"", "conflict - plugin 1", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        SearchAutoCompleteControl.AutoCompleteField secondLabelField = this.createAutoCompleteField("\"issue.property[conflicting_alias].value\"", "conflict - plugin 2", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new SearchAutoCompleteControl.AutoCompleteField[]{firstLabelField, secondLabelField}));
    }

    public void testAutoCompleteWithConflictingAliasesAndCustomFields() {
        this.updatePluginIndexConfiguration("plugin 1", "conflict_indexconf1.xml", this.configurationControlClient);
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        SearchAutoCompleteControl.AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        SearchAutoCompleteControl.AutoCompleteField firstLabelField = this.createAutoCompleteField("\"issue.property[label].value\"", "conflict - plugin 1", true, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, String.class, true);
        SearchAutoCompleteControl.AutoCompleteField customField = this.createAutoCompleteField("cf[10000]", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new SearchAutoCompleteControl.AutoCompleteField[]{firstLabelField, customField}));
    }

    public void testAutoCompleteWithSingleCustomField() {
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        SearchAutoCompleteControl.AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        SearchAutoCompleteControl.AutoCompleteField customField = this.createAutoCompleteField("conflict", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItem((Object)customField));
    }

    public void testAutoCompleteWithTwoConflictingCustomFields() {
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        this.backdoor.customFields().createCustomField("conflict", "some description", CUSTOM_FIELD_TYPE, null);
        SearchAutoCompleteControl.AutoCompleteData autoCompleteData = this.client.getAutoCompleteData();
        SearchAutoCompleteControl.AutoCompleteField customField1 = this.createAutoCompleteField("cf[10000]", "conflict - cf[10000]", false, Sets.newHashSet(), Object.class, false);
        SearchAutoCompleteControl.AutoCompleteField customField2 = this.createAutoCompleteField("cf[10001]", "conflict - cf[10001]", false, Sets.newHashSet(), Object.class, false);
        Assert.assertThat(autoCompleteData.getVisibleFieldNames(), (Matcher)Matchers.hasItems((Object[])new SearchAutoCompleteControl.AutoCompleteField[]{customField1, customField2}));
    }

    private SearchAutoCompleteControl.AutoCompleteField createAutoCompleteField(String name, String displayName, Boolean auto, Set<Operator> operators, Class<?> type, Boolean searchable) {
        String[] operatorsArray = (String[])Iterables.toArray((Iterable)Iterables.transform(operators, (Function)new Function<Operator, String>(){

            public String apply(Operator operator) {
                return operator.getDisplayString();
            }
        }), String.class);
        return new SearchAutoCompleteControl.AutoCompleteField(name, displayName, auto.toString(), searchable.toString(), operatorsArray, new String[]{type.getCanonicalName()});
    }
}

