/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.MoveField;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.ScreenField;
import com.atlassian.jira.testkit.client.restclient.ScreenTab;
import com.atlassian.jira.testkit.client.restclient.ScreensClient;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestScreensResource
extends RestFuncTest {
    private ScreensClient screensClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.screensClient = new ScreensClient((JIRAEnvironmentData)this.getEnvironmentData(), Long.valueOf(1L));
        this.administration.restoreDataWithLicense("TestScreensResource.xml", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.backdoor.screens().addTabToScreen("Default Screen", "Scotts Tab").addTabToScreen("Default Screen", "Scotts Tab 2");
    }

    public void testGettingTabsAsAdmin() throws Exception {
        List allTabs = this.screensClient.getAllTabs();
        TestScreensResource.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("Scotts Tab"), new ScreenTab("Scotts Tab 2")}), (Object)allTabs);
    }

    public void testGettingTabsAsProjectAdmin() throws Exception {
        this.screensClient.loginAs("bob", "bob");
        List allTabs = this.screensClient.getAllTabs("BP");
        TestScreensResource.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("Scotts Tab"), new ScreenTab("Scotts Tab 2")}), (Object)allTabs);
    }

    public void testGettingTabsAsProjectAdminDifferentProject() throws Exception {
        this.screensClient.loginAs("bob", "bob");
        Response allTabsResponse = this.screensClient.getAllTabsResponse("MKY");
        TestScreensResource.assertEquals((int)401, (int)allTabsResponse.statusCode);
    }

    public void testGettingTabsNotAdminOrProjectAdminError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response allTabsResponse = this.screensClient.getAllTabsResponse();
        TestScreensResource.assertEquals((int)401, (int)allTabsResponse.statusCode);
    }

    public void testCreatingTab() throws Exception {
        ScreenTab tab = this.screensClient.createTab("My Tab");
        TestScreensResource.assertEquals((String)tab.name, (String)"My Tab");
        List allTabs = this.screensClient.getAllTabs();
        TestScreensResource.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Field Tab"), new ScreenTab("Scotts Tab"), new ScreenTab("Scotts Tab 2"), new ScreenTab("My Tab")}), (Object)allTabs);
    }

    public void testCreateTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response res = this.screensClient.createTabWithResponse("My Tab");
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.createTabWithResponse("Field Tab");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Tab Field Tab already exists", (String)((String)res.entity.errors.get("name")));
        res = this.screensClient.createTabWithResponse("");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Tab name cannot be empty", (String)((String)res.entity.errors.get("name")));
    }

    public void testRemoveTab() throws Exception {
        this.screensClient.deleteTab(Long.valueOf(10000L));
        this.screensClient.deleteTab(Long.valueOf(10010L));
        List allTabs = this.screensClient.getAllTabs();
        TestScreensResource.assertEquals((Object)Lists.newArrayList((Object[])new ScreenTab[]{new ScreenTab("Scotts Tab 2")}), (Object)allTabs);
    }

    public void testRemoveTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response res = this.screensClient.deleteTabWithResponse(Long.valueOf(10000L));
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
    }

    public void testRenameTab() throws Exception {
        this.screensClient.renameTab(Long.valueOf(10000L), "Renamed Tab");
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), this.screensClient.getAllTabs());
    }

    public void testRenameTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response res = this.screensClient.renameTabWithResponse(Long.valueOf(10000L), "My Tab");
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.renameTabWithResponse(Long.valueOf(10000L), "Scotts Tab");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Tab Scotts Tab already exists", (String)((String)res.entity.errors.get("name")));
        res = this.screensClient.renameTabWithResponse(Long.valueOf(10000L), "");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Tab name cannot be empty", (String)((String)res.entity.errors.get("name")));
    }

    public void testMoveTab() throws Exception {
        this.screensClient.moveTab(Long.valueOf(10000L), Integer.valueOf(2));
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Scotts Tab", "Scotts Tab 2", "Field Tab"}), this.screensClient.getAllTabs());
    }

    public void testMoveTabError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response res = this.screensClient.moveTabWithResponse(Long.valueOf(10000L), Integer.valueOf(1));
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.moveTabWithResponse(Long.valueOf(10000L), Integer.valueOf(-1));
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Incorrect position, tab position much be between 0 and 2", (String)((String)res.entity.errorMessages.get(0)));
        res = this.screensClient.moveTabWithResponse(Long.valueOf(10000L), Integer.valueOf(5));
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Incorrect position, tab position much be between 0 and 2", (String)((String)res.entity.errorMessages.get(0)));
    }

    public void testAddingFields() throws Exception {
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Linked Issues", "Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(10000L), "issuelinks");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Resolution"}), this.screensClient.getAvailableFields());
        this.screensClient.addField(Long.valueOf(10010L), "resolution");
        this.assertFields(new ArrayList<String>(), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels", "Linked Issues"}), fieldsTabFields);
        List scottsTabFields = this.screensClient.getFields(Long.valueOf(10010L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Resolution"}), scottsTabFields);
    }

    public void testAddingFieldError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response res = this.screensClient.addFieldWithResponse(Long.valueOf(10000L), "Linked Issues");
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.addFieldWithResponse(Long.valueOf(10000L), "summary");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"The field with id summary already exists on the screen.", (String)((String)res.entity.errors.get("fieldId")));
        res = this.screensClient.addFieldWithResponse(Long.valueOf(10000L), "fgdfdgfds");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"Invalid Field Id: fgdfdgfds", (String)((String)res.entity.errors.get("fieldId")));
    }

    public void testRemovingFields() throws Exception {
        this.screensClient.removeField(Long.valueOf(10000L), "summary");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Linked Issues", "Resolution", "Summary"}), this.screensClient.getAvailableFields());
        this.screensClient.removeField(Long.valueOf(10000L), "issuetype");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Issue Type", "Linked Issues", "Resolution", "Summary"}), this.screensClient.getAvailableFields());
        List fieldsTabFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels"}), fieldsTabFields);
    }

    public void testRemovingFieldError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        Response res = this.screensClient.removeFieldWithResponse(Long.valueOf(10000L), "Linked Issues");
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
        this.screensClient.loginAs("admin", "admin");
        res = this.screensClient.removeFieldWithResponse(Long.valueOf(10000L), "issuelinks");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"The field with id issuelinks does not exist on this tab.", (String)((String)res.entity.errorMessages.get(0)));
        res = this.screensClient.removeFieldWithResponse(Long.valueOf(10000L), "fgdfdgfds");
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"The field with id fgdfdgfds does not exist on this tab.", (String)((String)res.entity.errorMessages.get(0)));
    }

    public void testMoveField() throws Exception {
        MoveField moveField = new MoveField();
        moveField.after = new URI("/summary");
        this.screensClient.moveField(Long.valueOf(10000L), "assignee", moveField);
        moveField = new MoveField();
        moveField.position = MoveField.Position.Last;
        this.screensClient.moveField(Long.valueOf(10000L), "summary", moveField);
        moveField = new MoveField();
        moveField.position = MoveField.Position.First;
        this.screensClient.moveField(Long.valueOf(10000L), "labels", moveField);
        List fields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Labels", "Assignee", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Summary"}), fields);
    }

    public void testMoveFieldError() throws Exception {
        this.screensClient.loginAs("fred", "fred");
        MoveField moveField = new MoveField();
        moveField.after = new URI("/summary");
        Response res = this.screensClient.moveFieldWithResponse(Long.valueOf(10000L), "assignee", moveField);
        TestScreensResource.assertEquals((int)res.statusCode, (int)401);
        this.screensClient.loginAs("admin", "admin");
        moveField = new MoveField();
        moveField.after = new URI("/reporter");
        res = this.screensClient.moveFieldWithResponse(Long.valueOf(10000L), "issuelinks", moveField);
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"The field with id issuelinks does not exist on this tab.", (String)((String)res.entity.errorMessages.get(0)));
        moveField.after = new URI("/issuelinks");
        res = this.screensClient.moveFieldWithResponse(Long.valueOf(10000L), "reporter", moveField);
        TestScreensResource.assertEquals((int)res.statusCode, (int)400);
        TestScreensResource.assertEquals((String)"The field with id reporter cannot be moved after the issuelinks as it doesn't exist.", (String)((String)res.entity.errorMessages.get(0)));
    }

    public void testCopyAfterTabRenameHasSameTabNames() {
        this.screensClient.renameTab(Long.valueOf(10000L), "Renamed Tab");
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), this.screensClient.getAllTabs());
        Long copyId = this.backdoor.screens().copy("Default Screen", "Default Screen Copy", "-");
        ScreensClient copyClient = new ScreensClient((JIRAEnvironmentData)this.getEnvironmentData(), copyId);
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), copyClient.getAllTabs());
        this.assertTabs(Lists.newArrayList((Object[])new String[]{"Renamed Tab", "Scotts Tab", "Scotts Tab 2"}), this.screensClient.getAllTabs());
    }

    public void testGetAllFieldsAsAdmin() throws Exception {
        List allFields = this.screensClient.getFields(Long.valueOf(10000L));
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels"}), allFields);
    }

    public void testGetAllFieldsAsProjectAdmin() throws Exception {
        this.screensClient.loginAs("bob", "bob");
        List allFields = this.screensClient.getFields(Long.valueOf(10000L), "BP");
        this.assertFields(Lists.newArrayList((Object[])new String[]{"Summary", "Issue Type", "Security Level", "Priority", "Due Date", "Component/s", "Affects Version/s", "Fix Version/s", "Assignee", "Reporter", "Environment", "Description", "Time Tracking", "Attachment", "Labels"}), allFields);
    }

    public void testGetAllFieldsAsProjectAdminDifferentProject() throws Exception {
        this.screensClient.loginAs("bob", "bob");
        Response allFieldsResponse = this.screensClient.getFieldsResponse(Long.valueOf(10000L), "MKY");
        TestScreensResource.assertEquals((int)401, (int)allFieldsResponse.statusCode);
    }

    private void assertTabs(List<String> expecting, List<ScreenTab> actual) {
        TestScreensResource.assertEquals(expecting, this.getTabLabels(actual));
    }

    private List<String> getTabLabels(List<ScreenTab> tabs) {
        ArrayList<String> labels = new ArrayList<String>();
        for (ScreenTab tab : tabs) {
            labels.add(tab.name);
        }
        return labels;
    }

    private void assertFields(List<String> expecting, List<ScreenField> actual) {
        TestScreensResource.assertEquals(expecting, this.getFieldLabels(actual));
    }

    private List<String> getFieldLabels(List<ScreenField> fields) {
        ArrayList<String> labels = new ArrayList<String>();
        for (ScreenField field : fields) {
            labels.add(field.name);
        }
        return labels;
    }
}

