/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.RoleClient;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestRoleResource
extends RestFuncTest {
    private RoleClient roleClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.roleClient = new RoleClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.backdoor.restoreBlankInstance();
    }

    public void testGetAllRoles() {
        List projectRoles = this.roleClient.get();
        Matcher[] expectedProjectRoles = new Matcher[]{this.projectRole(10000L, "Users", "A project role that represents users in a project", "jira-users"), this.projectRole(10001L, "Developers", "A project role that represents developers in a project", "jira-developers"), this.projectRole(10002L, "Administrators", "A project role that represents administrators in a project", "jira-administrators")};
        Matcher values = CoreMatchers.hasItems((Matcher[])expectedProjectRoles);
        MatcherAssert.assertThat((Object)projectRoles, (Matcher)values);
    }

    public void testAnonymousGet() {
        try {
            ((RoleClient)this.roleClient.anonymous()).get();
            TestRoleResource.fail((String)"Anonymous users should not be able to get here");
        }
        catch (UniformInterfaceException e) {
            TestRoleResource.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)e.getResponse().getStatus());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalUserGet() {
        try {
            this.backdoor.usersAndGroups().addUser("user");
            ((RoleClient)this.roleClient.loginAs("user")).get();
            TestRoleResource.fail((String)"Login users with no admin credentials should not be able to get here");
        }
        catch (UniformInterfaceException e) {
            TestRoleResource.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)e.getResponse().getStatus());
        }
        finally {
            this.backdoor.usersAndGroups().deleteUser("user");
        }
    }

    public void testGetSelfForEachRole() throws IOException, SAXException, JSONException {
        List projectRoles = this.roleClient.get();
        for (ProjectRole projectRole : projectRoles) {
            ProjectRole projectRole1 = this.roleClient.get(projectRole.id.toString());
            TestRoleResource.assertNotNull((Object)projectRole1);
            TestRoleResource.assertEquals((String)projectRole.description, (String)projectRole1.description);
            TestRoleResource.assertEquals((String)projectRole.name, (String)projectRole1.name);
            TestRoleResource.assertEquals((String)projectRole.self, (String)projectRole1.self);
            TestRoleResource.assertEquals((Object)projectRole.id, (Object)projectRole1.id);
            String url = projectRole.self.replace(this.getBaseUrl(), "");
            WebResponse response = this.GET(url, MapBuilder.emptyMap());
            MatcherAssert.assertThat((Object)response.getResponseCode(), (Matcher)IsEqual.equalTo((Object)200));
            JSONObject jsonResponse = new JSONObject(response.getText());
            TestRoleResource.assertEquals((Object)projectRole.description, (Object)jsonResponse.get("description"));
            TestRoleResource.assertEquals((Object)projectRole.name, (Object)jsonResponse.get("name"));
            TestRoleResource.assertEquals((Object)projectRole.self, (Object)jsonResponse.get("self"));
            TestRoleResource.assertEquals((long)projectRole.id, (long)jsonResponse.getLong("id"));
        }
    }

    public void testGetNonExistingRole() throws IOException, SAXException {
        WebResponse response = this.GET(this.getBaseUrl() + "/role/12312321312", MapBuilder.emptyMap());
        TestRoleResource.assertEquals((int)HttpStatus.NOT_FOUND.code, (int)response.getResponseCode());
    }

    private BaseMatcher<ProjectRole> projectRole(final @Nonnull Long id, final @Nonnull String name, final @Nonnull String description, final @Nonnull String actorName) {
        return new BaseMatcher<ProjectRole>(){

            public boolean matches(Object o) {
                if (!(o instanceof ProjectRole)) {
                    return false;
                }
                ProjectRole changedValue = (ProjectRole)o;
                boolean result = name.equals(changedValue.name) && id.equals(changedValue.id) && description.equals(changedValue.description) && this.containsActor(changedValue.actors, actorName);
                return result;
            }

            public void describeTo(Description descr) {
                descr.appendText(new ProjectRole().name(name).id(id).description(description).toString());
            }

            private boolean containsActor(List<ProjectRole.Actor> actors, String actor) {
                for (ProjectRole.Actor roleActor : actors) {
                    if (!actor.equalsIgnoreCase(roleActor.name)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

