/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Resolution;
import com.atlassian.jira.testkit.client.restclient.ResolutionClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestResolutionResource
extends RestFuncTest {
    private ResolutionClient resolutionClient;

    public void testAllResolutions() throws Exception {
        List resolutions = this.resolutionClient.get();
        this.assertresolutionsContain(resolutions, "1");
        this.assertresolutionsContain(resolutions, "2");
        this.assertresolutionsContain(resolutions, "3");
        this.assertresolutionsContain(resolutions, "4");
        this.assertresolutionsContain(resolutions, "5");
    }

    private void assertresolutionsContain(List<Resolution> resolutions, String id) {
        for (Resolution resolution : resolutions) {
            if (!resolution.id.equals(id)) continue;
            return;
        }
        TestResolutionResource.fail((String)("Resolution " + id + " not in list"));
    }

    public void testViewResolution() throws Exception {
        Resolution resolution = this.resolutionClient.get("2");
        TestResolutionResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/resolution/2"), (String)resolution.self);
        TestResolutionResource.assertEquals((String)"The problem described is an issue which will never be fixed.", (String)resolution.description);
        TestResolutionResource.assertEquals((String)"2", (String)resolution.id);
        TestResolutionResource.assertEquals((String)"Won't Fix", (String)resolution.name);
    }

    public void testViewResolutionNotFound() throws Exception {
        Response resp999 = this.resolutionClient.getResponse("999");
        TestResolutionResource.assertEquals((int)404, (int)resp999.statusCode);
        TestResolutionResource.assertEquals((int)1, (int)resp999.entity.errorMessages.size());
        TestResolutionResource.assertTrue((boolean)resp999.entity.errorMessages.contains("The resolution with id '999' does not exist"));
        Response respBoom = this.resolutionClient.getResponse("boom");
        TestResolutionResource.assertEquals((int)404, (int)respBoom.statusCode);
        TestResolutionResource.assertEquals((int)1, (int)respBoom.entity.errorMessages.size());
        TestResolutionResource.assertTrue((boolean)respBoom.entity.errorMessages.contains("The resolution with id 'boom' does not exist"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.resolutionClient = new ResolutionClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreBlankInstance();
    }
}

