/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateRequest;
import com.atlassian.jira.rest.api.issue.RemoteIssueLinkCreateOrUpdateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.RemoteIssueLink;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ObjectUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestRemoteIssueLinkResource
extends RestFuncTest {
    private static final String ISSUE_KEY = "HSP-1";
    private static final String ANOTHER_ISSUE_KEY = "HSP-2";
    private static final String THIRD_ISSUE_KEY = "HSP-3";
    private static final String ISSUE_THAT_DOES_NOT_EXIST = "HSP-999";
    private static final String LINK_ID_THAT_DOES_NOT_EXIST = "-1";
    private static final String BLANK = "    ";
    private static final String INVALID_URI = "this is not a valid URI";
    private static int BAD_REQUEST = Response.Status.BAD_REQUEST.getStatusCode();
    private static int CREATED = Response.Status.CREATED.getStatusCode();
    private static int FORBIDDEN = Response.Status.FORBIDDEN.getStatusCode();
    private static int NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    private static int NO_CONTENT = Response.Status.NO_CONTENT.getStatusCode();
    private IssueClient issueClient;

    public void testCreate() {
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
    }

    public void testCreateReturnsLocationHeader() {
        ClientResponse response = this.issueClient.createOrUpdateRemoteIssueLinkAndGetClientResponse(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
        TestRemoteIssueLinkResource.assertEquals((int)CREATED, (int)response.getStatus());
        RemoteIssueLinkCreateOrUpdateResponse entity = (RemoteIssueLinkCreateOrUpdateResponse)response.getEntity(RemoteIssueLinkCreateOrUpdateResponse.class);
        URI expectedLocation = URI.create(this.getRestApiUrl("issue", ISSUE_KEY, "remotelink", entity.id().toString()));
        TestRemoteIssueLinkResource.assertEquals((Object)expectedLocation, (Object)response.getLocation());
    }

    public void testCreateAndThenUpdate() {
        Long createId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id();
        Long updateId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id();
        TestRemoteIssueLinkResource.assertEquals((Object)createId, (Object)updateId);
    }

    public void testMultipleCreatesWithoutGlobalId() {
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(null);
        Long id1 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request).id();
        Long id2 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request).id();
        TestRemoteIssueLinkResource.assertFalse((boolean)id1.equals(id2));
    }

    public void testCreateWithoutNonRequiredFields() {
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(null).summary(null).iconUrl(null).iconTitle(null).relationship(null).resolved(null).statusIconUrl(null).statusIconTitle(null).statusIconLink(null).applicationType(null).applicationName(null);
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, request);
    }

    public void testCreateWithBlankNonRequiredFields() {
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(BLANK).summary(BLANK).iconUrl("").iconTitle(BLANK).relationship(BLANK).statusIconUrl("").statusIconTitle(BLANK).statusIconLink("").applicationType(BLANK).applicationName(BLANK);
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, request);
    }

    public void testCreateWithoutRequiredFields() {
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().title(null), BAD_REQUEST, "title");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().url(null), BAD_REQUEST, "url");
    }

    public void testCreateWithBlankRequiredFields() {
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().title(BLANK), BAD_REQUEST, "title");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().url(BLANK), BAD_REQUEST, "url");
    }

    public void testCreateWithInvalidIssue() {
        this.createOrUpdateExpectingFailure(ISSUE_THAT_DOES_NOT_EXIST, this.populatedCreateOrUpdateRequest(), NOT_FOUND, new String[0]);
    }

    public void testCreateWithInvalidUrls() {
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().url(INVALID_URI), BAD_REQUEST, "url");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().iconUrl(INVALID_URI), BAD_REQUEST, "iconUrl");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().statusIconUrl(INVALID_URI), BAD_REQUEST, "statusIconUrl");
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest().statusIconLink(INVALID_URI), BAD_REQUEST, "statusIconLink");
    }

    public void testCreateWhenLinkingDisabled() {
        this.administration.issueLinking().disable();
        this.createOrUpdateExpectingFailure(ISSUE_KEY, this.populatedCreateOrUpdateRequest(), FORBIDDEN, new String[0]);
    }

    public void testUpdate() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingSuccess(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest());
    }

    public void testUpdateWithoutNonRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(null).summary(null).iconUrl(null).iconTitle(null).relationship(null).resolved(null).statusIconUrl(null).statusIconTitle(null).statusIconLink(null).applicationType(null).applicationName(null);
        this.updateExpectingSuccess(ISSUE_KEY, linkId, request);
    }

    public void testUpdateWithBlankNonRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        RemoteIssueLinkCreateOrUpdateRequest request = this.populatedCreateOrUpdateRequest().globalId(BLANK).summary(BLANK).iconUrl("").iconTitle(BLANK).relationship(BLANK).statusIconUrl("").statusIconTitle(BLANK).statusIconLink("").applicationType(BLANK).applicationName(BLANK);
        this.updateExpectingSuccess(ISSUE_KEY, linkId, request);
    }

    public void testUpdateWithoutRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().title(null), BAD_REQUEST, "title");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().url(null), BAD_REQUEST, "url");
    }

    public void testUpdateWithBlankRequiredFields() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().title(BLANK), BAD_REQUEST, "title");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().url(BLANK), BAD_REQUEST, "url");
    }

    public void testUpdateWithInvalidIssue() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_THAT_DOES_NOT_EXIST, linkId, this.populatedCreateOrUpdateRequest(), NOT_FOUND, new String[0]);
    }

    public void testUpdateWithInvalidLinkId() {
        this.updateExpectingFailure(ISSUE_KEY, LINK_ID_THAT_DOES_NOT_EXIST, this.populatedCreateOrUpdateRequest(), NOT_FOUND, new String[0]);
    }

    public void testUpdateWithInvalidUrls() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().url(INVALID_URI), BAD_REQUEST, "url");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().iconUrl(INVALID_URI), BAD_REQUEST, "iconUrl");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().statusIconUrl(INVALID_URI), BAD_REQUEST, "statusIconUrl");
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest().statusIconLink(INVALID_URI), BAD_REQUEST, "statusIconLink");
    }

    public void testUpdateWhenLinkingDisabled() {
        String linkId = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.administration.issueLinking().disable();
        this.updateExpectingFailure(ISSUE_KEY, linkId, this.populatedCreateOrUpdateRequest(), FORBIDDEN, new String[0]);
    }

    public void testDelete() {
        String id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.deleteExpectingSuccess(ISSUE_KEY, id);
    }

    public void testDeleteIdDoesNotExist() {
        this.deleteExpectingFailure(ISSUE_KEY, LINK_ID_THAT_DOES_NOT_EXIST, NOT_FOUND, new String[0]);
    }

    public void testDeleteIdNotNumeric() {
        this.deleteExpectingFailure(ISSUE_KEY, "99a", BAD_REQUEST, new String[0]);
    }

    public void testDeleteWhenLinkingDisabled() {
        String id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.administration.issueLinking().disable();
        this.deleteExpectingFailure(ISSUE_KEY, id, FORBIDDEN, new String[0]);
    }

    public void testDeleteByGlobalId() {
        String globalId = UUID.randomUUID().toString();
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId(globalId)).id().toString();
        this.deleteByGlobalIdExpectingSuccess(ISSUE_KEY, globalId);
    }

    public void testDeleteByGlobalIdDeletesMany() {
        this.deleteByGlobalIdExpectingSuccess(THIRD_ISSUE_KEY, "example.org");
    }

    public void testDeleteByGlobalIdWhenGlobalIdDoesNotExist() {
        String globalId = UUID.randomUUID().toString();
        this.deleteByGlobalIdExpectingFailure(ISSUE_KEY, globalId, NOT_FOUND, new String[0]);
    }

    public void testDeleteByGlobalIdWhenLinkingDisabled() {
        String globalId = UUID.randomUUID().toString();
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId(globalId));
        this.administration.issueLinking().disable();
        this.deleteByGlobalIdExpectingFailure(ISSUE_KEY, globalId, FORBIDDEN, new String[0]);
    }

    public void testGetWhenDoesNotExist() {
        Response response = this.issueClient.getRemoteIssueLinkResponse(ISSUE_KEY, LINK_ID_THAT_DOES_NOT_EXIST);
        this.assertFailure(response, NOT_FOUND, new String[0]);
    }

    public void testGetWhenLinkingDisabled() {
        String id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest()).id().toString();
        this.administration.issueLinking().disable();
        Response response = this.issueClient.getRemoteIssueLinkResponse(ISSUE_KEY, id);
        this.assertFailure(response, FORBIDDEN, new String[0]);
    }

    public void testGetForIssue() {
        RemoteIssueLinkCreateOrUpdateRequest request1 = this.populatedCreateOrUpdateRequest();
        RemoteIssueLinkCreateOrUpdateRequest request2 = this.populatedCreateOrUpdateRequest("6789");
        RemoteIssueLinkCreateOrUpdateRequest request3 = this.populatedCreateOrUpdateRequest("999");
        RemoteIssueLinkCreateOrUpdateResponse response1 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request1);
        RemoteIssueLinkCreateOrUpdateResponse response2 = this.createOrUpdateExpectingSuccess(ISSUE_KEY, request2);
        this.createOrUpdateExpectingSuccess(ANOTHER_ISSUE_KEY, request3);
        List linksAfter = this.issueClient.getRemoteIssueLinks(ISSUE_KEY);
        TestRemoteIssueLinkResource.assertEquals((int)2, (int)linksAfter.size());
        if (response1.id().equals(((RemoteIssueLink)linksAfter.get((int)0)).id)) {
            this.assertRequestEqualsLink(request1, (RemoteIssueLink)linksAfter.get(0));
        } else if (response1.id().equals(((RemoteIssueLink)linksAfter.get((int)1)).id)) {
            this.assertRequestEqualsLink(request1, (RemoteIssueLink)linksAfter.get(1));
        } else {
            TestRemoteIssueLinkResource.fail((String)"The remote issue link was not found in the links for issue query");
        }
        if (response2.id().equals(((RemoteIssueLink)linksAfter.get((int)0)).id)) {
            this.assertRequestEqualsLink(request2, (RemoteIssueLink)linksAfter.get(0));
        } else if (response2.id().equals(((RemoteIssueLink)linksAfter.get((int)1)).id)) {
            this.assertRequestEqualsLink(request2, (RemoteIssueLink)linksAfter.get(1));
        } else {
            TestRemoteIssueLinkResource.fail((String)"The remote issue link was not found in the links for issue query");
        }
    }

    public void testGetForIssueWhenLinkingDisabled() {
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
        this.administration.issueLinking().disable();
        Response response = this.issueClient.getRemoteIssueLinksResponse(ISSUE_KEY);
        this.assertFailure(response, FORBIDDEN, new String[0]);
    }

    public void testGetByGlobalId() {
        String globalId = "url=http://www.blah.com&id=99999";
        Long id = this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId("url=http://www.blah.com&id=99999")).id();
        this.createOrUpdateExpectingSuccess(ISSUE_KEY, this.populatedCreateOrUpdateRequest());
        this.createOrUpdateExpectingSuccess(ANOTHER_ISSUE_KEY, this.populatedCreateOrUpdateRequest().globalId("url=http://www.blah.com&id=99999"));
        RemoteIssueLink found = this.issueClient.getRemoteIssueLinkByGlobalId(ISSUE_KEY, "url=http://www.blah.com&id=99999");
        TestRemoteIssueLinkResource.assertEquals((Object)id, (Object)found.id);
        TestRemoteIssueLinkResource.assertEquals((String)"url=http://www.blah.com&id=99999", (String)found.globalId);
    }

    private RemoteIssueLinkCreateOrUpdateResponse createOrUpdateExpectingSuccess(String issueKey, RemoteIssueLinkCreateOrUpdateRequest request) {
        RemoteIssueLinkCreateOrUpdateResponse response = this.issueClient.createOrUpdateRemoteIssueLink(issueKey, request);
        TestRemoteIssueLinkResource.assertNotNull((Object)response.id());
        TestRemoteIssueLinkResource.assertEquals((String)this.getRestApiUrl("issue", issueKey, "remotelink", response.id().toString()), (String)response.self());
        this.assertExists(issueKey, response.id(), request);
        return response;
    }

    private Response createOrUpdateExpectingFailure(String issueKey, RemoteIssueLinkCreateOrUpdateRequest request, int statusCode, String ... erroneousFields) {
        Response response = this.issueClient.createOrUpdateRemoteIssueLinkAndGetResponse(issueKey, request);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private Response updateExpectingSuccess(String issueKey, String linkId, RemoteIssueLinkCreateOrUpdateRequest request) {
        Response response = this.issueClient.updateRemoteIssueLink(issueKey, linkId, request);
        TestRemoteIssueLinkResource.assertEquals((int)NO_CONTENT, (int)response.statusCode);
        this.assertExists(issueKey, new Long(linkId), request);
        return response;
    }

    private Response updateExpectingFailure(String issueKey, String linkId, RemoteIssueLinkCreateOrUpdateRequest request, int statusCode, String ... erroneousFields) {
        Response response = this.issueClient.updateRemoteIssueLink(issueKey, linkId, request);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private Response deleteExpectingSuccess(String issueKey, String remoteIssueLinkId) {
        Response response = this.issueClient.deleteRemoteIssueLink(issueKey, remoteIssueLinkId);
        this.assertNotExists(issueKey, remoteIssueLinkId);
        return response;
    }

    private Response deleteExpectingFailure(String issueKey, String remoteIssueLinkId, int statusCode, String ... erroneousFields) {
        Response response = this.issueClient.deleteRemoteIssueLink(issueKey, remoteIssueLinkId);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private Response deleteByGlobalIdExpectingSuccess(String issueKey, String globalId) {
        Response response = this.issueClient.deleteRemoteIssueLinkByGlobalId(issueKey, globalId);
        List remoteIssueLinks = this.issueClient.getRemoteIssueLinks(issueKey);
        Assert.assertThat((Object)remoteIssueLinks, (Matcher)Matchers.not((Matcher)Matchers.hasItem(TestRemoteIssueLinkResource.withGlobalId(globalId))));
        return response;
    }

    private Response deleteByGlobalIdExpectingFailure(String issueKey, String globalId, int statusCode, String ... erroneousFields) {
        Response response = this.issueClient.deleteRemoteIssueLinkByGlobalId(issueKey, globalId);
        this.assertFailure(response, statusCode, erroneousFields);
        return response;
    }

    private void assertExists(String issueKey, Long remoteIssueLinkId, RemoteIssueLinkCreateOrUpdateRequest request) {
        RemoteIssueLink found = this.issueClient.getRemoteIssueLink(issueKey, remoteIssueLinkId.toString());
        TestRemoteIssueLinkResource.assertEquals((Object)remoteIssueLinkId, (Object)found.id);
        this.assertRequestEqualsLink(request, found);
    }

    private void assertNotExists(String issueKey, String remoteIssueLinkId) {
        Response response = this.issueClient.getRemoteIssueLinkResponse(issueKey, remoteIssueLinkId);
        TestRemoteIssueLinkResource.assertEquals((int)NOT_FOUND, (int)response.statusCode);
    }

    private void assertRequestEqualsLink(RemoteIssueLinkCreateOrUpdateRequest request, RemoteIssueLink remoteIssueLink) {
        TestRemoteIssueLinkResource.assertEquals((String)request.globalId(), (String)remoteIssueLink.globalId);
        TestRemoteIssueLinkResource.assertEquals((String)request.title(), (String)remoteIssueLink.object.title);
        TestRemoteIssueLinkResource.assertEquals((String)request.summary(), (String)remoteIssueLink.object.summary);
        TestRemoteIssueLinkResource.assertEquals((String)request.url(), (String)remoteIssueLink.object.url);
        TestRemoteIssueLinkResource.assertEquals((String)request.iconUrl(), (String)remoteIssueLink.object.icon.url16x16);
        TestRemoteIssueLinkResource.assertEquals((String)request.iconTitle(), (String)remoteIssueLink.object.icon.title);
        TestRemoteIssueLinkResource.assertEquals((String)request.relationship(), (String)remoteIssueLink.relationship);
        TestRemoteIssueLinkResource.assertEquals((Object)request.resolved(), (Object)remoteIssueLink.object.status.resolved);
        TestRemoteIssueLinkResource.assertEquals((String)request.statusIconUrl(), (String)remoteIssueLink.object.status.icon.url16x16);
        TestRemoteIssueLinkResource.assertEquals((String)request.statusIconTitle(), (String)remoteIssueLink.object.status.icon.title);
        TestRemoteIssueLinkResource.assertEquals((String)request.statusIconLink(), (String)remoteIssueLink.object.status.icon.link);
        TestRemoteIssueLinkResource.assertEquals((String)request.applicationType(), (String)remoteIssueLink.application.type);
        TestRemoteIssueLinkResource.assertEquals((String)request.applicationName(), (String)remoteIssueLink.application.name);
    }

    private void assertFailure(Response response, int statusCode, String ... erroneousFields) {
        TestRemoteIssueLinkResource.assertEquals((int)statusCode, (int)response.statusCode);
        for (String erroneousField : erroneousFields) {
            TestRemoteIssueLinkResource.assertTrue((boolean)response.entity.errors.containsKey(erroneousField));
        }
    }

    private RemoteIssueLinkCreateOrUpdateRequest populatedCreateOrUpdateRequest() {
        return this.populatedCreateOrUpdateRequest("12345");
    }

    private RemoteIssueLinkCreateOrUpdateRequest populatedCreateOrUpdateRequest(String remoteId) {
        return new RemoteIssueLinkCreateOrUpdateRequest().globalId("url=http://www.remoteapplication.com&id=" + remoteId).title("Ticket #" + remoteId).summary("Summary of the ticket goes here").url("http://www.remoteapplication.com/ticket/" + remoteId).iconUrl("http://www.remoteapplication.com/images/ticket.gif").iconTitle("Ticket").relationship("relates to").resolved(Boolean.valueOf(false)).statusIconUrl("http://www.remoteapplication.com/images/status.gif").statusIconTitle("Status").statusIconLink("http://www.remoteapplication.com/blah").applicationType("com.mycompany.myhelpdesksystem").applicationName("My Company IT Helpdesk");
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestRemoteIssueLinkResource.xml");
    }

    static Matcher<RemoteIssueLink> withGlobalId(String globalId) {
        return new RemoteIssueLinkGlobalIdIsEqual(globalId);
    }

    private static class RemoteIssueLinkGlobalIdIsEqual
    extends BaseMatcher<RemoteIssueLink> {
        private final String globalId;

        public RemoteIssueLinkGlobalIdIsEqual(String globalId) {
            this.globalId = globalId;
        }

        public boolean matches(Object o) {
            RemoteIssueLink link = (RemoteIssueLink)o;
            return ObjectUtils.equals((Object)link.globalId, (Object)this.globalId);
        }

        public void describeTo(Description desc) {
            desc.appendText("{globalId is ").appendValue((Object)this.globalId).appendText("}");
        }
    }
}

