/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.backdoor.IndexingControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.ReindexStatus;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.rest.v2.index.ReindexRequestBean;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.indexing.ReindexRequestClient;
import com.google.common.primitives.Longs;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestReindexRequestResource
extends RestFuncTest {
    private static final Logger log = LoggerFactory.getLogger(TestReindexRequestResource.class);
    private ReindexRequestClient reindexRequestClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.reindexRequestClient = new ReindexRequestClient(this.getEnvironmentData());
        this.clearReindexRequests();
    }

    private void clearReindexRequests() {
        this.backdoor.indexing().clearPendingReindexRequests();
    }

    public void testReadReindexRequestStatus() {
        ReindexRequestType type = ReindexRequestType.IMMEDIATE;
        String query = "";
        long requestId = this.makeReindexRequest(type, query, new SharedEntityType[0]);
        ReindexRequestBean request = this.reindexRequestClient.getReindexRequest(requestId);
        TestReindexRequestResource.assertEquals((String)"Wrong ID.", (long)requestId, (long)request.getId());
        TestReindexRequestResource.assertEquals((String)"Wrong type.", (Object)ReindexRequestType.IMMEDIATE, (Object)request.getType());
        TestReindexRequestResource.assertEquals((String)"Wrong status.", (Object)ReindexStatus.PENDING, (Object)request.getStatus());
    }

    public void testReadReindexRequestStatusNotFound() {
        try {
            this.reindexRequestClient.getReindexRequest(Integer.MAX_VALUE);
            TestReindexRequestResource.fail((String)"Should get not found error.");
        }
        catch (UniformInterfaceException e) {
            TestReindexRequestResource.assertEquals((String)"Wrong response status.", (int)HttpStatus.NOT_FOUND.code, (int)e.getResponse().getStatus());
        }
    }

    public void testPerformReindex() throws InterruptedException {
        ReindexRequestType type = ReindexRequestType.IMMEDIATE;
        String query = "";
        long requestId = this.makeReindexRequest(type, query, new SharedEntityType[0]);
        List requests = Longs.asList((long[])this.reindexRequestClient.performReindex());
        Assert.assertThat((Object)requests, (Matcher)Matchers.hasItem((Object)requestId));
        this.assertReindexRequestStatusAfterCompletion(requestId, ReindexStatus.COMPLETE);
    }

    public void testPerformReindexWithSharedEntities() throws InterruptedException {
        ReindexRequestType type = ReindexRequestType.DELAYED;
        String query = "";
        long requestId = this.makeReindexRequest(type, query, SharedEntityType.SEARCH_REQUEST);
        List requests = Longs.asList((long[])this.reindexRequestClient.performReindex());
        Assert.assertThat((Object)requests, (Matcher)Matchers.hasItem((Object)requestId));
        this.assertReindexRequestStatusAfterCompletion(requestId, ReindexStatus.COMPLETE);
    }

    public void testReindexJustAComment() {
        IssueIndexingParams indexingParams = IssueIndexingParams.builder().withComments().withoutIssues().build();
        IndexingControl.IndexingProgress progress = this.backdoor.indexing().startInBackground(indexingParams);
        progress.waitForCompletion();
        String taskId = progress.getTaskId();
        TestReindexRequestResource.assertEquals((String)"Reindex was not successful.", (Object)Boolean.TRUE, (Object)this.backdoor.indexing().getIndexingTaskProgress(taskId));
    }

    private long makeReindexRequest(ReindexRequestType type, String query, SharedEntityType ... sharedEntityTypes) {
        return this.backdoor.indexing().makeReindexRequest(type, query, sharedEntityTypes);
    }

    private void assertReindexRequestStatusAfterCompletion(long requestId, ReindexStatus expectedStatus) {
        int numChecks = 0;
        try {
            ReindexRequestBean request;
            do {
                request = this.reindexRequestClient.getReindexRequest(requestId);
                TestReindexRequestResource.assertNotNull((String)"Request not found.", (Object)request);
                log.info("Current request status: " + request.getStatus());
                Thread.sleep(500L);
            } while (request.getStatus() != expectedStatus && ++numChecks < 20);
            TestReindexRequestResource.assertEquals((String)"Reindex did not complete with expected status.", (Object)expectedStatus, (Object)request.getStatus());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

