/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.indexing.ReindexIssueClient;
import java.util.Collections;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestReindexIssue
extends RestFuncTest {
    private ReindexIssueClient reindexIssueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.reindexIssueClient = new ReindexIssueClient(this.environmentData);
        this.administration.restoreData("TestEditIssue.xml");
    }

    public void testReindexIssueByKey() {
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestReindexIssue.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        Response<?> response = this.reindexIssueClient.reindexIssue("MKY-1");
        TestReindexIssue.assertEquals((String)"Wrong status code.", (int)200, (int)response.statusCode);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestReindexIssue.assertEquals((String)"Issue not found.", (int)1, (int)result.issues.size());
    }

    public void testReindexIssueById() {
        this.backdoor.indexing().deindex("MKY-1");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestReindexIssue.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        Response<?> response = this.reindexIssueClient.reindexIssue("10001");
        TestReindexIssue.assertEquals((String)"Wrong status code.", (int)200, (int)response.statusCode);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestReindexIssue.assertEquals((String)"Issue not found.", (int)1, (int)result.issues.size());
    }

    public void testReindexMultipleIssues() {
        this.backdoor.indexing().deindex("MKY-1");
        this.backdoor.indexing().deindex("MKY-2");
        SearchResult result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestReindexIssue.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-2'"));
        TestReindexIssue.assertEquals((String)"Should not find issue.", Collections.emptyList(), (Object)result.issues);
        Response<?> response = this.reindexIssueClient.reindexIssue("MKY-1", "MKY-2");
        TestReindexIssue.assertEquals((String)"Wrong status code.", (int)200, (int)response.statusCode);
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-1'"));
        TestReindexIssue.assertEquals((String)"Issue not found.", (int)1, (int)result.issues.size());
        result = this.backdoor.search().getSearch(new SearchRequest().jql("issuekey = 'MKY-2'"));
        TestReindexIssue.assertEquals((String)"Issue not found.", (int)1, (int)result.issues.size());
    }

    public void testReindexIssueNotFound() {
        Response<?> response = this.reindexIssueClient.reindexIssue("GALAH");
        TestReindexIssue.assertEquals((String)"Wrong status code.", (int)404, (int)response.statusCode);
    }
}

