/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.GenericRestClient;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.api.client.GenericType;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectResourcePaginatedVersions
extends RestFuncTest {
    private static final GenericType<PageBean<Version>> PAGE_TYPE = new GenericType<PageBean<Version>>(){};
    public static final String ATL_PROJECT_KEY = "ATL";
    private Version version5;
    private Version version4;
    private Version version3;
    private Version version2;
    private Version version1;
    private List<Version> atlVersions;
    private ProjectClient projectClient;
    private GenericRestClient genericClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.genericClient = new GenericRestClient();
        this.administration.restoreData("TestProjectResource.xml");
        this.version1 = new Version().self(this.createVersionUri(10010L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("One").releaseDate("01/Mar/11").overdue(Boolean.valueOf(true)).id(Long.valueOf(10010L)).projectId(Long.valueOf(10010L));
        this.version2 = new Version().self(this.createVersionUri(10011L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("Two").description("Description").id(Long.valueOf(10011L)).projectId(Long.valueOf(10010L));
        this.version3 = new Version().self(this.createVersionUri(10012L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(true)).name("Three").releaseDate("09/Mar/11").id(Long.valueOf(10012L)).projectId(Long.valueOf(10010L));
        this.version4 = new Version().self(this.createVersionUri(10013L)).archived(Boolean.valueOf(true)).released(Boolean.valueOf(true)).name("Four").description("Four").releaseDate("09/Mar/11").id(Long.valueOf(10013L)).projectId(Long.valueOf(10010L));
        this.version5 = new Version().self(this.createVersionUri(10014L)).archived(Boolean.valueOf(true)).released(Boolean.valueOf(false)).name("Five").description("Five").id(Long.valueOf(10014L)).projectId(Long.valueOf(10010L));
        this.atlVersions = ImmutableList.of((Object)this.version5, (Object)this.version4, (Object)this.version3, (Object)this.version2, (Object)this.version1);
    }

    public void testGettingPagedVersionsWithoutAnyParameters() {
        PageBean versionsPaged = this.projectClient.getVersionsPaged(ATL_PROJECT_KEY, null, null, null);
        Assert.assertThat((Object)versionsPaged.getValues(), (Matcher)Matchers.equalTo(this.atlVersions));
    }

    public void testWhenOrderingIsNotSpecifiedVersionsAreReturnedInAscendingSequenceOrder() {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering(null, this.atlVersions);
    }

    public void testVersionsCanBeOrderedBySequenceAscendingExplicitly() {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("sequence", this.atlVersions);
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("+sequence", this.atlVersions);
    }

    public void testVersionsCanBeOrderedBySequenceDescending() {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("-sequence", this.version1, this.version2, this.version3, this.version4, this.version5);
    }

    public void testVersionsCanBeOrderedByNameDescending() {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("-name", this.version2, this.version3, this.version1, this.version4, this.version5);
    }

    public void testVersionsCanBeOrderedByNameAscending() {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("name", this.version5, this.version4, this.version1, this.version3, this.version2);
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("+name", this.version5, this.version4, this.version1, this.version3, this.version2);
    }

    public void testNullValuesInOrderingAreReturnedLastAndOrderedBySequence() {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering("releaseDate", this.version1, this.version4, this.version3, this.version5, this.version2);
    }

    public void testEmptyPageIsReturnedWhenPageRequestIsOutOfRange() {
        PageBean versions = this.projectClient.getVersionsPaged(ATL_PROJECT_KEY, Long.valueOf(10L), Integer.valueOf(4), "name");
        Assert.assertThat((Object)versions.getIsLast(), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        Assert.assertThat((Object)versions.getValues(), (Matcher)Matchers.hasSize((int)0));
    }

    private void assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering(String ordering, Version ... expectedOrder) {
        this.assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering(ordering, Arrays.asList(expectedOrder));
    }

    private void assertPagedVersionsAreReturnedInExpectedOrderForSpecifiedOrdering(String ordering, List<Version> expectedOrder) {
        PageBean firstPage = this.projectClient.getVersionsPaged(ATL_PROJECT_KEY, Long.valueOf(0L), Integer.valueOf(3), ordering);
        PageBean secondPage = this.projectClient.getVersionsPaged(ATL_PROJECT_KEY, Long.valueOf(3L), Integer.valueOf(3), ordering);
        Assert.assertThat((Object)firstPage.getValues(), (Matcher)Matchers.contains((Object[])expectedOrder.subList(0, 3).toArray(new Version[3])));
        Assert.assertThat((Object)secondPage.getValues(), (Matcher)Matchers.contains((Object[])expectedOrder.subList(3, 5).toArray(new Version[2])));
        Assert.assertThat((Object)firstPage.getIsLast(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)secondPage.getIsLast(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)secondPage.getMaxResults(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.genericClient.getNextPage((PageBean)firstPage, TestProjectResourcePaginatedVersions.PAGE_TYPE).body, (Matcher)Matchers.equalTo((Object)secondPage));
    }

    private URI createVersionUri(long id) {
        return this.getRestApiUri("version", String.valueOf(id));
    }
}

