/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectResource
extends RestFuncTest {
    private static final String EXPECTED_EXPAND = "description,lead,url,projectKeys";
    private static final Long DEFAULT_AVATAR_ID = 10011L;
    private ProjectClient projectClient;

    public void testViewProject() throws Exception {
        this.checkProject(this.createProjectMky(), true, false);
        this.checkProject(this.createProjectAtl(), true, true);
        this.checkProject(this.createProjectHid(), false, false);
        this.checkProject(this.createProjectFred(), true, false);
        this.checkProject(this.createProjectDodo(), false, false);
    }

    public void testViewProjectNoPermissionToViewByKey() throws Exception {
        this.assertCantSeeProject("fred", "HID");
        this.assertCantSeeProject(null, "MKY");
        this.assertCantSeeProject(null, "HID");
        this.assertCantSeeProject(null, "FRED");
    }

    public void testViewProjectNoPermissionToViewById() throws Exception {
        this.assertCantSeeProject("fred", 10110L);
        this.assertCantSeeProject(null, 10001L);
        this.assertCantSeeProject(null, 10110L);
        this.assertCantSeeProject(null, 10111L);
    }

    public void testViewProjects() throws Exception {
        Project projectAtl = this.makeSimple(this.createProjectAtl());
        Project projectFred = this.makeSimple(this.createProjectFred());
        Project projectHsp = this.makeSimple(this.createProjectHsp());
        Project projectHid = this.makeSimple(this.createProjectHid());
        Project projectMky = this.makeSimple(this.createProjectMky());
        Project projectDodo = this.makeSimple(this.createProjectDodo());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectDodo, projectFred, projectHid, projectHsp, projectMky), (Object)this.projectClient.getProjects());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectFred, projectHsp, projectMky), (Object)((ProjectClient)this.projectClient.loginAs("fred")).getProjects());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl), (Object)((ProjectClient)this.projectClient.anonymous()).getProjects());
    }

    public void testViewProjectByKeyDoesNotExist() throws Exception {
        this.checkProjectNotFound("key", "XXX");
    }

    public void testViewProjectByIdDoesNotExist() throws Exception {
        this.checkProjectNotFound("id", "20000");
    }

    private void checkProjectNotFound(String field, String projectIdOrKey) {
        Response respXXX = this.projectClient.getResponse(projectIdOrKey);
        TestProjectResource.assertEquals((int)404, (int)respXXX.statusCode);
        TestProjectResource.assertEquals((int)1, (int)respXXX.entity.errorMessages.size());
        Assert.assertThat((Object)respXXX.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("No project could be found with %s '%s'.", field, projectIdOrKey)}));
    }

    public void testViewProjectVersions() throws Exception {
        TestProjectResource.assertTrue((boolean)this.projectClient.getVersions("10001").isEmpty());
        TestProjectResource.assertTrue((boolean)this.projectClient.getVersions("MKY").isEmpty());
        TestProjectResource.assertEquals(this.createVersionsAtl(), (Object)this.projectClient.getVersions("10010"));
        TestProjectResource.assertEquals(this.createVersionsAtl(), (Object)this.projectClient.getVersions("ATL"));
    }

    public void testViewProjectVersionsAnonymous() throws Exception {
        TestProjectResource.assertEquals(this.createVersionsAtl(), (Object)((ProjectClient)this.projectClient.anonymous()).getVersions("10010"));
        TestProjectResource.assertEquals(this.createVersionsAtl(), (Object)((ProjectClient)this.projectClient.anonymous()).getVersions("ATL"));
        this.checkProjectNotFoundForVersions("id", "10001");
        this.checkProjectNotFoundForVersions("key", "MKY");
    }

    private void checkProjectNotFoundForVersions(String field, String projectIdOrKey) {
        Response response = this.projectClient.getVersionsResponse(projectIdOrKey);
        TestProjectResource.assertEquals((int)404, (int)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Object)String.format("No project could be found with %s '%s'.", field, projectIdOrKey)));
    }

    public void testViewProjectComponents() throws Exception {
        TestProjectResource.assertTrue((boolean)this.projectClient.getComponents("10001").isEmpty());
        TestProjectResource.assertTrue((boolean)this.projectClient.getComponents("MKY").isEmpty());
        TestProjectResource.assertEquals(this.createComponentsHsp(), (Object)this.projectClient.getComponents("10000"));
        TestProjectResource.assertEquals(this.createComponentsHsp(), (Object)this.projectClient.getComponents("HSP"));
    }

    public void testViewProjectComponentsAnonymous() throws Exception {
        TestProjectResource.assertEquals(this.createComponentsAtlFull(), (Object)((ProjectClient)this.projectClient.anonymous()).getComponents("10010"));
        TestProjectResource.assertEquals(this.createComponentsAtlFull(), (Object)((ProjectClient)this.projectClient.anonymous()).getComponents("ATL"));
        this.checkProjectNotFoundForComponents("id", "10001");
        this.checkProjectNotFoundForComponents("key", "MKY");
    }

    private void checkProjectNotFoundForComponents(String field, String projectIdOrKey) {
        try {
            this.projectClient.getComponents(projectIdOrKey);
            TestProjectResource.fail((String)"Should throw exception.");
        }
        catch (UniformInterfaceException e) {
            ClientResponse response = e.getResponse();
            TestProjectResource.assertEquals((int)404, (int)response.getStatus());
            Assert.assertThat((Object)((Errors)response.getEntity(Errors.class)).errorMessages, (Matcher)Matchers.hasItem((Object)String.format("No project could be found with %s '%s'.", field, projectIdOrKey)));
        }
    }

    public void testGetAvatars() throws Exception {
        this.checkGetAvatars("10000");
        this.checkGetAvatars("HSP");
    }

    private void checkGetAvatars(String projectIdOrKey) {
        Map avatars = this.projectClient.getAvatars(projectIdOrKey);
        List systemAvatars = (List)avatars.get("system");
        List customAvatars = (List)avatars.get("custom");
        Assert.assertThat((Object)systemAvatars.size(), (Matcher)CoreMatchers.equalTo((Object)16));
        Assert.assertThat((Object)customAvatars.size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    public void testViewProjectWithEditedKey() throws Exception {
        Project expectedProject = this.createProjectMky().key("TST");
        this.backdoor.project().editProjectKey(Long.valueOf(expectedProject.id), "TST");
        Assert.assertThat((Object)((ProjectClient)this.projectClient.loginAs("admin")).get("TST"), (Matcher)CoreMatchers.equalTo((Object)expectedProject));
        Assert.assertThat((Object)((ProjectClient)this.projectClient.loginAs("admin")).get("MKY"), (Matcher)CoreMatchers.equalTo((Object)expectedProject));
    }

    public void testViewProjectsExpandDescription() throws Exception {
        Project projectAtl = this.makeSimpleIncludeDescription(this.createProjectAtl());
        Project projectFred = this.makeSimpleIncludeDescription(this.createProjectFred());
        Project projectHsp = this.makeSimpleIncludeDescription(this.createProjectHsp());
        Project projectHid = this.makeSimpleIncludeDescription(this.createProjectHid());
        Project projectMky = this.makeSimpleIncludeDescription(this.createProjectMky());
        Project projectDodo = this.makeSimpleIncludeDescription(this.createProjectDodo());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectDodo, projectFred, projectHid, projectHsp, projectMky), (Object)this.projectClient.getProjects("description"));
    }

    public void testViewProjectsExpandLead() throws Exception {
        Project projectAtl = this.makeSimpleIncludeLead(this.createProjectAtl());
        Project projectFred = this.makeSimpleIncludeLead(this.createProjectFred());
        Project projectHsp = this.makeSimpleIncludeLead(this.createProjectHsp());
        Project projectHid = this.makeSimpleIncludeLead(this.createProjectHid());
        Project projectMky = this.makeSimpleIncludeLead(this.createProjectMky());
        Project projectDodo = this.makeSimpleIncludeLead(this.createProjectDodo());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectDodo, projectFred, projectHid, projectHsp, projectMky), (Object)this.projectClient.getProjects("lead"));
    }

    public void testViewProjectsExpandDescriptionAndLead() throws Exception {
        Project projectAtl = this.makeSimpleIncludeDescriptionAndLead(this.createProjectAtl());
        Project projectFred = this.makeSimpleIncludeDescriptionAndLead(this.createProjectFred());
        Project projectHsp = this.makeSimpleIncludeDescriptionAndLead(this.createProjectHsp());
        Project projectHid = this.makeSimpleIncludeDescriptionAndLead(this.createProjectHid());
        Project projectMky = this.makeSimpleIncludeDescriptionAndLead(this.createProjectMky());
        Project projectDodo = this.makeSimpleIncludeDescriptionAndLead(this.createProjectDodo());
        TestProjectResource.assertEquals(TestProjectResource.list(projectAtl, projectDodo, projectFred, projectHid, projectHsp, projectMky), (Object)this.projectClient.getProjects("description,lead"));
    }

    private Project makeSimple(Project project) {
        return project.email(null).components(null).assigneeType(null).description(null).lead(null).versions(null).issueTypes(null).roles(null);
    }

    private Project makeSimpleIncludeDescription(Project project) {
        return project.email(null).components(null).assigneeType(null).lead(null).versions(null).issueTypes(null).roles(null);
    }

    private Project makeSimpleIncludeLead(Project project) {
        return project.email(null).components(null).assigneeType(null).description(null).versions(null).issueTypes(null).roles(null);
    }

    private Project makeSimpleIncludeDescriptionAndLead(Project project) {
        return project.email(null).components(null).assigneeType(null).versions(null).issueTypes(null).roles(null);
    }

    private void assertCantSeeProject(String username, String key) {
        this.assertCantSeeProject(key, username, "key");
    }

    private void assertCantSeeProject(String username, Long id) {
        this.assertCantSeeProject(Long.toString(id), username, "id");
    }

    private void assertCantSeeProject(String projectIdOrKey, String username, String field) {
        if (username == null) {
            this.projectClient.anonymous();
        } else {
            this.projectClient.loginAs(username);
        }
        Response response = this.projectClient.getResponse(projectIdOrKey);
        TestProjectResource.assertEquals((int)404, (int)response.statusCode);
        Assert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Object)String.format("No project could be found with %s '%s'.", field, projectIdOrKey)));
    }

    private void checkProject(Project expectedProject, boolean fred, boolean anonymous) {
        this.checkProjectByKeyOrId(expectedProject.id, expectedProject, fred, anonymous);
        this.checkProjectByKeyOrId(expectedProject.key, expectedProject, fred, anonymous);
    }

    private void checkProjectByKeyOrId(String projectKeyOrId, Project expectedProject, boolean fred, boolean anonymous) {
        Project actualProject = ((ProjectClient)this.projectClient.loginAs("admin")).get(projectKeyOrId);
        Assert.assertThat((Object)actualProject, (Matcher)CoreMatchers.equalTo((Object)expectedProject));
        if (fred) {
            actualProject = ((ProjectClient)this.projectClient.loginAs("fred")).get(expectedProject.key);
            TestProjectResource.assertEquals((Object)expectedProject, (Object)actualProject);
        }
        if (anonymous) {
            actualProject = ((ProjectClient)this.projectClient.anonymous()).get(expectedProject.key);
            TestProjectResource.assertEquals((Object)expectedProject, (Object)actualProject);
        }
    }

    private List<IssueType> createStandardIssueTypes() {
        return CollectionBuilder.newBuilder(new IssueType().self(this.getRestApiUrl("issuetype/1")).id("1").name("Bug").iconUrl(this.getBaseUrlPlus("/images/icons/issuetypes/bug.png")).description("A problem which impairs or prevents the functions of the product."), new IssueType().self(this.getRestApiUrl("issuetype/2")).id("2").name("New Feature").iconUrl(this.getBaseUrlPlus("/images/icons/issuetypes/newfeature.png")).description("A new feature of the product, which has yet to be developed."), new IssueType().self(this.getRestApiUrl("issuetype/3")).id("3").name("Task").iconUrl(this.getBaseUrlPlus("/images/icons/issuetypes/task.png")).description("A task that needs to be done."), new IssueType().self(this.getRestApiUrl("issuetype/4")).id("4").name("Improvement").iconUrl(this.getBaseUrlPlus("/images/icons/issuetypes/improvement.png")).description("An improvement or enhancement to an existing feature or task.")).asList();
    }

    private Map<String, String> createStandardRoles(String projectKey) {
        return MapBuilder.newBuilder().add("Users", this.getRestApiUri("project", projectKey, "role", "10000").toString()).add("Developers", this.getRestApiUri("project", projectKey, "role", "10001").toString()).add("Administrators", this.getRestApiUri("project", projectKey, "role", "10002").toString()).toMap();
    }

    private Project createProjectMky() {
        return new Project().self(this.getRestApiUri("project/10001")).key("MKY").name("monkey").expand(EXPECTED_EXPAND).id("10001").email("mky@example.com").lead(this.createUserAdmin()).description("project for monkeys").assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("10001")).components(Collections.emptyList()).versions(Collections.emptyList()).avatarUrls(this.createProjectAvatarUrls(10001L, 10011L));
    }

    private Project createProjectHid() {
        return new Project().self(this.getRestApiUri("project/10110")).key("HID").name("HIDDEN").expand(EXPECTED_EXPAND).id("10110").description("").components(Collections.emptyList()).versions(Collections.emptyList()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("10110")).issueTypes(this.createStandardIssueTypes()).lead(this.createUserAdmin()).avatarUrls(this.createProjectAvatarUrls(10110L, 10011L));
    }

    private Project createProjectHsp() {
        return new Project().self(this.getRestApiUri("project/10000")).key("HSP").name("homosapien").expand(EXPECTED_EXPAND).id("10000").description("project for homosapiens").versions(this.createVersionsHsp()).components(this.createComponentsHsp()).issueTypes(this.createStandardIssueTypes()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("10000")).lead(this.createUserAdmin()).avatarUrls(this.createProjectAvatarUrls(10000L, 10140L));
    }

    private Project createProjectFred() {
        return new Project().self(this.getRestApiUri("project/10111")).key("FRED").name("Fred").expand(EXPECTED_EXPAND).id("10111").description("").components(Collections.emptyList()).versions(Collections.emptyList()).issueTypes(this.createStandardIssueTypes()).assigneeType(Project.AssigneeType.PROJECT_LEAD).roles(this.createStandardRoles("10111")).lead(this.createUserFred()).avatarUrls(this.createProjectAvatarUrls(10111L, 10011L));
    }

    private Project createProjectDodo() {
        return new Project().self(this.getRestApiUri("project/10112")).key("DD").name("Dead Leader").expand(EXPECTED_EXPAND).id("10112").description("").components(Collections.emptyList()).versions(Collections.emptyList()).assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("10112")).lead(this.createUserDodo()).avatarUrls(this.createProjectAvatarUrls(10112L, 10011L));
    }

    private Project createProjectAtl() {
        return new Project().self(this.getRestApiUri("project/10010")).key("ATL").name("Atlassian").expand(EXPECTED_EXPAND).id("10010").description("").lead(this.createUserAdmin()).components(this.createComponentsAtlShort()).assigneeType(Project.AssigneeType.PROJECT_LEAD).issueTypes(this.createStandardIssueTypes()).roles(this.createStandardRoles("10010")).versions(this.createVersionsAtl()).avatarUrls(this.createProjectAvatarUrls(10010L, 10011L));
    }

    private Map<String, String> createProjectAvatarUrls(Long projectId, Long avatarId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (DEFAULT_AVATAR_ID.equals(avatarId)) {
            builder.put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/projectavatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/projectavatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/projectavatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/projectavatar?avatarId=" + avatarId));
        } else {
            builder.put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/projectavatar?size=small&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/projectavatar?size=xsmall&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/projectavatar?size=medium&pid=" + projectId + "&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/projectavatar?pid=" + projectId + "&avatarId=" + avatarId));
        }
        return builder.build();
    }

    private Map<String, String> createUserAvatarUrls(Long avatarId) {
        return ImmutableMap.builder().put((Object)"24x24", (Object)this.getBaseUrlPlus("secure/useravatar?size=small&avatarId=" + avatarId)).put((Object)"16x16", (Object)this.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=" + avatarId)).put((Object)"32x32", (Object)this.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=" + avatarId)).put((Object)"48x48", (Object)this.getBaseUrlPlus("secure/useravatar?avatarId=" + avatarId)).build();
    }

    private List<Version> createVersionsAtl() {
        CollectionBuilder<Version> builder = CollectionBuilder.newBuilder();
        builder.add(new Version().self(this.createVersionUri(10014L)).archived(Boolean.valueOf(true)).released(Boolean.valueOf(false)).name("Five").description("Five").id(Long.valueOf(10014L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10013L)).archived(Boolean.valueOf(true)).released(Boolean.valueOf(true)).name("Four").description("Four").releaseDate("09/Mar/11").id(Long.valueOf(10013L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10012L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(true)).name("Three").releaseDate("09/Mar/11").id(Long.valueOf(10012L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10011L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("Two").description("Description").id(Long.valueOf(10011L)).projectId(Long.valueOf(10010L)));
        builder.add(new Version().self(this.createVersionUri(10010L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("One").releaseDate("01/Mar/11").overdue(Boolean.valueOf(true)).id(Long.valueOf(10010L)).projectId(Long.valueOf(10010L)));
        return builder.asList();
    }

    private List<Version> createVersionsHsp() {
        CollectionBuilder<Version> builder = CollectionBuilder.newBuilder();
        builder.add(new Version().self(this.createVersionUri(10000L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 1").description("Test Version Description 1").id(Long.valueOf(10000L)));
        builder.add(new Version().self(this.createVersionUri(10001L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 4").description("Test Version Description 4").id(Long.valueOf(10001L)));
        builder.add(new Version().self(this.createVersionUri(10002L)).archived(Boolean.valueOf(false)).released(Boolean.valueOf(false)).name("New Version 5").description("Test Version Description 5").id(Long.valueOf(10002L)));
        return builder.asList();
    }

    private List<Component> createComponentsHsp() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new Component().self(this.createComponentUri(10000L)).id(Long.valueOf(10000L)).name("New Component 1").project("HSP").projectId(10000L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        builder.add((Object)new Component().self(this.createComponentUri(10001L)).id(Long.valueOf(10001L)).name("New Component 2").project("HSP").projectId(10000L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        builder.add((Object)new Component().self(this.createComponentUri(10002L)).id(Long.valueOf(10002L)).name("New Component 3").project("HSP").projectId(10000L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        return builder.build();
    }

    private List<Component> createComponentsAtlFull() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10003L)).id(Long.valueOf(10003L)).name("New Component 4").project("ATL").projectId(10010L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        builder.add(new Component().self(this.createComponentUri(10004L)).id(Long.valueOf(10004L)).name("New Component 5").project("ATL").projectId(10010L).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true));
        return builder.asList();
    }

    private List<Component> createComponentsAtlShort() {
        CollectionBuilder<Component> builder = CollectionBuilder.newBuilder();
        builder.add(new Component().self(this.createComponentUri(10003L)).id(Long.valueOf(10003L)).name("New Component 4"));
        builder.add(new Component().self(this.createComponentUri(10004L)).id(Long.valueOf(10004L)).name("New Component 5"));
        return builder.asList();
    }

    private User createUserAdmin() {
        return new User().self(this.createUserUri("admin")).name("admin").key("admin").displayName("Administrator").active(true).avatarUrls(this.createUserAvatarUrls(10062L));
    }

    private User createUserFred() {
        return new User().self(this.createUserUri("fred")).name("fred").key("fred").displayName("Fred Normal").active(true).avatarUrls(this.createUserAvatarUrls(10062L));
    }

    private User createUserDodo() {
        return new User().self(this.createUserUri("dodo")).name("dodo").key("dodo").displayName("dodo").active(false).avatarUrls(this.createUserAvatarUrls(10063L));
    }

    private URI createVersionUri(long id) {
        return this.getRestApiUri("version", String.valueOf(id));
    }

    private URI createComponentUri(long id) {
        return this.getRestApiUri("component", String.valueOf(id));
    }

    private URI createUserUri(String name) {
        return this.getRestApiUri(String.format("user?username=%s", name));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestProjectResource.xml");
    }

    @Override
    protected void tearDownTest() {
        super.tearDownTest();
        this.projectClient = null;
        this.administration = null;
    }

    private static <T, S extends T> List<T> list(S ... element) {
        return Lists.newArrayList((Object[])element);
    }
}

