/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
public class TestProjectPropertyResource
extends FuncTestCase {
    private static final String PROJECT_KEY = "HSP";
    private static final String PROPERTY_KEY = "project.admin";
    private EntityPropertyClient client;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "project");
    }

    public void testCreatingNewProjectProperty() {
        this.administration.restoreBlankInstance();
        Assert.assertThat((Object)this.client.getKeys((String)PROJECT_KEY).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject(ImmutableMap.of((Object)"username", (Object)"filip", (Object)"userkey", (Object)"filip2"));
        this.client.put(PROJECT_KEY, PROPERTY_KEY, jsonObject);
        EntityProperty projectProperty = this.client.get(PROJECT_KEY, PROPERTY_KEY);
        Assert.assertThat((Object)projectProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(projectProperty.value)));
        List keys = this.client.getKeys((String)PROJECT_KEY).keys;
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem(PropertyAssertions.propertyKey(PROPERTY_KEY)));
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestProjectPropertyResource.this.client.anonymous()).getKeys(TestProjectPropertyResource.PROJECT_KEY);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestProjectPropertyResource.this.client.anonymous()).get(TestProjectPropertyResource.PROJECT_KEY, TestProjectPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    public void testDeletingProperties() {
        this.administration.restoreBlankInstance();
        Assert.assertThat((Object)this.client.getKeys((String)PROJECT_KEY).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject(ImmutableMap.of((Object)"label", (Object)"todo", (Object)"color", (Object)"red"));
        this.client.put(PROJECT_KEY, PROPERTY_KEY, jsonObject);
        EntityProperty projectProperty = this.client.get(PROJECT_KEY, PROPERTY_KEY);
        Assert.assertThat((Object)projectProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(projectProperty.value)));
        this.client.delete(PROJECT_KEY, PROPERTY_KEY);
        Assert.assertThat((Object)this.client.getKeys((String)PROJECT_KEY).keys, (Matcher)Matchers.empty());
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestProjectPropertyResource.this.client.get(TestProjectPropertyResource.PROJECT_KEY, TestProjectPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    public void testForbiddenForUserWithoutPermissionsToProject() {
        this.backdoor.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestProjectPropertyResource.this.client.loginAs("bob", "bob")).put(TestProjectPropertyResource.PROJECT_KEY, TestProjectPropertyResource.PROPERTY_KEY, new JSONObject(ImmutableMap.of((Object)"status", (Object)"done")));
                return null;
            }
        }, Response.Status.FORBIDDEN);
    }

    public void testPropertiesAreRemovedWhenProjectIsRemoved() throws JSONException {
        this.backdoor.restoreBlankInstance();
        JSONObject jsonObject = new JSONObject(ImmutableMap.of((Object)"status", (Object)"unresolved"));
        this.client.put(PROJECT_KEY, PROPERTY_KEY, jsonObject);
        EntityProperty property = this.client.get(PROJECT_KEY, PROPERTY_KEY);
        Assert.assertThat((Object)new JSONObject(property.value), (Matcher)Matchers.is((Object)jsonObject));
        this.backdoor.project().deleteProject(PROJECT_KEY);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestProjectPropertyResource.this.client.get(TestProjectPropertyResource.PROJECT_KEY, TestProjectPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }
}

