/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestProjectCategoryResource
extends RestFuncTest {
    private static final String PROJECT_CATEGORY = "projectCategory";
    private static final String SELF = "self";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    public static final String CATEGORY_NAME = "category_one";
    public static final String CATEGORY_DESCRIPTION = "description of category one";
    public static final String CATEGORY_NAME_2 = "category_two";
    public static final String CATEGORY_DESCRIPTION_2 = "description of category two";
    private ProjectCategoryClient preferencesClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.preferencesClient = new ProjectCategoryClient(this.getEnvironmentData());
        this.backdoor.restoreBlankInstance();
    }

    @Override
    protected void tearDownTest() {
        this.preferencesClient.cleanup();
    }

    public void testHappyPathUseCase() {
        ClientResponse responseGetAllCategoriesEmpty = this.preferencesClient.getAllCategories();
        Assert.assertThat((Object)responseGetAllCategoriesEmpty.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.OK.getStatusCode()));
        Assert.assertThat((Object)((Collection)responseGetAllCategoriesEmpty.getEntity(Collection.class)), (Matcher)Matchers.empty());
        this.preferencesClient.cleanup();
        ClientResponse responseGetNotExistingCategory = this.preferencesClient.getCategory("0");
        Assert.assertThat((Object)responseGetNotExistingCategory.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NOT_FOUND.getStatusCode()));
        this.preferencesClient.cleanup();
        ClientResponse responseCreateCategory = this.preferencesClient.createCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        Map responseCreateCategoryEntity = (Map)responseCreateCategory.getEntity(Map.class);
        Assert.assertThat((Object)responseGetAllCategoriesEmpty.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.OK.getStatusCode()));
        Assert.assertThat((Object)responseCreateCategoryEntity, (Matcher)Matchers.hasKey((Object)SELF));
        Assert.assertThat((Object)responseCreateCategoryEntity, (Matcher)Matchers.hasKey((Object)ID));
        Assert.assertThat((Object)responseCreateCategoryEntity, (Matcher)Matchers.hasEntry((Object)NAME, (Object)CATEGORY_NAME));
        Assert.assertThat((Object)responseCreateCategoryEntity, (Matcher)Matchers.hasEntry((Object)DESCRIPTION, (Object)CATEGORY_DESCRIPTION));
        String categoryId = (String)responseCreateCategoryEntity.get(ID);
        this.preferencesClient.cleanup();
        ClientResponse responseCreateCategory2 = this.preferencesClient.createCategory(CATEGORY_NAME_2, CATEGORY_DESCRIPTION_2);
        Map responseCreateCategoryEntity2 = (Map)responseCreateCategory2.getEntity(Map.class);
        Assert.assertThat((Object)responseCreateCategory2.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.CREATED.getStatusCode()));
        String categoryId2 = (String)responseCreateCategoryEntity2.get(ID);
        this.preferencesClient.cleanup();
        ClientResponse responseGetCategory = this.preferencesClient.getCategory(categoryId);
        Map responseGetCategoryEntity = (Map)responseGetCategory.getEntity(Map.class);
        Assert.assertThat((Object)responseGetCategory.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.OK.getStatusCode()));
        Assert.assertThat((Object)responseGetCategoryEntity, (Matcher)Matchers.hasKey((Object)SELF));
        Assert.assertThat((Object)responseGetCategoryEntity, (Matcher)Matchers.hasEntry((Object)ID, (Object)categoryId));
        Assert.assertThat((Object)responseGetCategoryEntity, (Matcher)Matchers.hasEntry((Object)NAME, (Object)CATEGORY_NAME));
        Assert.assertThat((Object)responseGetCategoryEntity, (Matcher)Matchers.hasEntry((Object)DESCRIPTION, (Object)CATEGORY_DESCRIPTION));
        this.preferencesClient.cleanup();
        ClientResponse responseGetAllCategoriesTwo = this.preferencesClient.getAllCategories();
        Assert.assertThat((Object)responseGetAllCategoriesTwo.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.OK.getStatusCode()));
        Collection responseGetAllCategoriesTwoEntity = (Collection)responseGetAllCategoriesTwo.getEntity(Collection.class);
        Assert.assertThat((Object)responseGetAllCategoriesTwoEntity, (Matcher)Matchers.hasSize((int)2));
        this.preferencesClient.cleanup();
        ClientResponse responseDeleteCategory = this.preferencesClient.deleteCategory(categoryId);
        Assert.assertThat((Object)responseDeleteCategory.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NO_CONTENT.getStatusCode()));
        this.preferencesClient.cleanup();
        ClientResponse responseGetAllCategoriesOne = this.preferencesClient.getAllCategories();
        Assert.assertThat((Object)responseGetAllCategoriesOne.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.OK.getStatusCode()));
        Collection responseGetAllCategoriesOneEntity = (Collection)responseGetAllCategoriesOne.getEntity(Collection.class);
        Assert.assertThat((Object)responseGetAllCategoriesOneEntity, (Matcher)Matchers.hasSize((int)1));
        this.preferencesClient.cleanup();
        ClientResponse responseDeleteCategory2 = this.preferencesClient.deleteCategory(categoryId2);
        Assert.assertThat((Object)responseDeleteCategory2.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NO_CONTENT.getStatusCode()));
        this.preferencesClient.cleanup();
        ClientResponse responseDeleteCategory3 = this.preferencesClient.getCategory(categoryId2);
        Assert.assertThat((Object)responseDeleteCategory3.getStatus(), (Matcher)CoreMatchers.equalTo((Object)ClientResponse.Status.NOT_FOUND.getStatusCode()));
        this.preferencesClient.cleanup();
    }

    private class ProjectCategoryClient
    extends RestApiClient<ProjectCategoryClient> {
        private final Set<ClientResponse> responses;

        protected ProjectCategoryClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
            this.responses = Sets.newHashSet();
        }

        private ClientResponse getAllCategories() {
            WebResource webResource = this.createResource().path(TestProjectCategoryResource.PROJECT_CATEGORY);
            ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse getCategory(String id) {
            WebResource webResource = this.createResource().path("projectCategory/" + id);
            ClientResponse clientResponse = (ClientResponse)webResource.get(ClientResponse.class);
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private ClientResponse createCategory(String name, String description) {
            WebResource webResource = this.createResource().path(TestProjectCategoryResource.PROJECT_CATEGORY);
            HashMap postBody = Maps.newHashMap();
            postBody.put(TestProjectCategoryResource.NAME, name);
            postBody.put(TestProjectCategoryResource.DESCRIPTION, description);
            ClientResponse post = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)postBody);
            this.responses.add(post);
            return post;
        }

        private ClientResponse deleteCategory(String id) {
            WebResource webResource = this.createResource().path("projectCategory/" + id);
            ClientResponse clientResponse = (ClientResponse)webResource.delete(ClientResponse.class);
            this.responses.add(clientResponse);
            return clientResponse;
        }

        private void cleanup() {
            for (ClientResponse response : this.responses) {
                response.close();
            }
        }
    }
}

