/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.PriorityClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestPriorityResource
extends RestFuncTest {
    private static final String PRIORITY_ID = "1";
    private PriorityClient priorityClient;

    public void testAllPriorities() throws Exception {
        List priorities = this.priorityClient.get();
        this.assertprioritiesContain(priorities, PRIORITY_ID);
        this.assertprioritiesContain(priorities, "2");
        this.assertprioritiesContain(priorities, "3");
        this.assertprioritiesContain(priorities, "4");
        this.assertprioritiesContain(priorities, "5");
    }

    private void assertprioritiesContain(List<Priority> priorities, String id) {
        for (Priority priority : priorities) {
            if (!priority.id().equals(id)) continue;
            return;
        }
        TestPriorityResource.fail((String)("Priority " + id + " not in list"));
    }

    public void testViewPriority() throws Exception {
        Priority priority = this.priorityClient.get(PRIORITY_ID);
        TestPriorityResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2/priority/1"), (String)priority.self());
        TestPriorityResource.assertEquals((String)"#cc0000", (String)priority.statusColor());
        TestPriorityResource.assertEquals((String)"Blocks development and/or testing work, production could not run.", (String)priority.description());
        TestPriorityResource.assertEquals((String)this.getBaseUrlPlus("images/icons/priorities/blocker.png"), (String)priority.iconUrl());
        TestPriorityResource.assertEquals((String)"Blocker", (String)priority.name());
        TestPriorityResource.assertEquals((String)PRIORITY_ID, (String)priority.id());
    }

    public void testViewPriorityNotFound() throws Exception {
        Response resp123 = this.priorityClient.getResponse("123");
        TestPriorityResource.assertEquals((int)404, (int)resp123.statusCode);
        TestPriorityResource.assertEquals((int)1, (int)resp123.entity.errorMessages.size());
        TestPriorityResource.assertTrue((boolean)resp123.entity.errorMessages.contains("The priority with id '123' does not exist"));
        Response respFoo = this.priorityClient.getResponse("foo");
        TestPriorityResource.assertEquals((int)404, (int)respFoo.statusCode);
        TestPriorityResource.assertTrue((boolean)respFoo.entity.errorMessages.contains("The priority with id 'foo' does not exist"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.priorityClient = new PriorityClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreBlankInstance();
    }
}

