/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestPermissionsResource
extends RestFuncTest {
    private PermissionsClient permissionsClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.permissionsClient = new PermissionsClient(this.getEnvironmentData());
        this.administration.restoreData("TestPermissionsRest.xml");
        this.backdoor.plugins().disablePluginModule("com.atlassian.jira.dev.func-test-plugin:func.test.global.permission");
        this.backdoor.plugins().enablePluginModule("com.atlassian.jira.dev.func-test-plugin:func.test.global.permission");
    }

    public void testGlobalPermissions() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean admin = ((PermissionsOuter)outer.body).permissions.get("ADMINISTER");
        TestPermissionsResource.assertNotNull((Object)admin);
        TestPermissionsResource.assertEquals((String)"Ability to perform most administration functions (excluding Import & Export, SMTP Configuration, etc.).", (String)admin.description);
        TestPermissionsResource.assertEquals((String)"0", (String)admin.id);
        TestPermissionsResource.assertEquals((String)"ADMINISTER", (String)admin.key);
        TestPermissionsResource.assertEquals((String)"JIRA Administrators", (String)admin.name);
        TestPermissionsResource.assertEquals((String)"GLOBAL", (String)admin.type);
        TestPermissionsResource.assertNull((Object)admin.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)admin.havePermission);
        outer = ((PermissionsClient)this.permissionsClient.loginAs("user", "user")).getPermissions();
        admin = ((PermissionsOuter)outer.body).permissions.get("ADMINISTER");
        TestPermissionsResource.assertNotNull((Object)admin);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)admin.havePermission);
        PermissionJsonBean plugGlobalPermission = ((PermissionsOuter)outer.body).permissions.get("func.test.global.permission");
        TestPermissionsResource.assertEquals((String)"func.test.global.permission.description", (String)plugGlobalPermission.description);
        TestPermissionsResource.assertEquals((String)"func.test.global.permission", (String)plugGlobalPermission.key);
        TestPermissionsResource.assertEquals((String)"func.test.global.permission.name", (String)plugGlobalPermission.name);
        TestPermissionsResource.assertEquals((String)"GLOBAL", (String)plugGlobalPermission.type);
        TestPermissionsResource.assertNull((Object)plugGlobalPermission.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)plugGlobalPermission.havePermission);
    }

    public void testGetLegacyProjectPermissions() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"Ability to browse projects and the issues within them.", (String)browse.description);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"BROWSE", (String)browse.key);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)browse.type);
        TestPermissionsResource.assertEquals((Object)Boolean.TRUE, (Object)browse.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        PermissionJsonBean comment = ((PermissionsOuter)outer.body).permissions.get("COMMENT_ISSUE");
        TestPermissionsResource.assertNotNull((Object)comment);
        TestPermissionsResource.assertEquals((String)"Ability to comment on issues.", (String)comment.description);
        TestPermissionsResource.assertEquals((String)"15", (String)comment.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_ISSUE", (String)comment.key);
        TestPermissionsResource.assertEquals((String)"Add Comments", (String)comment.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)browse.type);
        TestPermissionsResource.assertEquals((Object)Boolean.TRUE, (Object)browse.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)comment.havePermission);
        outer = ((PermissionsClient)this.permissionsClient.loginAs("user", "user")).getPermissions();
        browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)browse.havePermission);
        comment = ((PermissionsOuter)outer.body).permissions.get("COMMENT_ISSUE");
        TestPermissionsResource.assertNotNull((Object)comment);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)comment.havePermission);
    }

    public void testGetProjectPermissions() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"Ability to browse projects and the issues within them.", (String)browse.description);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.BROWSE_PROJECTS.permissionKey(), (String)browse.key);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)browse.type);
        TestPermissionsResource.assertNull((Object)browse.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        PermissionJsonBean comment = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.ADD_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)comment);
        TestPermissionsResource.assertEquals((String)"Ability to comment on issues.", (String)comment.description);
        TestPermissionsResource.assertEquals((String)"15", (String)comment.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.ADD_COMMENTS.permissionKey(), (String)comment.key);
        TestPermissionsResource.assertEquals((String)"Add Comments", (String)comment.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)comment.type);
        TestPermissionsResource.assertNull((Object)comment.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)comment.havePermission);
        outer = ((PermissionsClient)this.permissionsClient.loginAs("user", "user")).getPermissions();
        browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)browse.havePermission);
        comment = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.ADD_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)comment);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)comment.havePermission);
        PermissionJsonBean plugProjectPermission = ((PermissionsOuter)outer.body).permissions.get("func.test.project.permission");
        TestPermissionsResource.assertEquals((String)"func.test.project.permission.description", (String)plugProjectPermission.description);
        TestPermissionsResource.assertEquals((String)"func.test.project.permission", (String)plugProjectPermission.key);
        TestPermissionsResource.assertEquals((String)"func.test.project.permission.name", (String)plugProjectPermission.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)plugProjectPermission.type);
        TestPermissionsResource.assertNull((Object)plugProjectPermission.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)plugProjectPermission.havePermission);
    }

    public void testLegacyProjectFilter() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"Ability to browse projects and the issues within them.", (String)browse.description);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"BROWSE", (String)browse.key);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)browse.type);
        TestPermissionsResource.assertEquals((Object)Boolean.TRUE, (Object)browse.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectKey", "PROJECTA").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectKey", "PROJECTB").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectId", "10000").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectId", "10001").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get("BROWSE");
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)browse.havePermission);
    }

    public void testProjectFilter() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"Ability to browse projects and the issues within them.", (String)browse.description);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.BROWSE_PROJECTS.permissionKey(), (String)browse.key);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)browse.type);
        TestPermissionsResource.assertNull((Object)browse.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectKey", "PROJECTA").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectKey", "PROJECTB").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectId", "10000").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)browse.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectId", "10001").toMap());
        browse = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)browse);
        TestPermissionsResource.assertEquals((String)"10", (String)browse.id);
        TestPermissionsResource.assertEquals((String)"Browse Projects", (String)browse.name);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)browse.havePermission);
    }

    public void testLegacyIssueFiltering() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL");
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"Ability to delete all comments made on issues.", (String)commentDeleteAll.description);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_DELETE_ALL", (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((String)"Delete All Comments", (String)commentDeleteAll.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)commentDeleteAll.type);
        TestPermissionsResource.assertEquals((Object)Boolean.TRUE, (Object)commentDeleteAll.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectKey", "PROJECTA").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL");
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_DELETE_ALL", (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueKey", "PROJECTA-3").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL");
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_DELETE_ALL", (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueKey", "PROJECTA-4").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL");
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_DELETE_ALL", (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueId", "10200").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL");
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_DELETE_ALL", (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueId", "10201").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get("COMMENT_DELETE_ALL");
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)"COMMENT_DELETE_ALL", (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)commentDeleteAll.havePermission);
    }

    public void testIssueFiltering() {
        Response outer = this.permissionsClient.getPermissions();
        PermissionJsonBean commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"Ability to delete all comments made on issues.", (String)commentDeleteAll.description);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey(), (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((String)"Delete All Comments", (String)commentDeleteAll.name);
        TestPermissionsResource.assertEquals((String)"PROJECT", (String)commentDeleteAll.type);
        TestPermissionsResource.assertNull((Object)commentDeleteAll.deprecatedKey);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("projectKey", "PROJECTA").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey(), (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueKey", "PROJECTA-3").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey(), (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueKey", "PROJECTA-4").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey(), (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueId", "10200").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey(), (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)true, (boolean)commentDeleteAll.havePermission);
        outer = this.permissionsClient.getPermissions(MapBuilder.newBuilder().add("issueId", "10201").toMap());
        commentDeleteAll = ((PermissionsOuter)outer.body).permissions.get(ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey());
        TestPermissionsResource.assertNotNull((Object)commentDeleteAll);
        TestPermissionsResource.assertEquals((String)"36", (String)commentDeleteAll.id);
        TestPermissionsResource.assertEquals((String)ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey(), (String)commentDeleteAll.key);
        TestPermissionsResource.assertEquals((boolean)false, (boolean)commentDeleteAll.havePermission);
    }

    private static class PermissionJsonBean {
        @JsonProperty
        String id;
        @JsonProperty
        String key;
        @JsonProperty
        String name;
        @JsonProperty
        Boolean deprecatedKey;
        @JsonProperty
        String description;
        @JsonProperty
        boolean havePermission;
        @JsonProperty
        private String type;

        private PermissionJsonBean() {
        }
    }

    private static class PermissionsOuter {
        @JsonProperty
        HashMap<String, PermissionJsonBean> permissions;

        private PermissionsOuter() {
        }
    }

    private class PermissionsClient
    extends RestApiClient<PermissionsClient> {
        protected PermissionsClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
        }

        private Response<PermissionsOuter> getPermissions() {
            return this.toResponse(new RestApiClient.Method(){

                public ClientResponse call() {
                    return (ClientResponse)PermissionsClient.this.createResource().path("mypermissions").get(ClientResponse.class);
                }
            }, PermissionsOuter.class);
        }

        private Response<PermissionsOuter> getPermissions(final Map<String, String> params) {
            return this.toResponse(new RestApiClient.Method(){

                public ClientResponse call() {
                    WebResource path = PermissionsClient.this.createResource().path("mypermissions");
                    for (Map.Entry entry : params.entrySet()) {
                        path = path.queryParam((String)entry.getKey(), (String)entry.getValue());
                    }
                    return (ClientResponse)path.get(ClientResponse.class);
                }
            }, PermissionsOuter.class);
        }
    }
}

