/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.HeaderValue;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.URLEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.SECURITY})
public class TestLogin
extends RestFuncTest {
    public static final int CAPTCHA_MAX_TRIES = 10;
    public static final String X_AUTHENTICATION_DENIED_REASON = "X-Authentication-Denied-Reason";
    public static final String REST_AUTH_RESOURCE = "/rest/auth/latest/session";
    public static final String SESSION_PARAM = "JSESSIONID";
    private JSONObject fredBadCredentials;
    private JSONObject fredGoodCredentials;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        try {
            this.fredBadCredentials = new JSONObject();
            this.fredBadCredentials.put("username", "fred");
            this.fredBadCredentials.put("password", "fredzzz");
            this.fredGoodCredentials = new JSONObject();
            this.fredGoodCredentials.put("username", "fred");
            this.fredGoodCredentials.put("password", "fred");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void testCurrentUser() throws Exception {
        JSONObject json = this.getJSON(REST_AUTH_RESOURCE, new String[0]);
        TestLogin.assertEquals((String)"admin", (String)json.getString("name"));
        TestLogin.assertTrue((boolean)json.has("loginInfo"));
    }

    public void testCurrentUserUglyName() throws Exception {
        this.backdoor.usersAndGroups().addUser("jo smith");
        this.navigation.login("jo smith");
        JSONObject json = this.getJSON(REST_AUTH_RESOURCE, new String[0]);
        TestLogin.assertEquals((String)"jo smith", (String)json.getString("name"));
        TestLogin.assertTrue((boolean)json.has("loginInfo"));
    }

    public void testCurrentUserAnon() throws Exception {
        this.navigation.logout();
        WebResponse response = this.GET(REST_AUTH_RESOURCE);
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
    }

    public void testLogin() throws Exception {
        this.navigation.logout();
        this.backdoor.usersAndGroups().resetLoginCount("admin");
        long currentLoginCount = this.backdoor.usersAndGroups().getLoginInfo("admin").getLoginCount();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "BAD-PASSWORD");
        WebResponse response = this.loginAs(json);
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
        TestLogin.assertEquals((String)"JIRA REST POST", (String)response.getHeaderField("WWW-Authenticate"));
        JSONObject userThatDoesntExist = new JSONObject().put("username", "wtf").put("password", "kljasdfjkl;dfs");
        TestLogin.assertEquals((String)"should return 401 if user doesn't exist", (int)401, (int)this.loginAs(userThatDoesntExist).getResponseCode());
        json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        response = this.loginAs(json);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        TestLogin.assertEquals((String)SESSION_PARAM, (String)session.getString("name"));
        TestLogin.assertEquals((String)this.tester.getDialog().getWebClient().getCookieValue(SESSION_PARAM), (String)session.getString("value"));
        JSONObject loginInfo = responseJson.getJSONObject("loginInfo");
        TestLogin.assertTrue((boolean)loginInfo.has("previousLoginTime"));
        TestLogin.assertTrue((boolean)loginInfo.has("lastFailedLoginTime"));
        TestLogin.assertEquals((long)(currentLoginCount + 1L), (long)loginInfo.getLong("loginCount"));
        TestLogin.assertEquals((long)1L, (long)loginInfo.getLong("failedLoginCount"));
    }

    public void testWhenTheLoginResourceGivesYouACookieYouShouldBeAbleToActuallyDoSomethingWithIt() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "this is a summary");
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        String jsessionId = TestLogin.getSessionId(this.loginAs(json));
        this.tester.getDialog().getWebClient().clearCookies();
        WebResponse response = this.GET("/rest/api/latest/issue/" + key, MapBuilder.newBuilder().add("Cookie", "JSESSIONID=" + jsessionId).toImmutableMap());
        Assert.assertThat((Object)response.getResponseCode(), (Matcher)IsEqual.equalTo((Object)200));
        JSONObject issue = new JSONObject(response.getText());
        TestLogin.assertTrue((boolean)issue.has("key"));
    }

    public void testCanLoginAfterSessionTimeout() throws Exception {
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        WebResponse response = this.loginAs(json);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        response = this.GET(REST_AUTH_RESOURCE);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        response = this.GET("/rest/api/latest/project/HSP");
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        WebClient client = this.tester.getDialog().getWebClient();
        client.clearCookies();
        client.addCookie(SESSION_PARAM, "BAD1");
        response = this.GET(REST_AUTH_RESOURCE);
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
        client.clearCookies();
        client.addCookie(SESSION_PARAM, "BAD2");
        response = this.GET("/rest/api/latest/project/HSP");
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
        client.clearCookies();
        client.addCookie(SESSION_PARAM, "BAD3");
        response = this.loginAs(json);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
    }

    private static String getSessionId(WebResponse response) throws JSONException, IOException {
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        return session.getString("value");
    }

    public void testLoginsThatAreDeniedDueToCaptchaProtectionShouldReturn403() throws Exception {
        this.navigation.logout();
        WebResponse response = this.provokeCaptchaFailure(this.fredBadCredentials);
        Assert.assertThat((Object)response.getResponseCode(), (Matcher)IsEqual.equalTo((Object)403));
        Assert.assertThat((Object)response, HeaderValue.header(X_AUTHENTICATION_DENIED_REASON, (Matcher<? super String>)IsEqual.equalTo((Object)String.format("CAPTCHA_CHALLENGE; login-url=%s", this.getBaseUrlPlus("login.jsp")))));
    }

    public void testCaptchaFailureWithWrongPasswordIsIdenticalToCaptchaFailureWithRightPassword() throws Exception {
        this.navigation.logout();
        WebResponse wrongPassResponse = this.provokeCaptchaFailure(this.fredBadCredentials);
        WebResponse rightPassResponse = this.loginAs(this.fredGoodCredentials);
        Assert.assertThat((Object)rightPassResponse.getHeaderField(X_AUTHENTICATION_DENIED_REASON), (Matcher)IsEqual.equalTo((Object)wrongPassResponse.getHeaderField(X_AUTHENTICATION_DENIED_REASON)));
    }

    public void testLoginReturnEncodedUsername_IncludingUtf8Chars_InResponseHeader() throws Exception {
        String utf8Username = "\u00c5\u0082Test\u00c5\u0082";
        String urlEncodedUsername = URLEncoder.encode("\u00c5\u0082Test\u00c5\u0082", "UTF-8");
        this.navigation.logout();
        this.backdoor.usersAndGroups().addUser("\u00c5\u0082Test\u00c5\u0082");
        this.navigation.login("\u00c5\u0082Test\u00c5\u0082");
        WebResponse response = this.GET(REST_AUTH_RESOURCE);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        TestLogin.assertEquals((String)urlEncodedUsername, (String)response.getHeaderField("X-AUSERNAME"));
    }

    protected WebResponse loginAs(JSONObject json) throws IOException, SAXException {
        return this.POST(REST_AUTH_RESOURCE, json);
    }

    protected WebResponse provokeCaptchaFailure(JSONObject badCredentials) throws IOException, SAXException {
        WebResponse response;
        int tries = 10;
        do {
            response = this.loginAs(badCredentials);
            this.navigation.logout();
        } while (response.getResponseCode() == 401 && --tries > 0);
        if (tries == 0) {
            TestLogin.fail((String)String.format("Captcha did not kick in after %d failed logins", 10));
        }
        return response;
    }

    public void testLogout() throws Exception {
        this.navigation.login("admin");
        WebResponse response = this.DELETE(REST_AUTH_RESOURCE);
        TestLogin.assertEquals((int)204, (int)response.getResponseCode());
        response = this.DELETE(REST_AUTH_RESOURCE);
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
    }
}

