/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.LinkedIssuesMatcher;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.testkit.client.restclient.LinkIssueClient;
import com.atlassian.jira.testkit.client.restclient.LinkRequest;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestLinkIssueResource
extends RestFuncTest {
    static final LinkRequest DUP_HSP1_MKY1 = new LinkRequest().type(ResourceRef.withName((String)"Duplicate")).inwardIssue(ResourceRef.withKey((String)"HSP-1")).outwardIssue(ResourceRef.withKey((String)"MKY-1"));
    private LinkIssueClient linkIssueClient;
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.linkIssueClient = new LinkIssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestLinkIssueResource.xml");
    }

    public void testLinkIssuesWithComment() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)201, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List comments = issue.fields.comment.getComments();
        TestLinkIssueResource.assertEquals((String)comment.body, (String)((Comment)comments.get((int)0)).body);
        List issueLinks = issue.fields.issuelinks;
        IssueLink issueLink = (IssueLink)issueLinks.get(0);
        TestLinkIssueResource.assertEquals((String)"MKY-1", (String)issueLink.outwardIssue().key());
        IssueLink.Type type = issueLink.type();
        TestLinkIssueResource.assertEquals((String)"Duplicate", (String)type.name());
        issue = this.issueClient.get("MKY-1", new Issue.Expand[0]);
        comments = issue.fields.comment.getComments();
        TestLinkIssueResource.assertEquals((int)0, (int)comments.size());
        issueLinks = issue.fields.issuelinks;
        issueLink = (IssueLink)issueLinks.get(0);
        TestLinkIssueResource.assertEquals((String)"HSP-1", (String)issueLink.inwardIssue().key());
        type = issueLink.type();
        TestLinkIssueResource.assertEquals((String)"Duplicate", (String)type.name());
    }

    public void testLinkIssues() throws Exception {
        Response linkToMky1Resp = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1);
        TestLinkIssueResource.assertEquals((int)201, (int)linkToMky1Resp.statusCode);
        Assert.assertThat((Object)this.issueClient.get("HSP-1", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithOutwardIssue("MKY-1", "Duplicate"));
        ResourceRef duplicates_id = ResourceRef.withId((String)"10000");
        ResourceRef hsp1_key = ResourceRef.withKey((String)"HSP-1");
        ResourceRef hsp2_id = ResourceRef.withId((String)"10101");
        Response linkToHsp2Resp = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1.type(duplicates_id).inwardIssue(hsp1_key).outwardIssue(hsp2_id));
        TestLinkIssueResource.assertEquals((int)201, (int)linkToHsp2Resp.statusCode);
        Assert.assertThat((Object)this.issueClient.get("HSP-2", new Issue.Expand[0]), LinkedIssuesMatcher.hasLinkWithInwardIssue("HSP-1", "Duplicate"));
    }

    public void testLinkIssuesToSelf() throws Exception {
        LinkRequest linkRequest = new LinkRequest().type(ResourceRef.withName((String)"Duplicate")).inwardIssue(ResourceRef.withKey((String)"HSP-1")).outwardIssue(ResourceRef.withKey((String)"HSP-1"));
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)400, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You cannot link an issue to itself.", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesWithInvalidRoleLevelSpecified() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Visibility("role", "Developers");
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)400, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You are currently not a member of the project role: Developers.", (String)((String)response.entity.errors.values().iterator().next()));
    }

    public void testLinkIssuesWithGroupLevelSpecified() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Visibility("group", "jira-administrators");
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)201, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List comments = issue.fields.comment.getComments();
        TestLinkIssueResource.assertEquals((String)comment.body, (String)((Comment)comments.get((int)0)).body);
    }

    public void testLinkIssuesWithRoleLevelSpecified() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        comment.visibility = new Visibility("role", "Administrators");
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)201, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List comments = issue.fields.comment.getComments();
        TestLinkIssueResource.assertEquals((String)comment.body, (String)((Comment)comments.get((int)0)).body);
    }

    public void testLinkIssuesFailedBecauseIssueLinkingDisabled() throws Exception {
        this.oldway_consider_porting.deactivateIssueLinking();
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        LinkRequest linkRequest = DUP_HSP1_MKY1.comment(comment);
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"Issue linking is currently disabled.", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesFailedIssueANotVisible() throws Exception {
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("fred")).linkIssues(DUP_HSP1_MKY1);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You do not have the permission to see the specified issue.", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesFailedIssueBNotVisible() throws Exception {
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("bob")).linkIssues(DUP_HSP1_MKY1);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"You do not have the permission to see the specified issue.", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesFailedNoLInkIssuePermissionIssueA() throws Exception {
        LinkRequest linkRequest = DUP_HSP1_MKY1.outwardIssue(ResourceRef.withKey((String)"HSP-2"));
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("bob")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)401, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No Link Issue Permission for issue 'HSP-1'", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesFailedNoLInkIssuePermissionIssueB() throws Exception {
        Comment comment = new Comment();
        comment.body = "Issue linked via REST!";
        LinkRequest linkRequest = DUP_HSP1_MKY1.inwardIssue(ResourceRef.withKey((String)"MKY-1")).outwardIssue(ResourceRef.withKey((String)"MKY-2")).comment(comment);
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("fred")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)401, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No Link Issue Permission for issue 'MKY-1'", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesFailedBecauseLinkTypeDoesNotExist() throws Exception {
        LinkRequest linkRequest = DUP_HSP1_MKY1.type(ResourceRef.withName((String)"calculated"));
        Response response = this.linkIssueClient.linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No issue link type with name 'calculated' found.", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesLinkIssuePermissionForIssueAButNotB() throws Exception {
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).linkIssues(DUP_HSP1_MKY1);
        TestLinkIssueResource.assertEquals((int)201, (int)response.statusCode);
    }

    public void testLinkIssuesNoLinkIssuePermissionForIssueBButB() throws Exception {
        LinkRequest linkRequest = DUP_HSP1_MKY1.inwardIssue(ResourceRef.withKey((String)"MKY-1")).outwardIssue(ResourceRef.withKey((String)"HSP-1"));
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).linkIssues(linkRequest);
        TestLinkIssueResource.assertEquals((int)401, (int)response.statusCode);
        TestLinkIssueResource.assertEquals((String)"No Link Issue Permission for issue 'MKY-1'", (String)((String)response.entity.errorMessages.get(0)));
    }

    public void testLinkIssuesUsingIssueTypeIdInsteadOfName() throws Exception {
        Response notFoundResponse = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1.type(ResourceRef.withId((String)"1")));
        TestLinkIssueResource.assertEquals((int)404, (int)notFoundResponse.statusCode);
        Assert.assertThat((Object)notFoundResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"No issue link type with id '1' found."));
        Response resp = this.linkIssueClient.linkIssues(DUP_HSP1_MKY1.type(ResourceRef.withId((String)"10100")));
        TestLinkIssueResource.assertEquals((int)201, (int)resp.statusCode);
        Assert.assertThat((Object)((IssueLink)this.issueClient.get((String)"HSP-1", (Issue.Expand[])new Issue.Expand[0]).fields.issuelinks.get(0)).type().name(), (Matcher)Matchers.equalTo((Object)"Blocks"));
    }

    public void testGetIssueLink() throws Exception {
        IssueLink issueLink = this.linkIssueClient.getIssueLink("10100");
        TestLinkIssueResource.assertEquals((String)"10100", (String)issueLink.id());
        TestLinkIssueResource.assertEquals((Object)this.getRestApiUri("issueLink/10100"), (Object)issueLink.self());
        TestLinkIssueResource.assertEquals((String)issueLink.inwardIssue().id(), (String)"10200");
        TestLinkIssueResource.assertEquals((String)issueLink.outwardIssue().id(), (String)"10201");
    }

    public void testGetIssueLinkInvalidId() throws Exception {
        Response linkIssueClientIssueLinkResponse = this.linkIssueClient.getIssueLinkResponse("32423");
        TestLinkIssueResource.assertEquals((int)404, (int)linkIssueClientIssueLinkResponse.statusCode);
        TestLinkIssueResource.assertEquals((String)"No issue link with id '32423' exists.", (String)((String)linkIssueClientIssueLinkResponse.entity.errorMessages.get(0)));
    }

    public void testGetIssueLinkWithoutPermission() throws Exception {
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).getIssueLinkResponse("10100");
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
    }

    public void testDeleteIssueLink() throws Exception {
        Response response = this.linkIssueClient.deleteIssueLink("10100");
        TestLinkIssueResource.assertEquals((int)204, (int)response.statusCode);
        Response linkIssueClientIssueLinkResponse = this.linkIssueClient.getIssueLinkResponse("10100");
        TestLinkIssueResource.assertEquals((int)404, (int)linkIssueClientIssueLinkResponse.statusCode);
        TestLinkIssueResource.assertEquals((String)"No issue link with id '10100' exists.", (String)((String)linkIssueClientIssueLinkResponse.entity.errorMessages.get(0)));
    }

    public void testDeleteIssueLinkInvalidId() throws Exception {
        Response linkIssueClientIssueLinkResponse = this.linkIssueClient.deleteIssueLink("32423");
        TestLinkIssueResource.assertEquals((int)404, (int)linkIssueClientIssueLinkResponse.statusCode);
        TestLinkIssueResource.assertEquals((String)"No issue link with id '32423' exists.", (String)((String)linkIssueClientIssueLinkResponse.entity.errorMessages.get(0)));
    }

    public void testDeleteIssueLinkWithoutPermission() throws Exception {
        Response response = ((LinkIssueClient)this.linkIssueClient.loginAs("linker")).deleteIssueLink("10100");
        TestLinkIssueResource.assertEquals((int)404, (int)response.statusCode);
    }
}

