/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.backdoor.LicenseRoleControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.LicenseRoleBeanMatcher;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestLicenseRoleResource
extends RestFuncTest {
    private static final String ROLE = "com.atlassian.jira.platform";
    private static final String USERS = "jira-users";
    private static final String DEVELOPERS = "jira-developers";
    private static final String ADMINS = "jira-administrators";
    private LicenseRoleControl roleClient;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstanceWithLicense(LicenseKeys.V2_PLATFORM_ROLE);
        this.roleClient = this.backdoor.licenseRoles();
    }

    public void testAdminHappyPath() {
        LicenseRoleControl.LicenseRoleBean roleBean = this.roleClient.getRole(ROLE);
        LicenseRoleBeanMatcher matcher = LicenseRoleBeanMatcher.forBusinessUser();
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)ROLE), (Matcher)matcher));
        roleBean = this.roleClient.putRole(ROLE, USERS, DEVELOPERS);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(USERS, DEVELOPERS));
        MatcherAssert.assertThat((Object)this.roleClient.getRole(ROLE), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)ROLE), (Matcher)matcher));
        roleBean = this.roleClient.putRoleWithPrimary(ROLE, USERS, USERS, ADMINS);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(USERS, ADMINS).setPrimaryGroup(USERS));
        MatcherAssert.assertThat((Object)this.roleClient.getRole(ROLE), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)ROLE), (Matcher)matcher));
        roleBean = this.roleClient.putRole(ROLE, new String[0]);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(new String[0]).setPrimaryGroup(null));
        MatcherAssert.assertThat((Object)this.roleClient.getRole(ROLE), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)ROLE), (Matcher)matcher));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWebsudo() {
        this.backdoor.websudo().enable();
        try {
            Object response = this.roleClient.getRoleResponse(ROLE);
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
            response = this.roleClient.getRolesResponse();
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
            response = this.roleClient.putRoleResponse(ROLE, USERS);
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
        }
        finally {
            this.backdoor.websudo().disable();
        }
    }

    public void test403ReturnedForNonAdmin() {
        Object response = ((LicenseRoleControl)this.roleClient.loginAs("fred")).getRoleResponse(ROLE);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
        response = this.roleClient.getRolesResponse();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
        response = this.roleClient.putRoleResponse(ROLE, USERS);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
    }
}

