/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.IssueTypeClient;
import com.atlassian.jira.testkit.client.restclient.IssueTypeCreateBean;
import com.atlassian.jira.testkit.client.restclient.IssueTypeUpdateBean;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueTypeResource
extends RestFuncTest {
    private static final String BUG_ISSUE_TYPE_ID = "1";
    private static final String TASK_ISSUE_TYPE_ID = "3";
    private IssueTypeClient issueTypeClient;
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.backdoor.applicationProperties().setOption("jira.option.allowsubtasks", true);
        this.issueTypeClient = new IssueTypeClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    public void testIssueTypeVisible() throws Exception {
        this.backdoor.restoreDataFromResource("TestIssueTypeResource.xml");
        IssueType issueType = this.issueTypeClient.get(TASK_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/issuetype/" + TASK_ISSUE_TYPE_ID), (String)issueType.self);
        TestIssueTypeResource.assertEquals((String)"A task that needs to be done.", (String)issueType.description);
        TestIssueTypeResource.assertEquals((String)(this.getBaseUrl() + "/images/icons/issuetypes/task.png"), (String)issueType.iconUrl);
        TestIssueTypeResource.assertEquals((String)"Task", (String)issueType.name);
        TestIssueTypeResource.assertEquals((boolean)false, (boolean)issueType.subtask);
        TestIssueTypeResource.assertEquals((String)TASK_ISSUE_TYPE_ID, (String)issueType.id);
    }

    public void testIssueTypeNotVisible() throws Exception {
        this.backdoor.restoreDataFromResource("TestIssueTypeResource.xml");
        Response response = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).getResponse(TASK_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.statusCode);
    }

    public void testIssueTypeDoesNotExist() {
        Response responseZzz = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).getResponse("zzz");
        TestIssueTypeResource.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)responseZzz.statusCode);
    }

    public void testIssueTypeResourceSupportsAbsoluteUrlInIconUrl() throws Exception {
        this.backdoor.restoreDataFromResource("TestIssueTypeResource.xml");
        IssueType response = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).get(BUG_ISSUE_TYPE_ID);
        Assert.assertThat((Object)response.iconUrl, (Matcher)CoreMatchers.equalTo((Object)"https://jira.atlassian.com/images/icons/bug.gif"));
    }

    public void testGetAllIssueTypes() throws Exception {
        List issueTypes = this.issueTypeClient.get();
        TestIssueTypeResource.assertEquals((int)4, (int)issueTypes.size());
        this.assertIssueTypesContain(issueTypes, BUG_ISSUE_TYPE_ID);
        this.assertIssueTypesContain(issueTypes, "2");
        this.assertIssueTypesContain(issueTypes, TASK_ISSUE_TYPE_ID);
        this.assertIssueTypesContain(issueTypes, "4");
    }

    public void testGetIssueTypesForUserWithRestrictedPermissionsToProjects() {
        this.backdoor.restoreDataFromResource("TestIssueTypeResource.xml");
        List issueTypes = ((IssueTypeClient)this.issueTypeClient.loginAs("fred")).get();
        TestIssueTypeResource.assertEquals((int)2, (int)issueTypes.size());
        this.assertIssueTypesContain(issueTypes, BUG_ISSUE_TYPE_ID);
        this.assertIssueTypesContain(issueTypes, "2");
    }

    public void testCreateIssueTypeSuccessful() {
        IssueTypeCreateBean issueTypeCreateBean = this.getIssueTypeCreateBean();
        IssueType issueType = this.issueTypeClient.post(issueTypeCreateBean);
        Assert.assertThat((Object)issueType, this.eq(issueTypeCreateBean));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.hasItem(this.eq(issueTypeCreateBean)));
    }

    public void testCreateIssueTypeWithAnonymousUser() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IssueTypeCreateBean issueTypeCreateBean = TestIssueTypeResource.this.getIssueTypeCreateBean();
                ((IssueTypeClient)TestIssueTypeResource.this.issueTypeClient.anonymous()).post(issueTypeCreateBean);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    public void testCreateIssueTypeWithUserWithoutAdminPermissions() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IssueTypeCreateBean issueTypeCreateBean = TestIssueTypeResource.this.getIssueTypeCreateBean();
                ((IssueTypeClient)TestIssueTypeResource.this.issueTypeClient.loginAs("fred")).post(issueTypeCreateBean);
                return null;
            }
        }, Response.Status.FORBIDDEN);
    }

    public void testCreateIssueTypeWithExistingUserName() {
        Option typeOption = Iterables.first((Iterable)this.issueTypeClient.get());
        TestIssueTypeResource.assertTrue((boolean)typeOption.isDefined());
        final IssueType issueType = (IssueType)typeOption.get();
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.post(new IssueTypeCreateBean(issueType.name, "description", IssueTypeCreateBean.Type.standard));
                return null;
            }
        }, Response.Status.CONFLICT);
    }

    public void testCreateSubTaskSuccessful() {
        IssueTypeCreateBean subTask = new IssueTypeCreateBean("name", "description", IssueTypeCreateBean.Type.subtask);
        IssueType issueType = this.issueTypeClient.post(subTask);
        Assert.assertThat((Object)issueType, this.eq(subTask));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.hasItem(this.eq(subTask)));
    }

    public void testCreateSubTaskWhenSubTasksDisabled() {
        this.backdoor.applicationProperties().setOption("jira.option.allowsubtasks", false);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.post(new IssueTypeCreateBean("name", "description", IssueTypeCreateBean.Type.subtask));
                return null;
            }
        }, Response.Status.BAD_REQUEST);
    }

    public void testCreateIssueTypeWithTooLongName() {
        final StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            stringBuilder.append("n");
        }
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.post(new IssueTypeCreateBean(stringBuilder.toString(), "description", IssueTypeCreateBean.Type.standard));
                return null;
            }
        }, Response.Status.BAD_REQUEST);
    }

    public void testCreateIssueTypeWithoutDescription() {
        IssueTypeCreateBean issueTypeCreateBean = new IssueTypeCreateBean("name", null, IssueTypeCreateBean.Type.standard);
        IssueType issueType = this.issueTypeClient.post(issueTypeCreateBean);
        Assert.assertThat((Object)issueType, this.eq(issueTypeCreateBean));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.hasItem(this.eq(issueTypeCreateBean)));
    }

    public void testIssueTypeIsStandardByDefault() {
        IssueTypeCreateBean issueTypeCreateBean = new IssueTypeCreateBean("name", "description", null);
        IssueType issueType = this.issueTypeClient.post(issueTypeCreateBean);
        TestIssueTypeResource.assertFalse((boolean)issueType.subtask);
    }

    public void testIssueTypeHasDefaultAvatarAfterCreation() {
        IssueType issueType = this.issueTypeClient.post(this.getIssueTypeCreateBean());
        String defaultIssueTypeAvatarId = this.backdoor.applicationProperties().getString("jira.avatar.issuetype.default.id");
        Assert.assertThat((Object)issueType.iconUrl, (Matcher)Matchers.containsString((String)defaultIssueTypeAvatarId));
    }

    public void testSubTaskHasDefaultAvatarAfterCreation() {
        IssueType issueType = this.issueTypeClient.post(new IssueTypeCreateBean("name", "description", IssueTypeCreateBean.Type.subtask));
        String subTaskAvatarId = this.backdoor.applicationProperties().getString("jira.avatar.issuetype.subtask.default.id");
        Assert.assertThat((Object)issueType.iconUrl, (Matcher)Matchers.containsString((String)subTaskAvatarId));
    }

    public void testDeleteIssueTypeWithoutProvidingAlternative() {
        IssueType issueType = this.issueTypeClient.get(BUG_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((String)"Bug", (String)issueType.name);
        SearchResult searchResult = this.backdoor.search().getSearch(new SearchRequest().jql("issuetype = Bug"));
        Assert.assertThat((String)"There are issues with issuetype = Bug which requires passing alternative id", (Object)searchResult.issues, (Matcher)Matchers.emptyIterable());
        this.issueTypeClient.delete(BUG_ISSUE_TYPE_ID, Option.none(String.class));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.not((Matcher)Matchers.hasItem(this.issueTypeNameEq("Bug"))));
    }

    public void testDeleteIssueTypeWithAlternative() {
        IssueType issueType = this.issueTypeClient.get(BUG_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((String)"Bug", (String)issueType.name);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new bug");
        Assert.assertThat((Object)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype, (Matcher)Matchers.is(this.issueTypeNameEq("Bug")));
        List alternatives = this.issueTypeClient.getAlternatives(BUG_ISSUE_TYPE_ID);
        Assert.assertThat((Object)alternatives, (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
        IssueType alternative = (IssueType)Iterables.first((Iterable)alternatives).get();
        this.issueTypeClient.delete(BUG_ISSUE_TYPE_ID, Option.some((Object)alternative.id));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.not((Matcher)Matchers.hasItem(this.issueTypeNameEq("Bug"))));
        Assert.assertThat((Object)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype, (Matcher)Matchers.is(this.issueTypeNameEq(alternative.name)));
    }

    public void testDeleteIssueWithInvalidAlternative() {
        final IssueType issueType = this.issueTypeClient.get(BUG_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((String)"Bug", (String)issueType.name);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new bug");
        Assert.assertThat((Object)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype, (Matcher)Matchers.is(this.issueTypeNameEq("Bug")));
        final IssueType subtask = this.issueTypeClient.post(new IssueTypeCreateBean("subtask", "description", IssueTypeCreateBean.Type.subtask));
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.delete(issueType.id, Option.some((Object)subtask.id));
                return null;
            }
        }, Response.Status.CONFLICT);
    }

    public void testDeleteIssueWithSelfAsAlternative() {
        final IssueType issueType = this.issueTypeClient.get(BUG_ISSUE_TYPE_ID);
        TestIssueTypeResource.assertEquals((String)"Bug", (String)issueType.name);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "new bug");
        Assert.assertThat((Object)this.issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype, (Matcher)Matchers.is(this.issueTypeNameEq("Bug")));
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.delete(issueType.id, Option.some((Object)issueType.id));
                return null;
            }
        }, Response.Status.CONFLICT);
    }

    public void testDeleteIssueTypeWithInvalidUser() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((IssueTypeClient)TestIssueTypeResource.this.issueTypeClient.loginAs("fred")).delete(TestIssueTypeResource.BUG_ISSUE_TYPE_ID, Option.none(String.class));
                return null;
            }
        }, Response.Status.FORBIDDEN);
    }

    public void testDeleteIssueTypeWithAnonymousUser() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((IssueTypeClient)TestIssueTypeResource.this.issueTypeClient.anonymous()).delete(TestIssueTypeResource.BUG_ISSUE_TYPE_ID, Option.none(String.class));
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    public void testDeleteIssueTypeWithAssociatedIssuesWithoutAlternative() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IssueCreateResponse issue = TestIssueTypeResource.this.backdoor.issues().createIssue("HSP", "some bug");
                Assert.assertThat((Object)((TestIssueTypeResource)TestIssueTypeResource.this).issueClient.get((String)issue.key, (Issue.Expand[])new Issue.Expand[0]).fields.issuetype, (Matcher)Matchers.is((Matcher)TestIssueTypeResource.this.issueTypeNameEq("Bug")));
                List alternatives = TestIssueTypeResource.this.issueTypeClient.getAlternatives(TestIssueTypeResource.BUG_ISSUE_TYPE_ID);
                for (IssueType alternative : alternatives) {
                    TestIssueTypeResource.this.issueTypeClient.delete(alternative.id, Option.none());
                }
                TestIssueTypeResource.this.issueTypeClient.delete(TestIssueTypeResource.BUG_ISSUE_TYPE_ID, Option.none());
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    public void testDeleteNotExistingIssueType() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.delete("150", Option.none());
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    public void testUpdatingIssueTypeName() {
        IssueTypeUpdateBean bug2 = new IssueTypeUpdateBean("Bug2", "new bug description", null);
        IssueType updatedIssueType = this.issueTypeClient.update(BUG_ISSUE_TYPE_ID, bug2);
        Assert.assertThat((Object)updatedIssueType, this.eq(bug2));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.hasItem(this.eq(bug2)));
    }

    public void testUpdateIssueTypeDescriptionWithKeepingOldName() {
        IssueTypeUpdateBean bug = new IssueTypeUpdateBean("Bug", "new bug description", null);
        IssueType issueType = this.issueTypeClient.update(BUG_ISSUE_TYPE_ID, bug);
        Assert.assertThat((Object)issueType, this.eq(bug));
        Assert.assertThat((Object)this.issueTypeClient.get(), (Matcher)Matchers.hasItem(this.eq(bug)));
    }

    public void testUpdateAvatarId() {
        IssueType newIssueType = this.issueTypeClient.post(new IssueTypeCreateBean("new issue type", "description", IssueTypeCreateBean.Type.standard));
        IssueType update = this.issueTypeClient.update(BUG_ISSUE_TYPE_ID, new IssueTypeUpdateBean(null, null, newIssueType.avatarId));
        TestIssueTypeResource.assertEquals((Object)newIssueType.avatarId, (Object)update.avatarId);
        TestIssueTypeResource.assertEquals((String)update.name, (String)"Bug");
    }

    public void testCantChangeNameToTheExistingOne() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.update("2", new IssueTypeUpdateBean("Bug", "bug", null));
                return null;
            }
        }, Response.Status.CONFLICT);
    }

    public void testCantUpdateWithAnonymousUser() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((IssueTypeClient)TestIssueTypeResource.this.issueTypeClient.anonymous()).update(TestIssueTypeResource.BUG_ISSUE_TYPE_ID, new IssueTypeUpdateBean("name", "name", null));
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    public void testCantUpdateWithUserWithoutAdminRight() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((IssueTypeClient)TestIssueTypeResource.this.issueTypeClient.loginAs("fred")).update(TestIssueTypeResource.BUG_ISSUE_TYPE_ID, new IssueTypeUpdateBean("name", "name", null));
                return null;
            }
        }, Response.Status.FORBIDDEN);
    }

    public void testCantSetAvatarToNonExistingOne() {
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestIssueTypeResource.this.issueTypeClient.update(TestIssueTypeResource.BUG_ISSUE_TYPE_ID, new IssueTypeUpdateBean(null, null, Long.valueOf(100L)));
                return null;
            }
        }, Response.Status.BAD_REQUEST);
    }

    private IssueTypeCreateBean getIssueTypeCreateBean() {
        return new IssueTypeCreateBean("name", "description", IssueTypeCreateBean.Type.standard);
    }

    private Matcher<IssueType> issueTypeNameEq(final String name) {
        return new TypeSafeMatcher<IssueType>(){

            protected boolean matchesSafely(IssueType issueType) {
                return name.equals(issueType.name);
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"Issue type with name").appendValue((Object)"name").appendText("does not match");
            }
        };
    }

    private Matcher<IssueType> eq(final IssueTypeUpdateBean issueTypeUpdateBean) {
        return new TypeSafeMatcher<IssueType>(){

            protected boolean matchesSafely(IssueType issueType) {
                return issueType.name.equals(issueTypeUpdateBean.getName()) && issueType.description.equals(issueTypeUpdateBean.getDescription());
            }

            public void describeTo(Description description) {
                description.appendText("Issue type does not match").appendValue((Object)issueTypeUpdateBean);
            }
        };
    }

    private Matcher<IssueType> eq(final IssueTypeCreateBean issueTypeCreateBean) {
        return new TypeSafeMatcher<IssueType>(){

            protected boolean matchesSafely(IssueType issueType) {
                return issueType.name.equals(issueTypeCreateBean.getName()) && issueType.description.equals(issueTypeCreateBean.getDescription()) && issueType.subtask ? issueTypeCreateBean.getType().equals((Object)IssueTypeCreateBean.Type.subtask) : issueTypeCreateBean.getType().equals((Object)IssueTypeCreateBean.Type.standard);
            }

            public void describeTo(Description description) {
                description.appendText("Issue type does not match").appendValue((Object)issueTypeCreateBean);
            }
        };
    }

    private void assertIssueTypesContain(List<IssueType> issueTypes, final String id) {
        Assert.assertThat(issueTypes, (Matcher)Matchers.hasItem((Matcher)new TypeSafeMatcher<IssueType>(){

            protected boolean matchesSafely(IssueType issueType) {
                return issueType.id.equals(id);
            }

            public void describeTo(Description description) {
                description.appendText("THe list does not contain property with id").appendValue((Object)id);
            }
        }));
    }
}

