/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.sun.jersey.api.client.WebResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueShape
extends RestFuncTest {
    private IssueClient issueClient;
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d\\d\\d\\d-\\d\\d-\\d\\d$");
    private static final Pattern DATETIME_PATTERN = Pattern.compile("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d[+-]\\d\\d\\d\\d$");

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    public void testGeneralShape() {
        this.administration.restoreData("TestIssueShape.xml");
        WebResource resource = this.issueClient.issueResource("TST-1", new Issue.Expand[0]);
        Object json = resource.get(Object.class);
        Map<String, ?> fields = this.asObject(this.getAt(json, "fields"));
        TestIssueShape.assertEquals((String)"A critical bug", (String)this.asString(this.getAt(fields, "summary")));
        TestIssueShape.assertEquals((String)"blah", (String)this.asString(this.getAt(fields, "description")));
        TestIssueShape.assertEquals((String)"1", (String)this.asString(this.getAt(fields, "issuetype", "id")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "issuetype", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/issuetype/1"));
        TestIssueShape.assertEquals((String)"A problem which impairs or prevents the functions of the product.", (String)this.asString(this.getAt(fields, "issuetype", "description")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "issuetype", "iconUrl")), (Matcher)Matchers.endsWith((String)"/images/icons/issuetypes/bug.png"));
        TestIssueShape.assertEquals((String)"Bug", (String)this.asString(this.getAt(fields, "issuetype", "name")));
        TestIssueShape.assertEquals((boolean)false, (boolean)this.asBoolean(this.getAt(fields, "issuetype", "subtask")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "votes", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/issue/TST-1/votes"));
        TestIssueShape.assertEquals((Object)0, (Object)this.asNumber(this.getAt(fields, "votes", "votes")));
        TestIssueShape.assertEquals((boolean)false, (boolean)this.asBoolean(this.getAt(fields, "votes", "hasVoted")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "security", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/securitylevel/10001"));
        TestIssueShape.assertEquals((String)"10001", (String)this.asString(this.getAt(fields, "security", "id")));
        TestIssueShape.assertEquals((String)"", (String)this.asString(this.getAt(fields, "security", "description")));
        TestIssueShape.assertEquals((String)"lvl2", (String)this.asString(this.getAt(fields, "security", "name")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "fixVersions", 0, "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/version/10001"));
        TestIssueShape.assertEquals((String)"10001", (String)this.asString(this.getAt(fields, "fixVersions", 0, "id")));
        TestIssueShape.assertEquals((String)"", (String)this.asString(this.getAt(fields, "fixVersions", 0, "description")));
        TestIssueShape.assertEquals((String)"v2", (String)this.asString(this.getAt(fields, "fixVersions", 0, "name")));
        TestIssueShape.assertEquals((String)"2011-09-23", (String)this.asDateString(this.getAt(fields, "fixVersions", 0, "releaseDate")));
        TestIssueShape.assertEquals((boolean)false, (boolean)this.asBoolean(this.getAt(fields, "fixVersions", 0, "archived")));
        TestIssueShape.assertEquals((boolean)false, (boolean)this.asBoolean(this.getAt(fields, "fixVersions", 0, "released")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "resolution", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/resolution/1"));
        TestIssueShape.assertEquals((String)"1", (String)this.asString(this.getAt(fields, "resolution", "id")));
        TestIssueShape.assertEquals((String)"A fix for this issue is checked into the tree and tested.", (String)this.asString(this.getAt(fields, "resolution", "description")));
        TestIssueShape.assertEquals((String)"Fixed", (String)this.asString(this.getAt(fields, "resolution", "name")));
        TestIssueShape.assertEquals((Object)this.asDateTime("2011-07-27T12:56:01.847+1000"), (Object)this.asDateTime(this.getAt(fields, "resolutiondate")));
        TestIssueShape.assertEquals((Object)this.asDateTime("2011-06-29T16:40:56.287+1000"), (Object)this.asDateTime(this.getAt(fields, "created")));
        TestIssueShape.assertEquals((Object)this.asDateTime("2011-09-23T10:33:34.794+1000"), (Object)this.asDateTime(this.getAt(fields, "updated")));
        TestIssueShape.assertEquals((String)"2012-02-29", (String)this.asDateString(this.getAt(fields, "duedate")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "reporter", "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/user?username=fry"));
        TestIssueShape.assertEquals((String)"fry", (String)this.asString(this.getAt(fields, "reporter", "name")));
        TestIssueShape.assertEquals((String)"fry@example.com", (String)this.asString(this.getAt(fields, "reporter", "emailAddress")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "reporter", "avatarUrls", "16x16")), (Matcher)Matchers.endsWith((String)"/secure/useravatar?size=xsmall&avatarId=10062"));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "reporter", "avatarUrls", "48x48")), (Matcher)Matchers.endsWith((String)"/secure/useravatar?avatarId=10062"));
        TestIssueShape.assertEquals((String)"Phillip J. Fry", (String)this.asString(this.getAt(fields, "reporter", "displayName")));
        TestIssueShape.assertEquals((boolean)true, (boolean)this.asBoolean(this.getAt(fields, "reporter", "active")));
        TestIssueShape.assertEquals((String)"bar", (String)this.asString(this.getAt(fields, "labels", 0)));
        TestIssueShape.assertEquals((String)"foo", (String)this.asString(this.getAt(fields, "labels", 1)));
        TestIssueShape.assertEquals((Object)0, (Object)this.asNumber(this.getAt(fields, "comment", "startAt")));
        TestIssueShape.assertEquals((Object)1, (Object)this.asNumber(this.getAt(fields, "comment", "maxResults")));
        TestIssueShape.assertEquals((Object)1, (Object)this.asNumber(this.getAt(fields, "comment", "total")));
        Assert.assertThat((Object)this.asString(this.getAt(fields, "comment", "comments", 0, "self")), (Matcher)Matchers.endsWith((String)"/rest/api/2/issue/10000/comment/10000"));
        TestIssueShape.assertEquals((String)"10000", (String)this.asString(this.getAt(fields, "comment", "comments", 0, "id")));
        TestIssueShape.assertEquals((String)"foo", (String)this.asString(this.getAt(fields, "comment", "comments", 0, "body")));
        TestIssueShape.assertEquals((Object)this.asDateTime("2011-09-23T10:33:16.309+1000"), (Object)this.asDateTime(this.getAt(fields, "comment", "comments", 0, "created")));
        TestIssueShape.assertEquals((Object)this.asDateTime("2011-09-23T10:33:16.309+1000"), (Object)this.asDateTime(this.getAt(fields, "comment", "comments", 0, "updated")));
        TestIssueShape.assertEquals((String)"admin", (String)this.asString(this.getAt(fields, "comment", "comments", 0, "author", "name")));
        TestIssueShape.assertEquals((String)"admin", (String)this.asString(this.getAt(fields, "comment", "comments", 0, "updateAuthor", "name")));
    }

    private Object getAt(Object o, Object ... path) {
        for (Object key : path) {
            if (key instanceof String) {
                String s = (String)key;
                Map<String, ?> obj = this.asObject(o);
                TestIssueShape.assertTrue((String)(s + " in " + obj), (boolean)obj.containsKey(s));
                o = obj.get(s);
                continue;
            }
            if (key instanceof Integer) {
                int i = (Integer)key;
                List<?> array = this.asArray(o);
                TestIssueShape.assertTrue((String)(i + " indexed into " + array), (0 <= i && i < array.size() ? 1 : 0) != 0);
                o = array.get(i);
                continue;
            }
            TestIssueShape.fail((String)("unknown key type " + key));
        }
        return o;
    }

    private Map<String, ?> asObject(Object o) {
        TestIssueShape.assertTrue((boolean)(o instanceof Map));
        return (Map)o;
    }

    private List<?> asArray(Object o) {
        TestIssueShape.assertTrue((boolean)(o instanceof List));
        return (List)o;
    }

    private String asString(Object o) {
        TestIssueShape.assertTrue((boolean)(o instanceof String));
        return (String)o;
    }

    private String asDateString(Object o) {
        String s = this.asString(o);
        TestIssueShape.assertTrue((String)s, (boolean)DATE_PATTERN.matcher(s).matches());
        return s;
    }

    private Date asDateTime(Object o) {
        String s = this.asString(o);
        TestIssueShape.assertTrue((String)s, (boolean)DATETIME_PATTERN.matcher(s).matches());
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(s);
        }
        catch (ParseException e) {
            TestIssueShape.fail((String)e.getMessage());
            return null;
        }
    }

    private boolean asBoolean(Object o) {
        TestIssueShape.assertTrue((boolean)(o instanceof Boolean));
        return (Boolean)o;
    }

    private Number asNumber(Object o) {
        TestIssueShape.assertTrue((boolean)(o instanceof Number));
        return (Number)o;
    }
}

