/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueSecurityType;
import com.atlassian.jira.testkit.client.restclient.IssueSecurityTypeClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueSecurityTypeResource
extends RestFuncTest {
    private static final String SECURITY_TYPE_ID = "10000";
    private IssueSecurityTypeClient securityTypeClient;

    public void testSecurityTypeVisible() throws Exception {
        IssueSecurityType securityType = this.securityTypeClient.get(SECURITY_TYPE_ID);
        TestIssueSecurityTypeResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2/securitylevel/" + SECURITY_TYPE_ID), (String)securityType.self);
        TestIssueSecurityTypeResource.assertEquals((String)"Only the good guys can see this", (String)securityType.description);
        TestIssueSecurityTypeResource.assertEquals((String)"Secure", (String)securityType.name);
        TestIssueSecurityTypeResource.assertEquals((String)SECURITY_TYPE_ID, (String)securityType.id);
    }

    public void testSecurityTypeNotFound() throws Exception {
        Response response = ((IssueSecurityTypeClient)this.securityTypeClient.loginAs("fred")).getResponse("zzz");
        TestIssueSecurityTypeResource.assertEquals((int)404, (int)response.statusCode);
        TestIssueSecurityTypeResource.assertTrue((boolean)response.entity.errorMessages.contains("The security level with id 'zzz' does not exist."));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.securityTypeClient = new IssueSecurityTypeClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestIssueSecurityTypeResource.xml");
    }
}

