/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.VotesClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceVotes
extends RestFuncTest {
    String issueKey;
    String issueREST;
    private VotesClient votesClient;
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.votesClient = new VotesClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreBlankInstance();
        this.issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.issueREST = String.format("/rest/api/2/issue/%s", this.issueKey);
        this.navigation.login("fred");
        this.navigation.issue().voteIssue(this.issueKey);
        this.navigation.login("admin");
    }

    public void testVote_issueDoesNotExist() throws Exception {
        Response response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse("HSP-204");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    public void testVote_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        this.backdoor.usersAndGroups().addUser("barney");
        Response response = ((VotesClient)this.votesClient.loginAs("barney")).deleteResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("Voting for issues is currently not enabled for this JIRA instance."));
    }

    public void testVote_reporter() throws Exception {
        Response response = this.votesClient.postResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("You cannot vote for an issue you have reported."));
        TestIssueResourceVotes.assertEquals((int)1, (int)this.getVotes());
        TestIssueResourceVotes.assertFalse((boolean)this.i_voted());
    }

    public void testVote_successful() throws Exception {
        this.backdoor.usersAndGroups().addUser("barney");
        Response response = ((VotesClient)this.votesClient.loginAs("barney")).postResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)204, (int)response.statusCode);
        TestIssueResourceVotes.assertEquals((int)2, (int)this.getVotes());
        TestIssueResourceVotes.assertTrue((boolean)this.i_voted("barney"));
    }

    public void testViewVoters_issueDoesNotExist() throws Exception {
        Response response = this.votesClient.getResponse("HSP-55");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    public void testViewVoters_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        Response response = this.votesClient.getResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("Voting for issues is currently not enabled for this JIRA instance."));
    }

    public void testViewVoters_noPermission() throws Exception {
        Vote vote = ((VotesClient)this.votesClient.loginAs("fred")).get(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)1, (int)vote.votes);
        TestIssueResourceVotes.assertEquals((int)0, (int)vote.voters.size());
    }

    public void testViewVoters_successful() throws Exception {
        Vote voters = this.votesClient.get(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)1, (int)voters.votes);
        User user = (User)voters.voters.get(0);
        TestIssueResourceVotes.assertNotNull((Object)user.self);
        TestIssueResourceVotes.assertEquals((String)"fred", (String)user.name);
        TestIssueResourceVotes.assertEquals((String)"Fred Normal", (String)user.displayName);
    }

    public void testUnvote_issueDoesNotExist() throws Exception {
        Response response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse("HSP-204");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("Issue Does Not Exist"));
    }

    public void testUnvote_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        Response response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("Voting for issues is currently not enabled for this JIRA instance."));
    }

    public void testUnvote_reporter() throws Exception {
        Response response = this.votesClient.deleteResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)404, (int)response.statusCode);
        TestIssueResourceVotes.assertTrue((boolean)response.entity.errorMessages.contains("You cannot vote for an issue you have reported."));
        TestIssueResourceVotes.assertEquals((int)1, (int)this.getVotes());
    }

    public void testUnvote_successful() throws Exception {
        Response response = ((VotesClient)this.votesClient.loginAs("fred")).deleteResponse(this.issueKey);
        TestIssueResourceVotes.assertEquals((int)204, (int)response.statusCode);
        TestIssueResourceVotes.assertEquals((int)0, (int)this.getVotes());
        TestIssueResourceVotes.assertFalse((boolean)this.i_voted("fred"));
    }

    private int getVotes() {
        return this.issueClient.get((String)this.issueKey, (Issue.Expand[])new Issue.Expand[0]).fields.votes.votes;
    }

    private boolean i_voted() {
        return this.i_voted(null);
    }

    private boolean i_voted(String user) {
        Issue issue = user != null ? ((IssueClient)this.issueClient.loginAs(user)).get(this.issueKey, new Issue.Expand[0]) : this.issueClient.get(this.issueKey, new Issue.Expand[0]);
        return issue.fields.votes.hasVoted;
    }
}

