/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Vote;
import com.atlassian.jira.testkit.client.restclient.VotesClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceVoters
extends RestFuncTest {
    private static final String ISSUE_KEY = "TP-1";
    private static final String USER_NOT_SELECTED_ON_USER_PICKER = "admin";
    private static final String USER_SELECTED_ON_USER_PICKER = "test";
    private VotesClient votesClient;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.votesClient = new VotesClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.restoreJiraWithVotedIssueInProjectWhereVotersCanOnlyBeSeenByUserSpecifiedOnUserPicker();
    }

    public void testVotersCanNotBeReadByADifferentUserThanTheOneSpecifiedOnTheUserPickerCustomField() {
        this.votesClient.loginAs(USER_NOT_SELECTED_ON_USER_PICKER);
        Vote vote = this.votesClient.get(ISSUE_KEY);
        TestIssueResourceVoters.assertTrue((boolean)vote.voters.isEmpty());
    }

    public void testVotersCanBeReadByTheUserThatIsSpecifiedOnTheUserPickerCustomField() {
        this.votesClient.loginAs(USER_SELECTED_ON_USER_PICKER);
        Vote vote = this.votesClient.get(ISSUE_KEY);
        Assert.assertThat((Object)vote.voters.size(), (Matcher)Is.is((Object)1));
    }

    private void restoreJiraWithVotedIssueInProjectWhereVotersCanOnlyBeSeenByUserSpecifiedOnUserPicker() {
        this.administration.restoreData("TestIssueResourceVoters.xml");
    }
}

