/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.rest.api.issue.TimeTracking;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.type.TypeReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceUpdate
extends RestFuncTest {
    private IssueClient issueClient;

    public void testEditAllSystemFields() throws Exception {
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        Assert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withId((String)"2")).reporter(ResourceRef.withName((String)"fry")).assignee(ResourceRef.withName((String)"farnsworth")).labels(Arrays.asList("foo", "bar")).timeTracking(new TimeTracking("20m", "20m")).securityLevel(ResourceRef.withId((String)"10001")).versions(new ResourceRef[]{ResourceRef.withId((String)"10001")}).environment("edited environment").description("edited description").dueDate("2012-03-01").fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10001")}).components(new ResourceRef[]{ResourceRef.withId((String)"10001")}).resolution(ResourceRef.withId((String)"2")));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id())));
        Assert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().priority().id()));
        Assert.assertThat((Object)updated.fields.reporter.name, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().reporter().name()));
        Assert.assertThat((Object)updated.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().assignee().name()));
        Assert.assertThat((Object)Sets.newHashSet((Iterable)updated.fields.labels), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)Sets.newHashSet((Iterable)original.fields.labels))));
        Assert.assertThat((Object)Sets.newHashSet((Iterable)updated.fields.labels), (Matcher)CoreMatchers.equalTo((Object)Sets.newHashSet((Iterable)updateRequest.fields().labels())));
        Assert.assertThat((Object)updated.fields.timetracking, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.timetracking)));
        Assert.assertThat((Object)updated.fields.timetracking.originalEstimate, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().timeTracking().originalEstimate));
        Assert.assertThat((Object)updated.fields.timetracking.remainingEstimate, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().timeTracking().remainingEstimate));
        Assert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.security)));
        Assert.assertThat((Object)updated.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl2"));
        Assert.assertThat((Object)updated.fields.versions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.versions)));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)updated.fields.environment, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.environment)));
        Assert.assertThat((Object)updated.fields.environment, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().environment()));
        Assert.assertThat((Object)updated.fields.description, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.description)));
        Assert.assertThat((Object)updated.fields.description, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().description()));
        Assert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.duedate)));
        Assert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().dueDate()));
        Assert.assertThat((Object)updated.fields.fixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.fixVersions)));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)updated.fields.components, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.components)));
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
        Assert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.resolution.id)));
        Assert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.equalTo((Object)updateRequest.fields().resolution().id()));
    }

    public void testEditSystemFieldsByName() throws Exception {
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        Assert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().securityLevel(ResourceRef.withName((String)"lvl2")).priority(ResourceRef.withName((String)"Critical")).versions(new ResourceRef[]{ResourceRef.withName((String)"v2")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"v2")}).components(new ResourceRef[]{ResourceRef.withName((String)"comp2")}).resolution(ResourceRef.withName((String)"Duplicate")));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.security)));
        Assert.assertThat((Object)updated.fields.security.name, (Matcher)CoreMatchers.equalTo((Object)"lvl2"));
        Assert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id())));
        Assert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        Assert.assertThat((Object)updated.fields.versions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.versions)));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)updated.fields.fixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.fixVersions)));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)updated.fields.components, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.components)));
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
        Assert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.resolution.id)));
        Assert.assertThat((Object)updated.fields.resolution.id, (Matcher)CoreMatchers.equalTo((Object)"3"));
    }

    public void testEditSystemFieldsByNameAndId() throws Exception {
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        Assert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withName((String)"Critical")).versions(new ResourceRef[]{ResourceRef.withName((String)"v1"), ResourceRef.withName((String)"v2")}).fixVersions(new ResourceRef[]{ResourceRef.withId((String)"10000"), ResourceRef.withName((String)"v2")}).components(new ResourceRef[]{ResourceRef.withId((String)"10000"), ResourceRef.withName((String)"comp2")}));
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.priority.id())));
        Assert.assertThat((Object)updated.fields.priority.id(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        Assert.assertThat((Object)updated.fields.versions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.versions)));
        Assert.assertThat((Object)updated.fields.versions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)((Version)updated.fields.versions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)updated.fields.fixVersions, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.fixVersions)));
        Assert.assertThat((Object)updated.fields.fixVersions.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"v1"));
        Assert.assertThat((Object)((Version)updated.fields.fixVersions.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"v2"));
        Assert.assertThat((Object)updated.fields.components, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.components)));
        Assert.assertThat((Object)updated.fields.components.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)0)).name, (Matcher)CoreMatchers.equalTo((Object)"comp1"));
        Assert.assertThat((Object)((Component)updated.fields.components.get((int)1)).name, (Matcher)CoreMatchers.equalTo((Object)"comp2"));
    }

    public void testEditSystemFieldsInvalidData() throws Exception {
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        Assert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        IssueUpdateRequest updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withName((String)"BadPriority")).versions(new ResourceRef[]{ResourceRef.withName((String)"v1Bad")}).fixVersions(new ResourceRef[]{ResourceRef.withName((String)"v2Bad")}).components(new ResourceRef[]{ResourceRef.withName((String)"comp1Bad")}).resolution(ResourceRef.withName((String)"BadResolution")).dueDate("2001-01-XV"));
        Response response = this.issueClient.updateResponse(original.id, updateRequest);
        TestIssueResourceUpdate.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceUpdate.assertEquals((String)"Priority name 'BadPriority' is not valid", (String)((String)response.entity.errors.get("priority")));
        TestIssueResourceUpdate.assertEquals((String)"Resolution name 'BadResolution' is not valid", (String)((String)response.entity.errors.get("resolution")));
        TestIssueResourceUpdate.assertEquals((String)"Component name 'comp1Bad' is not valid", (String)((String)response.entity.errors.get("components")));
        TestIssueResourceUpdate.assertEquals((String)"Version name 'v1Bad' is not valid", (String)((String)response.entity.errors.get("versions")));
        TestIssueResourceUpdate.assertEquals((String)"Version name 'v2Bad' is not valid", (String)((String)response.entity.errors.get("fixVersions")));
        TestIssueResourceUpdate.assertEquals((String)"Error parsing date string: 2001-01-XV", (String)((String)response.entity.errors.get("duedate")));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().priority(ResourceRef.withRubbish((String)"BadPriority")));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        TestIssueResourceUpdate.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceUpdate.assertEquals((String)"Could not find valid 'id' or 'name' in priority object.", (String)((String)response.entity.errors.get("priority")));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().resolution(ResourceRef.withRubbish((String)"badResolution")));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        TestIssueResourceUpdate.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceUpdate.assertEquals((String)"Could not find valid 'id' or 'name' in resolution object.", (String)((String)response.entity.errors.get("resolution")));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().versions(new ResourceRef[]{ResourceRef.withRubbish((String)"v1Bad")}).fixVersions(new ResourceRef[]{ResourceRef.withRubbish((String)"v2Bad")}).components(new ResourceRef[]{ResourceRef.withRubbish((String)"comp1Bad")}));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        TestIssueResourceUpdate.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceUpdate.assertEquals((String)"Component/s is required.", (String)((String)response.entity.errors.get("components")));
        TestIssueResourceUpdate.assertEquals((String)"Affects Version/s is required.", (String)((String)response.entity.errors.get("versions")));
        TestIssueResourceUpdate.assertEquals((String)"Fix Version/s is required.", (String)((String)response.entity.errors.get("fixVersions")));
        updateRequest = new IssueUpdateRequest().fields(new IssueFields().resolution(ResourceRef.withId((String)"")));
        response = this.issueClient.updateResponse(original.id, updateRequest);
        TestIssueResourceUpdate.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceUpdate.assertEquals((String)"Could not find valid 'id' or 'name' in resolution object.", (String)((String)response.entity.errors.get("resolution")));
    }

    public void testEditSystemFieldsSetNull() throws Exception {
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        Issue original = this.issueClient.get("TST-1", new Issue.Expand[0]);
        IssueUpdateRequest updateSummaryRequest = new IssueUpdateRequest().fields(new IssueFields().summary("issue that i'm about to edit"));
        this.issueClient.update(original.id, updateSummaryRequest);
        Assert.assertThat((Object)this.issueClient.get((String)original.key, (Issue.Expand[])new Issue.Expand[0]).fields.summary, (Matcher)CoreMatchers.equalTo((Object)updateSummaryRequest.fields().summary()));
        HashMap updateRequest = new HashMap();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("security", null);
        fields.put("duedate", null);
        updateRequest.put("fields", fields);
        Response response = this.issueClient.update(original.id, updateRequest);
        TestIssueResourceUpdate.assertEquals((int)400, (int)response.statusCode);
        TestIssueResourceUpdate.assertEquals((String)"Security Level is required.", (String)((String)response.entity.errors.get("security")));
        TestIssueResourceUpdate.assertEquals((String)"Due Date is required.", (String)((String)response.entity.errors.get("duedate")));
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Security Level");
        this.administration.fieldConfigurations().defaultFieldConfiguration().optionalField("Due Date");
        this.issueClient.update(original.id, updateRequest);
        Issue updated = this.issueClient.get(original.key, new Issue.Expand[0]);
        Assert.assertThat((Object)updated.self, (Matcher)CoreMatchers.equalTo((Object)original.self));
        Assert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.security)));
        Assert.assertThat((Object)updated.fields.security, (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)original.fields.duedate)));
        Assert.assertThat((Object)updated.fields.duedate, (Matcher)CoreMatchers.equalTo(null));
    }

    public void testEditGroupCustomFields() throws Exception {
        this.administration.restoreData("TestCreateIssueWithRequiredSystemFields.xml");
        String TST_1 = "TST-1";
        Group jira_developers = new Group().name("jira-developers").self(URI.create(this.getBaseUrlPlus("rest/api/2/group?groupname=jira-developers")));
        Group jira_users = new Group().name("jira-users").self(URI.create(this.getBaseUrlPlus("rest/api/2/group?groupname=jira-users")));
        String picker = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", "single group");
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(picker, new FieldOperation[]{new FieldOperation("set", (Object)jira_developers)}));
        Group group = (Group)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(picker, Group.class);
        Assert.assertThat((Object)group, (Matcher)CoreMatchers.equalTo((Object)jira_developers));
        String multiPicker = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", "many groups");
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(multiPicker, new FieldOperation[]{new FieldOperation("set", Arrays.asList(jira_users, jira_developers))}));
        List groups = (List)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(multiPicker, (TypeReference)new TypeReference<List<Group>>(){});
        Assert.assertThat((Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)groups, (Matcher)Matchers.hasItems((Object[])new Group[]{jira_users, jira_developers}));
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(multiPicker, new FieldOperation[]{new FieldOperation("remove", (Object)jira_users)}));
        groups = (List)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(multiPicker, (TypeReference)new TypeReference<List<Group>>(){});
        Assert.assertThat((Object)groups, (Matcher)CoreMatchers.equalTo(Arrays.asList(jira_developers)));
        this.issueClient.edit("TST-1", new IssueUpdateRequest().update(multiPicker, new FieldOperation[]{new FieldOperation("add", (Object)jira_users)}));
        groups = (List)this.issueClient.get((String)"TST-1", (Issue.Expand[])new Issue.Expand[0]).fields.get(multiPicker, (TypeReference)new TypeReference<List<Group>>(){});
        Assert.assertThat((Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)groups, (Matcher)Matchers.hasItems((Object[])new Group[]{jira_users, jira_developers}));
    }

    public void testEditWithMetadata() throws Exception {
        this.administration.restoreBlankInstance();
        this.backdoor.project().addProject("UPDATE", "UPDATE", "admin");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("UPDATE", "summary");
        this.issueClient.edit(issue.key(), new IssueUpdateRequest().fields(new IssueFields().summary("newmmary")).historyMetadata(HistoryMetadata.builder((String)"updateMetadataTest").build()));
        JsonNode metadata = this.backdoor.issueNavControl().getHistoryMetadata(issue.key).get(0);
        Assert.assertThat((Object)metadata.get("type").asText(), (Matcher)CoreMatchers.equalTo((Object)"updateMetadataTest"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

