/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.TransitionsClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceTransitions
extends RestFuncTest {
    private IssueClient issueClient;
    private TransitionsClient transitionsClient;

    public void testTransitionLink() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.transitions});
        TestIssueResourceTransitions.assertEquals((int)3, (int)issue.transitions.size());
    }

    public void testCustomFieldInTransition() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        IssueTransitionsMeta transitions = this.transitionsClient.get("HSP-1");
        Map fields = ((IssueTransitionsMeta.Transition)transitions.transitions.get((int)2)).fields;
        for (Map.Entry field : fields.entrySet()) {
            if (!((String)field.getKey()).equals("customfield_10000")) continue;
            TestIssueResourceTransitions.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:float", (String)((IssueTransitionsMeta.TransitionField)field.getValue()).schema.custom);
        }
    }

    public void testNumberCustomFieldLocalized() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        this.navigation.userProfile().changeUserLanguage("fran\u00e7ais (France)");
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(ResourceRef.withId((String)"2"));
        issueUpdateRequest.fields().resolution(new ResourceRef().name("Duplicate"));
        issueUpdateRequest.fields().customField(Long.valueOf(10000L), (Object)2.5);
        Response response = this.transitionsClient.postResponse("HSP-1", issueUpdateRequest);
        TestIssueResourceTransitions.assertEquals((int)204, (int)response.statusCode);
        this.navigation.userProfile().changeUserLanguageToJiraDefault();
    }

    public void testIssueTransitionDestination() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        IssueTransitionsMeta transitions = this.transitionsClient.get("HSP-1");
        TestIssueResourceTransitions.assertEquals((int)3, (int)transitions.transitions.size());
        int mask = 0;
        for (IssueTransitionsMeta.Transition transition : transitions.transitions) {
            switch (transition.id) {
                case 2: {
                    TestIssueResourceTransitions.assertEquals((String)transition.to.id(), (String)"6");
                    mask = (byte)(mask | 1);
                    break;
                }
                case 4: {
                    TestIssueResourceTransitions.assertEquals((String)transition.to.id(), (String)"3");
                    mask = (byte)(mask | 2);
                    break;
                }
                case 5: {
                    TestIssueResourceTransitions.assertEquals((String)transition.to.id(), (String)"5");
                    mask = (byte)(mask | 4);
                }
            }
        }
        TestIssueResourceTransitions.assertEquals((int)mask, (int)7);
    }

    public void testTransitionGET() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        IssueTransitionsMeta transitions = this.transitionsClient.get("HSP-1");
        TestIssueResourceTransitions.assertEquals((int)3, (int)transitions.transitions.size());
        int mask = 0;
        for (IssueTransitionsMeta.Transition transition : transitions.transitions) {
            switch (transition.id) {
                case 2: {
                    TestIssueResourceTransitions.assertEquals((String)"Close Issue", (String)transition.name);
                    Map closeIssue = transition.fields;
                    TestIssueResourceTransitions.assertEquals((int)3, (int)closeIssue.size());
                    TestIssueResourceTransitions.assertNotNull(closeIssue.get("resolution"));
                    TestIssueResourceTransitions.assertEquals((String)"resolution", (String)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"resolution")).schema.type);
                    TestIssueResourceTransitions.assertTrue((boolean)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"resolution")).required);
                    TestIssueResourceTransitions.assertNotNull(closeIssue.get("fixVersions"));
                    TestIssueResourceTransitions.assertEquals((String)"array", (String)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"fixVersions")).schema.type);
                    TestIssueResourceTransitions.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"fixVersions")).required);
                    TestIssueResourceTransitions.assertNotNull(closeIssue.get("assignee"));
                    TestIssueResourceTransitions.assertEquals((String)"user", (String)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"assignee")).schema.type);
                    TestIssueResourceTransitions.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)closeIssue.get((Object)"assignee")).required);
                    mask = (byte)(mask | 1);
                    break;
                }
                case 4: {
                    TestIssueResourceTransitions.assertEquals((String)"Start Progress", (String)transition.name);
                    Map startProgress = transition.fields;
                    TestIssueResourceTransitions.assertEquals((int)0, (int)startProgress.size());
                    mask = (byte)(mask | 2);
                    break;
                }
                case 5: {
                    TestIssueResourceTransitions.assertEquals((String)"Resolve Issue", (String)transition.name);
                    Map resolveIssue = transition.fields;
                    TestIssueResourceTransitions.assertEquals((int)3, (int)resolveIssue.size());
                    TestIssueResourceTransitions.assertNotNull(resolveIssue.get("resolution"));
                    TestIssueResourceTransitions.assertEquals((String)"resolution", (String)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"resolution")).schema.type);
                    TestIssueResourceTransitions.assertTrue((boolean)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"resolution")).required);
                    TestIssueResourceTransitions.assertNotNull(resolveIssue.get("fixVersions"));
                    TestIssueResourceTransitions.assertEquals((String)"array", (String)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"fixVersions")).schema.type);
                    TestIssueResourceTransitions.assertEquals((String)"version", (String)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"fixVersions")).schema.items);
                    TestIssueResourceTransitions.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"fixVersions")).required);
                    TestIssueResourceTransitions.assertNotNull(resolveIssue.get("assignee"));
                    TestIssueResourceTransitions.assertEquals((String)"user", (String)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"assignee")).schema.type);
                    TestIssueResourceTransitions.assertFalse((boolean)((IssueTransitionsMeta.TransitionField)resolveIssue.get((Object)"assignee")).required);
                    mask = (byte)(mask | 4);
                }
            }
        }
        TestIssueResourceTransitions.assertEquals((int)mask, (int)7);
    }

    public void testTransitionPUT_noComment() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(ResourceRef.withId((String)"2"));
        issueUpdateRequest.fields().resolution(new ResourceRef().name("Won't Fix"));
        issueUpdateRequest.fields().fixVersions((List)Lists.newArrayList((Object[])new ResourceRef[]{new ResourceRef().name("New Version 4"), new ResourceRef().name("New Version 5")}));
        Response response = this.transitionsClient.postResponse("HSP-1", issueUpdateRequest);
        TestIssueResourceTransitions.assertEquals((int)204, (int)response.statusCode);
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        TestIssueResourceTransitions.assertEquals((String)"Closed", (String)issue.fields.status.name());
        TestIssueResourceTransitions.assertEquals((String)"Won't Fix", (String)issue.fields.resolution.name);
        TestIssueResourceTransitions.assertEquals((String)"New Version 4", (String)((Version)issue.fields.fixVersions.get((int)0)).name);
        TestIssueResourceTransitions.assertEquals((String)"New Version 5", (String)((Version)issue.fields.fixVersions.get((int)1)).name);
    }

    public void testTransitionPOST_invalidRole() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.fields(new IssueFields());
        issueUpdateRequest.transition(ResourceRef.withId((String)"2"));
        issueUpdateRequest.fields().resolution(new ResourceRef().name("Won't Fix"));
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.visibility = new Visibility("ROLE", "NON-EXISTING-ROLE");
        jsonComment.body = "My comment";
        this.addCommentOperation("add", operations, jsonComment);
        issueUpdateRequest.update(operations);
        Response response = this.transitionsClient.postResponse("HSP-1", issueUpdateRequest);
        TestIssueResourceTransitions.assertEquals((int)400, (int)response.statusCode);
        String error = (String)response.entity.errors.get("comment");
        TestIssueResourceTransitions.assertTrue((boolean)error.startsWith("Can not construct instance of com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean$VisibilityType from String value 'ROLE': value not one of declared Enum instance names"));
    }

    private void addCommentOperation(String operation, Map<String, List<FieldOperation>> operations, Comment comment) {
        ArrayList<FieldOperation> fieldOperations = new ArrayList<FieldOperation>();
        FieldOperation fieldOperation = new FieldOperation();
        fieldOperation.init(operation, (Object)comment);
        fieldOperations.add(fieldOperation);
        operations.put("comment", fieldOperations);
    }

    public void testBasicTimeTracking() throws Exception {
        this.administration.restoreData("TestRESTTransitionsSimple.xml");
        this.transitionsClient.get("MKY-1");
    }

    public void testTransitionWithMetadata() throws Exception {
        this.administration.restoreBlankInstance();
        this.backdoor.project().addProject("TRANSITION", "TRANSITION", "admin");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("TRANSITION", "summary");
        this.transitionsClient.postResponse(issue.key(), new IssueUpdateRequest().transition(ResourceRef.withId((String)"4")).historyMetadata(HistoryMetadata.builder((String)"transitionMetadataTest").build()));
        JsonNode metadata = this.backdoor.issueNavControl().getHistoryMetadata(issue.key).get(0);
        Assert.assertThat((Object)metadata.get("type").asText(), (Matcher)CoreMatchers.equalTo((Object)"transitionMetadataTest"));
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.transitionsClient = new TransitionsClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

