/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceTimeTracking
extends RestFuncTest {
    private IssueClient issueClient;

    public void testTimeTrackingDisabled() throws Exception {
        this.restoreData(false);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNull((String)"Time tracking shouldn't be in response when time tracking is disabled", (Object)issue.fields.timetracking);
    }

    public void testIssueWithNoTimeTracking() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-1", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNull((Object)issue.fields.timetracking.originalEstimate);
        TestIssueResourceTimeTracking.assertNull((Object)issue.fields.timetracking.remainingEstimate);
        TestIssueResourceTimeTracking.assertNull((Object)issue.fields.timetracking.timeSpent);
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.progress);
        TestIssueResourceTimeTracking.assertEquals((Object)0L, (Object)issue.fields.progress.total());
        TestIssueResourceTimeTracking.assertEquals((Object)0L, (Object)issue.fields.progress.progress());
        TestIssueResourceTimeTracking.assertNull((Object)issue.fields.progress.percent());
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.aggregateprogress);
        TestIssueResourceTimeTracking.assertEquals((Object)0L, (Object)issue.fields.aggregateprogress.total());
        TestIssueResourceTimeTracking.assertEquals((Object)0L, (Object)issue.fields.aggregateprogress.progress());
        TestIssueResourceTimeTracking.assertNull((Object)issue.fields.aggregateprogress.percent());
    }

    public void testIssueWithOriginalEstimate() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.timetracking);
        TestIssueResourceTimeTracking.assertEquals((String)"3d", (String)issue.fields.timetracking.originalEstimate);
    }

    public void testIssueWithTimeSpent() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.timetracking);
        TestIssueResourceTimeTracking.assertEquals((String)"1d", (String)issue.fields.timetracking.timeSpent);
    }

    public void testIssueWithTimeRemaining() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-3", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.timetracking);
        TestIssueResourceTimeTracking.assertEquals((String)"2d", (String)issue.fields.timetracking.remainingEstimate);
    }

    public void testProgressWithSubtasks() throws Exception {
        this.restoreData(true);
        Issue issue = this.issueClient.get("FUNC-4", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.progress);
        TestIssueResourceTimeTracking.assertEquals((Object)36000L, (Object)issue.fields.progress.total());
        TestIssueResourceTimeTracking.assertEquals((Object)7200L, (Object)issue.fields.progress.progress());
        TestIssueResourceTimeTracking.assertEquals((Object)20L, (Object)issue.fields.progress.percent());
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.aggregateprogress);
        TestIssueResourceTimeTracking.assertEquals((Object)43200L, (Object)issue.fields.aggregateprogress.total());
        TestIssueResourceTimeTracking.assertEquals((Object)14400L, (Object)issue.fields.aggregateprogress.progress());
        TestIssueResourceTimeTracking.assertEquals((Object)33L, (Object)issue.fields.aggregateprogress.percent());
        issue = this.issueClient.get("FUNC-5", new Issue.Expand[0]);
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.progress);
        TestIssueResourceTimeTracking.assertEquals((Object)7200L, (Object)issue.fields.progress.total());
        TestIssueResourceTimeTracking.assertEquals((Object)7200L, (Object)issue.fields.progress.progress());
        TestIssueResourceTimeTracking.assertEquals((Object)100L, (Object)issue.fields.progress.percent());
        TestIssueResourceTimeTracking.assertNotNull((Object)issue.fields.aggregateprogress);
        TestIssueResourceTimeTracking.assertEquals((Object)7200L, (Object)issue.fields.aggregateprogress.total());
        TestIssueResourceTimeTracking.assertEquals((Object)7200L, (Object)issue.fields.aggregateprogress.progress());
        TestIssueResourceTimeTracking.assertEquals((Object)100L, (Object)issue.fields.aggregateprogress.percent());
    }

    protected void restoreData(boolean timeTrackingEnabled) throws IOException {
        this.administration.restoreData("TestIssueResourceTimeTracking.xml");
        if (!timeTrackingEnabled) {
            this.administration.timeTracking().disable();
        }
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

