/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueLink;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceSubtasks
extends RestFuncTest {
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.administration.restoreData("TestIssueResourceSubtasks.xml");
    }

    public void testSubtaskLink() throws Exception {
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        List subtasks = issue.fields.subtasks;
        TestIssueResourceSubtasks.assertEquals((int)1, (int)subtasks.size());
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        IssueLink.IssueLinkRef lnkHsp2 = (IssueLink.IssueLinkRef)subtasks.get(0);
        TestIssueResourceSubtasks.assertEquals((String)"HSP-2", (String)lnkHsp2.key());
        TestIssueResourceSubtasks.assertEquals((String)(baseUrl + "/rest/api/2/issue/10001"), (String)lnkHsp2.self());
    }

    public void testParentLink() throws Exception {
        Issue issue = this.issueClient.get("HSP-2", new Issue.Expand[0]);
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        IssueLink.IssueLinkRef parent = issue.fields.parent;
        TestIssueResourceSubtasks.assertEquals((String)"HSP-1", (String)parent.key());
        TestIssueResourceSubtasks.assertEquals((String)(baseUrl + "/rest/api/2/issue/10000"), (String)parent.self());
    }
}

