/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.google.common.collect.Sets;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceSchema
extends FuncTestCase {
    private IssueClient issueClient;

    public void testIssueRepresentationShouldContainExpandableSchemaField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        Issue minimal = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertThat((String)"names should not be expanded by default", (Object)minimal.schema, (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)minimal.expand, (Matcher)Matchers.containsString((String)Issue.Expand.schema.name()));
        Issue hsp1_expanded = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.schema});
        Set fields = hsp1_expanded.fields.idSet();
        Set schema = hsp1_expanded.schema.keySet();
        TestIssueResourceSchema.assertTrue((String)("Found in 'schema' but not in 'fields'" + Sets.difference(schema, (Set)fields)), (boolean)Sets.difference(schema, (Set)fields).isEmpty());
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

