/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.LinkGroup;
import com.atlassian.jira.testkit.client.restclient.SimpleLink;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestIssueResourceOpsbar
extends RestFuncTest {
    private IssueClient issueClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    public void testLoggedIn() throws Exception {
        this.administration.restoreData("TestOpsBar.xml");
        Issue issue = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.operations});
        List linkGroups = issue.operations.getLinkGroups();
        TestIssueResourceOpsbar.assertEquals((int)2, (int)linkGroups.size());
        LinkGroup opsbarGroup = (LinkGroup)linkGroups.get(0);
        TestIssueResourceOpsbar.assertEquals((String)"view.issue.opsbar", (String)opsbarGroup.getId());
        TestIssueResourceOpsbar.assertNoLinks(opsbarGroup);
        List opsBarGroups = opsbarGroup.getGroups();
        TestIssueResourceOpsbar.assertEquals((int)5, (int)opsBarGroups.size());
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsBarGroups.get(0), "edit-issue");
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsBarGroups.get(1), "comment-issue");
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsBarGroups.get(2), "assign-issue");
        LinkGroup transitions = (LinkGroup)opsBarGroups.get(3);
        if (this.isReferencePluginEnabled()) {
            TestIssueResourceOpsbar.assertGroupContainsLinkIds(transitions, "reference-transition-item", "action_id_4");
        } else {
            TestIssueResourceOpsbar.assertGroupContainsLinkIds(transitions, "action_id_4", "action_id_5");
        }
        List workflowGroups = transitions.getGroups();
        TestIssueResourceOpsbar.assertEquals((int)1, (int)workflowGroups.size());
        TestIssueResourceOpsbar.assertEquals((String)"opsbar-transitions_more", (String)((LinkGroup)workflowGroups.get((int)0)).getHeader().id);
        TestIssueResourceOpsbar.assertEquals((int)1, (int)((LinkGroup)workflowGroups.get(0)).getGroups().size());
        if (this.isReferencePluginEnabled()) {
            TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)((LinkGroup)workflowGroups.get(0)).getGroups().get(0), "action_id_5", "action_id_2");
        } else {
            TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)((LinkGroup)workflowGroups.get(0)).getGroups().get(0), "action_id_2");
        }
        TestIssueResourceOpsbar.assertAdminMenu((LinkGroup)opsBarGroups.get(4));
        TestIssueResourceOpsbar.assertToolsGroup((LinkGroup)linkGroups.get(1));
    }

    public void testCanEditWhenNotLoggedIn() throws Exception {
        this.administration.restoreData("TestOpsBar.xml");
        this.navigation.logout();
        Issue issue = ((IssueClient)this.issueClient.anonymous()).get("ANONED-1", new Issue.Expand[]{Issue.Expand.operations});
        List linkGroups = issue.operations.getLinkGroups();
        TestIssueResourceOpsbar.assertEquals((int)2, (int)linkGroups.size());
        LinkGroup opsbarGroup = (LinkGroup)linkGroups.get(0);
        TestIssueResourceOpsbar.assertEquals((String)"view.issue.opsbar", (String)opsbarGroup.getId());
        TestIssueResourceOpsbar.assertNoLinks(opsbarGroup);
        TestIssueResourceOpsbar.assertEquals((int)4, (int)opsbarGroup.getGroups().size());
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsbarGroup.getGroups().get(0), "edit-issue");
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsbarGroup.getGroups().get(1), "edit-labels");
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(2));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(3));
        List workflowGroups = ((LinkGroup)opsbarGroup.getGroups().get(2)).getGroups();
        TestIssueResourceOpsbar.assertEquals((int)1, (int)workflowGroups.size());
        TestIssueResourceOpsbar.assertEquals((String)"opsbar-transitions_more", (String)((LinkGroup)workflowGroups.get((int)0)).getHeader().id);
        TestIssueResourceOpsbar.assertNoGroups((LinkGroup)workflowGroups.get(0));
        TestIssueResourceOpsbar.assertToolsGroup((LinkGroup)linkGroups.get(1));
    }

    public void testCannotEditWhenNotLoggedIn() throws Exception {
        this.administration.restoreData("TestOpsBar.xml");
        this.navigation.logout();
        Issue issue = ((IssueClient)this.issueClient.anonymous()).get("ANON-1", new Issue.Expand[]{Issue.Expand.operations});
        List linkGroups = issue.operations.getLinkGroups();
        TestIssueResourceOpsbar.assertEquals((int)2, (int)linkGroups.size());
        LinkGroup opsbarGroup = (LinkGroup)linkGroups.get(0);
        TestIssueResourceOpsbar.assertEquals((String)"view.issue.opsbar", (String)opsbarGroup.getId());
        TestIssueResourceOpsbar.assertNoLinks(opsbarGroup);
        TestIssueResourceOpsbar.assertEquals((int)4, (int)opsbarGroup.getGroups().size());
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)opsbarGroup.getGroups().get(0), "ops-login-lnk");
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(1));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(2));
        TestIssueResourceOpsbar.assertNoLinks((LinkGroup)opsbarGroup.getGroups().get(3));
        List workflowGroups = ((LinkGroup)opsbarGroup.getGroups().get(2)).getGroups();
        TestIssueResourceOpsbar.assertEquals((int)1, (int)workflowGroups.size());
        TestIssueResourceOpsbar.assertEquals((String)"opsbar-transitions_more", (String)((LinkGroup)workflowGroups.get((int)0)).getHeader().id);
        TestIssueResourceOpsbar.assertNoGroups((LinkGroup)workflowGroups.get(0));
        TestIssueResourceOpsbar.assertToolsGroup((LinkGroup)linkGroups.get(1));
    }

    private static void assertAdminMenu(LinkGroup adminGroups) {
        TestIssueResourceOpsbar.assertNoLinks(adminGroups);
        TestIssueResourceOpsbar.assertEquals((int)1, (int)adminGroups.getGroups().size());
        LinkGroup realAdminGroup = (LinkGroup)adminGroups.getGroups().get(0);
        TestIssueResourceOpsbar.assertGroupContainsLinkIds((LinkGroup)realAdminGroup.getGroups().get(0), "com.atlassian.jira.jira-project-config-plugin:add-custom-field");
    }

    private boolean isReferencePluginEnabled() {
        return this.administration.plugins().referencePlugin().isInstalled() && this.administration.plugins().referencePlugin().isEnabled();
    }

    private static void assertToolsGroup(LinkGroup toolsGroup) {
        TestIssueResourceOpsbar.assertEquals((String)"jira.issue.tools", (String)toolsGroup.getId());
        TestIssueResourceOpsbar.assertGroupContainsLinkLabels(TestIssueResourceOpsbar.getOnlyGroup(toolsGroup), "XML", "Word", "Printable");
    }

    private static LinkGroup getOnlyGroup(LinkGroup group) {
        TestIssueResourceOpsbar.assertEquals((int)1, (int)group.getGroups().size());
        return (LinkGroup)group.getGroups().get(0);
    }

    private static void assertGroupContainsLinkIds(LinkGroup group, String ... linkIds) {
        List ids = Lists.transform((List)group.getLinks(), (Function)new Function<SimpleLink, String>(){

            public String apply(@Nullable SimpleLink simpleLink) {
                return simpleLink.id;
            }
        });
        TestIssueResourceOpsbar.assertTrue((boolean)ids.containsAll(Arrays.asList(linkIds)));
    }

    private static void assertGroupContainsLinkLabels(LinkGroup group, String ... linkLabels) {
        List labels = Lists.transform((List)group.getLinks(), (Function)new Function<SimpleLink, String>(){

            public String apply(@Nullable SimpleLink simpleLink) {
                return simpleLink.label;
            }
        });
        TestIssueResourceOpsbar.assertTrue((boolean)labels.containsAll(Arrays.asList(linkLabels)));
    }

    private static void assertNoLinks(LinkGroup group) {
        TestIssueResourceOpsbar.assertTrue((boolean)group.getLinks().isEmpty());
    }

    private static void assertNoGroups(LinkGroup group) {
        TestIssueResourceOpsbar.assertTrue((boolean)group.getGroups().isEmpty());
    }
}

