/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.Notification;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.NotifyClient;
import com.icegreen.greenmail.store.FolderException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.EMAIL})
public final class TestIssueResourceNotify
extends EmailFuncTestCase {
    private static final String TEST_XML = "TestIssueResourceNotify.xml";
    private static final String HSP_1_KEY = "HSP-1";
    private static final String HSP_1_SUMMARY = "i think i'm being watched";
    public static final String NOTIFICATION_GROUP = "notification-group";
    public static final String JACK_EMAIL = "jack@example.com";
    private final Notification notification = new Notification().textBody("Text Body").htmlBody("<strong>Html Body</strong>");
    private NotifyClient notifyClient;

    public void testNotificationUsingNotificationScheme() throws Exception {
        this.testNotification(this.notification, true, JACK_EMAIL, "fred@example.com", "scheme@example.com");
    }

    public void ignored_testNotificationToEmail() throws Exception {
        this.testNotification(this.notification.toEmail("admin@stuff.com.com"), true, "admin@stuff.com.com");
    }

    public void testNotificationToUser() throws Exception {
        this.testNotification(this.notification.toUser("fred"), true, "fred@example.com");
    }

    public void testNotificationToUserAsText() throws Exception {
        this.backdoor.userProfile().changeUserNotificationType("fred", "text");
        this.testNotification(this.notification.toUser("fred"), false, "fred@example.com");
    }

    public void testNotificationToGroup() throws Exception {
        this.testNotification(this.notification.toGroup(NOTIFICATION_GROUP), true, "fred@example.com");
    }

    public void testNotificationToReporter() throws Exception {
        this.testNotification(this.notification.toReporter(), true, JACK_EMAIL);
    }

    public void testNotificationToAssignee() throws Exception {
        this.testNotification(this.notification.toAssignee(), true, "fred@example.com");
    }

    public void testNotificationToWatchers() throws Exception {
        this.testNotification(this.notification.toWatchers(), true, JACK_EMAIL, "fred@example.com");
    }

    public void testNotificationToVoters() throws Exception {
        this.testNotification(this.notification.toVoters(), true, "fred@example.com");
    }

    public void testNotificationRestrictingByGroup() throws Exception {
        this.testNotification(this.notification.toWatchers().restrictToGroup(NOTIFICATION_GROUP), true, "fred@example.com");
    }

    public void testNotificationRestrictingByPermissionId() throws Exception {
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-users");
        this.testNotification(this.notification.toWatchers().restrictToPermission(10), true, JACK_EMAIL);
    }

    public void testNotificationRestrictingByPermissionName() throws Exception {
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-users");
        this.testNotification(this.notification.toWatchers().restrictToPermission("BROWSE"), true, JACK_EMAIL);
    }

    public void testNotificationWithNonDefaultSubject() throws Exception {
        this.testNotification(this.notification.toUser("fred").subject("A non default subject"), true, "fred@example.com");
    }

    private void testNotification(Notification notification, boolean html, String ... mailboxes) throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse(HSP_1_KEY, notification);
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        this.flushMailQueueAndWait(mailboxes.length);
        for (String mailbox : mailboxes) {
            this.checkMailBox(mailbox, notification, html);
        }
        Assert.assertThat((Object)this.mailService.getReceivedMessages().length, (Matcher)IsEqual.equalTo((Object)0));
    }

    public void testNotificationOnNonExistingIssue() throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("NO-1", this.notification);
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    public void testNotificationWithNoBrowsePermissionOnIssue() throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("luser")).postResponse("MKY-1", this.notification);
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    public void testNotificationWithNonExistingUser() throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.toUser("a-funky-user-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    public void testNotificationWithNonExistingGroup() throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.toGroup("a-funky-group-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    public void testNotificationWithNonExistingRestrictingGroup() throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.restrictToGroup("a-funky-group-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    public void testNotificationWithNonExistingPermission() throws Exception {
        Response response = ((NotifyClient)this.notifyClient.loginAs("admin")).postResponse("MKY-1", this.notification.restrictToPermission("a-funky-permission-name"));
        Assert.assertThat((Object)response.statusCode, (Matcher)IsEqual.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    private void checkMailBox(String email, Notification notification, boolean html) throws FolderException, MessagingException {
        EmailFuncTestCase.MailBox mailBox = this.getMailBox(email);
        MimeMessage message = mailBox.awaitMessage();
        TestIssueResourceNotify.assertEquals((String)message.getSubject(), (String)(StringUtils.isNotBlank((String)notification.subject) ? "[JIRATEST] " + notification.subject : "[JIRATEST] (HSP-1) i think i'm being watched"));
        this.assertMessageAndType(message, html ? notification.htmlBody : notification.textBody, html);
        mailBox.clear();
    }

    protected void restoreData() {
        this.administration.restoreData(TEST_XML);
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.notifyClient = new NotifyClient(this.getEnvironmentData());
        this.restoreData();
        this.configureAndStartSmtpServer();
    }
}

